//
// OpcomChannel.h
//
// $Id: //poco/1.2/Foundation/include/Poco/OpcomChannel.h#1 $
//
// Library: Foundation
// Package: Logging
// Module:  OpcomChannel
//
// Definition of the OpcomChannel class specific to OpenVMS.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_OpcomChannel_INCLUDED
#define Foundation_OpcomChannel_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/Channel.h"


namespace Poco {


class Foundation_API OpcomChannel: public Channel
	/// A OpenVMS-only channel that uses the OpenVMS OPCOM service.
{
public:
	OpcomChannel();
		/// Creates an OpcomChannel that uses the OPC$M_NM_CENTRL
		/// target.
		
	OpcomChannel(int target);
		/// Creates an OpcomChannel that uses the given target.
		/// Specify one of the OPC$M_NM_* values.
		/// See also setProperty().
		
	void log(const Message& msg);
		/// Logs the given message using the OpenVMS OPCOM service.
		
	void setProperty(const std::string& name, const std::string& value);
		/// Sets the property with the given name. 
		/// 
		/// The only supported property is "target", which must
		/// be set to one of the following values:
		///
		///   * CARDS:    Card device operator
		///   * CENTRL:   Central operator
		///   * SECURITY: Security operator
		///   * CLUSTER:  OpenVMS Cluster operator
		///   * DEVICE:   Device status information
		///   * DISKS:    Disks operator
		///   * NTWORK:   Network operator
		///   * TAPES:    Tapes operator
		///   * PRINT:    Printer operator
		///   * OPER1 .. 
		///   * OPER12:   System-manager-defined operator functions

	std::string getProperty(const std::string& name) const;
		/// Returns the value of the property with the given name.
		/// See setProperty() for a description of the supported
		/// properties.

	static const std::string PROP_TARGET;
		
protected:
	~OpcomChannel();
	
private:
	int _target;
};


} // namespace Poco


#endif // Foundation_OpcomChannel_INCLUDED
