#ifndef _WCENETWORK_H_
#define _WCENETWORK_H_

#define __USE_W32_SOCKETS
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>

#include "sys/wcetypes.h"
#include "sys/wcebase.h"
#include "sys/wcefile.h"

typedef UInt SOCKET;
#define INVALID_SOCKET  (SOCKET)(~0)
#define SOCKET_ERROR    (-1)

#define WSADESCRIPTION_LEN   (256)
#define WSASYS_STATUS_LEN    (128)

typedef struct WSAData {
  WORD      wVersion;
  WORD      wHighVersion;
  char      szDescription[WSADESCRIPTION_LEN+1];
  char      szSystemStatus[WSASYS_STATUS_LEN+1];
  UShort    iMaxSockets;
  UShort    iMaxUdpDg;
  char     *lpVendorInfo;
} WSADATA;

#ifndef FD_SETSIZE
#define FD_SETSIZE	64
#endif
typedef struct fd_set {
        u_int   fd_count;               /* how many are SET? */
        SOCKET  fd_array[FD_SETSIZE];   /* an array of SOCKETs */
} fd_set;

#ifdef __cplusplus
extern "C" {
#endif

int M$_accept(SOCKET, struct sockaddr *, int *);
int M$_bind(SOCKET, const struct sockaddr *, int);
int M$_connect(SOCKET, const struct sockaddr *, int);
struct hostent *M$_gethostbyaddr(const char *, int, int);
struct hostent *M$_gethostbyname(const char *);
int M$_gethostname(char *, size_t);
int M$_getpeername(SOCKET, struct sockaddr *, int *);
int M$_getsockname(SOCKET, struct sockaddr *, int *);
int M$_getsockopt(SOCKET, int, int, char *, int *);
int M$_ioctlsocket(SOCKET, long, unsigned long);
int M$_listen(SOCKET, int);
int M$_recv(SOCKET, char *, int, int);
int M$_recvfrom(SOCKET, char *, int, int, struct sockaddr *, int*);
int M$_select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int M$_send(SOCKET, char *, int, int);
int M$_sendto(SOCKET, char *, int, int, struct sockaddr *, int);
int M$_setsockopt(SOCKET, int, int, char *, int);
int M$_shutdown(SOCKET, int);
SOCKET M$_socket(int, int, int);

/* M$ ping replacement API */
typedef struct ip_option_information_s {
  unsigned char  Ttl;             /* Time To Live */
  unsigned char  Tos;             /* Type Of Service */
  unsigned char  Flags;           /* IP header flags */
  unsigned char  OptionsSize;     /* Size in bytes of options data */
  unsigned char *OptionsData;     /* Pointer to options data */
} ip_option_information_t;
typedef ip_option_information_t IP_OPTION_INFORMATION, *PIP_OPTION_INFORMATION;

typedef struct icmp_echo_reply_s {
  unsigned long  Address;         /* Replying address */
  unsigned long  Status;          /* Reply IP_STATUS */
  unsigned long  RoundTripTime;   /* RTT in milliseconds */
  unsigned short DataSize;        /* Reply data size in bytes */
  unsigned short Reserved;        /* Reserved for system use */
  void           *Data;           /* Pointer to the reply data */
  IP_OPTION_INFORMATION Options;  /* Reply options */
} icmp_echo_reply_t;
typedef icmp_echo_reply_t ICMP_ECHO_REPLY, *PICMP_ECHO_REPLY;


BOOL   IcmpCloseHandle(HANDLE);
HANDLE IcmpCreateFile(VOID);
DWORD  IcmpSendEcho(HANDLE, unsigned long, LPVOID, WORD, PIP_OPTION_INFORMATION, LPVOID, DWORD, DWORD);
int WSAGetLastError();
int WSAStartup(WORD, WSADATA *);
#ifdef __cplusplus
}
#endif
#endif  /* _WCENETWORK_H_ */
