/**
 *
 * @file     playground.c
 * @brief    playground applet main file
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Thu Sep 22, 2005 21:25
 *
 * Copyright (C) 2005, 2006 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <config.h>

#include "playground.h"

#include "interface.h"
#include "player.h"

#include <string.h>

struct playground_t
{
  pg_gui_t *gui;                /* user interface */
  pg_player_t *player;          /* player hooks */
};

playground_t*
playground_create (void)
{
  playground_t *pg;

  pg = g_new0 (playground_t, 1);
  if (pg)
    {
      pg->gui = gui_create ();
      pg->player = player_create ();
    }

  return pg;
}

void
playground_destroy (playground_t *pg)
{
  gui_destroy (pg->gui);
  player_destroy (pg->player);
  g_free(pg);
}

pg_gui_t*
playground_gui (playground_t *pg)
{
  return pg ? pg->gui : 0;
}

pg_player_t*
playground_player (playground_t *pg)
{
  return pg ? pg->player : 0;
}
