/**
 *
 * @file     playerctrl.h
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Thu Aug 07, 2005 21:20
 * @brief    Playground functions for player's plugins
 *
 * $Id$
 *
 * @if copyright
 *
 * Copyright (C) 2005, 2006 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @endif
 */


#ifndef PLAYER_H_0508072120
#define PLAYER_H_0508072120

#include <glib.h>

/* Forward declarations */
typedef struct pg_player_t pg_player_t;

extern pg_player_t* player_create (void);
extern void player_destroy (pg_player_t *player);

/* Plugin libraries related function */
extern gint player_plugin_count (pg_player_t *player);
extern gchar* player_plugin_description (pg_player_t *player, gint pos);
extern gchar* player_plugin_file (pg_player_t *player, gint pos);
extern gboolean player_plugin_load (pg_player_t *player,
                                    gchar const *plugin_file);
extern void player_plugin_unload (pg_player_t *player);
extern void player_plugin_reload_list (pg_player_t *player);

/* Plugin callbacks related function */
extern void player_start (pg_player_t *player);
extern void player_quit  (pg_player_t *player);
extern void player_prev (pg_player_t *player);
extern void player_play_pause (pg_player_t *player);
extern void player_stop (pg_player_t *player);
extern void player_next (pg_player_t *player);
extern void player_eject (pg_player_t *player);
extern void player_seek (pg_player_t *player, gdouble t);
extern void player_repeat (pg_player_t *player, gboolean active);
extern void player_shuffle (pg_player_t *player, gboolean active);
extern void player_main_win (pg_player_t *player, gboolean toggle);
extern void player_playlist_win (pg_player_t *player, gboolean toggle);
extern void player_show_hide (pg_player_t *player);
extern void player_show_all (pg_player_t *player, gboolean show);
extern void player_preferences (pg_player_t *player);
extern void player_lower_volume (pg_player_t *player);
extern void player_raise_volume (pg_player_t *player);
extern gboolean player_is_running (pg_player_t *player);
extern gboolean player_is_playing (pg_player_t *player);
extern gboolean player_is_paused (pg_player_t *player);
extern gboolean player_is_repeat (pg_player_t *player);
extern gboolean player_is_shuffle (pg_player_t *player);
extern gboolean player_is_main_win (pg_player_t *player);
extern gboolean player_is_playlist_win (pg_player_t *player);
extern gchar* player_track_name (pg_player_t *player);
extern gchar* player_track_album (pg_player_t *player);
extern gchar* player_track_artist (pg_player_t *player);
extern gint player_track_current_time (pg_player_t *player);
extern gint player_track_total_time (pg_player_t *player);

#endif /* PLAYER_H_0508072120 */
