/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
\*************************************************************************/

/*	This is a simple debug change to understand the program flow better.
 *	Everytime a new subfunction will be called, we push it more to the right:
 *	So it might look like this:
 *            13:02::10.880  Info    main (Line 20):          unittest start
 *            13:02::10.880  Info    testfunct1 (Line 22):        subfunction call
 *            13:02::10.881  Info    testfunct1 (Line 23):        the function is doing something...
 *            13:02::10.881  Info    testfunct2 (Line 25):            second subfunction call
 *            13:02::10.881  Info    testfunct2 (Line 26):            the function is doing something...
 *            13:02::10.881  Info    testfunct2 (Line 27):            second subfunction end
 *            13:02::10.881  Info    testfunct1 (Line 29):        subfunction end
 *            13:02::10.881  Info    main (Line 31):          unittest end
 *            ...
 *	TODO:
 *		It might be good idea to save the spacer for all thread independent.
 *		So it could look like this:
 *		...
 *		13:02::10.881  (thread 1)  Info   calculate (Line xx):    is doing something
 *		13:02::10.881  (thread 2)  Info   calculate (Line xx):        is doing something
 *		13:02::10.881  (thread 2)  Info   calculate (Line xx):        is doing something
 *		13:02::10.881  (thread 1)  Info   calculate (Line xx):    is doing something
 *		...
 *		
 *	Additional the msgFileDebug can be used to redirect the debugmessages to file.
 *	Just install this messagehandler like this
 *		qInstallMsgHandler( msgFileDebug );
 */


#ifndef DSTREAMLOGGER_H
#define DSTREAMLOGGER_H

//--- QT4 ---
#include <QtCore/QDebug>

#define dDebug()      DStreamLogger::debugStream(QtDebugMsg,    __FILE__, __LINE__, Q_FUNC_INFO)
#define dWarning()    DStreamLogger::debugStream(QtWarningMsg,  __FILE__, __LINE__, Q_FUNC_INFO)
#define dCritical()   DStreamLogger::debugStream(QtCriticalMsg, __FILE__, __LINE__, Q_FUNC_INFO)
#define dFatal()      DStreamLogger::debugStream(QtFatalMsg,    __FILE__, __LINE__, Q_FUNC_INFO)

#define dStartFunct() DStreamLogger::startFunctionBlock(QtDebugMsg, __FILE__, __LINE__, Q_FUNC_INFO)
#define dEndFunct()   DStreamLogger::endFunctionBlock(QtDebugMsg, __FILE__, __LINE__, Q_FUNC_INFO)


using namespace Qt;

namespace DStreamLogger
{

void
setLogfileName( const QString & fileName );

void
msgFileDebug( QtMsgType, const char * );

QDebug
debugStream( QtMsgType level, const char * fileName, int line, const char * funcinfo );

QDebug
startFunctionBlock( QtMsgType level, const char * fileName, int line, const char * funcinfo );

QDebug
endFunctionBlock( QtMsgType level, const char * fileName, int line, const char * funcinfo );

}

#endif // STREAMLOGGER_H
