/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
\*************************************************************************/

#ifndef DIALOG_ADD_CITY
#define DIALOG_ADD_CITY

//--- LOCAL ---
#include "ui_dlgaddcity.h"
#include "yawpday.h"

//--- QT4 ---
#include <QDialog>
#include <QIcon>

//--- KDE4 ---
#include <plasma/dataengine.h>

class QAbstractButton;
class KProgressDialog;

class DlgAddCity : public QDialog,
                   private Ui::DlgAddCity
{
	Q_OBJECT
public:
	DlgAddCity( QWidget * parent = NULL );
	~DlgAddCity();

	CityWeather getSelectedCity() const;

private Q_SLOTS:
	void slotValidateTextInput(const QString & text);
	void slotFindLocations();
	void dataUpdated(const QString & sAction, const Plasma::DataEngine::Data & data);
	void slotApplySelection(QAbstractButton *);

private:
	void updateLocations( const QVariant & data );
	void enableApply();

	KProgressDialog		  * m_pProgressDlg;
};

#endif
