/***********************************************************************************
* Adjustable Clock: Plasmoid to show date and time in adjustable format.
* Copyright (C) 2008 - 2009 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef ADJUSTABLECLOCK_HEADER
#define ADJUSTABLECLOCK_HEADER

#include "ui_appearance.h"
#include "ui_advanced.h"
#include "ui_clipboard.h"

#include <QList>
#include <QTimer>
#include <QWebPage>
#include <QDateTime>

#include <KMenu>

#include <Plasma/Applet>
#include <Plasma/DataEngine>

#include <plasmaclock/clockapplet.h>

class AdjustableClock : public ClockApplet
{
    Q_OBJECT

    public:
        AdjustableClock(QObject *parent, const QVariantList &args);

        void init();
        void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect);
        void createClockConfigurationInterface(KConfigDialog *parent);
        void connectSource(const QString &timezone);
        void setText(QString text);
        QDateTime currentDateTime();
        QString formatDateTime(const QDateTime dateTime, QString format, bool clean = true);
        QList<QAction*> clipboardActions();
        QList<QAction*> contextualActions();

    public slots:
        void dataUpdated(const QString &name, const Plasma::DataEngine::Data &data);
        void constraintsEvent(Plasma::Constraints constraints);
        void configAccepted();
        void copyToClipboard();
        void insertPlaceholder(QAction *action);
        void loadItem(int index);
        void addItem(bool automatically = false);
        void removeItem();
        void updateControls();
        void toggleState();
        void selectColor();
        void selectFontSize(int size);
        void selectFontFamily(QFont font);
        void setColor(QString color);
        void setFontSize(QString size);
        void setFontFamily(QString font);
        void contentsChanged();
        void formatChanged();
        void selectionChanged();
        void itemSelectionChanged();
        void insertRow();
        void deleteRow();
        void moveRow(bool up);
        void moveRowUp();
        void moveRowDown();
        void updateRow(int row, int column);
        void toolTipAboutToShow();
        void toolTipHidden();
        void copyToClipboard(QAction *action);
        void updateClipboardMenu();
        void updateToolTipContent();
        void updateSize();
        void updateTheme();
        void resetTimeFormat();

    protected:
        void mousePressEvent(QGraphicsSceneMouseEvent *event);
        void changeEngineTimezone(const QString &oldTimezone, const QString &newTimezone);

    private:
        QWebPage m_page;
        QTimer *m_controlsTimer;
        QString m_timeFormat;
        QString m_toolTipFormat;
        QString m_fastCopyFormat;
        QString m_dateTimeString;
        QString m_timeZoneAbbreviation;
        QString m_timeZoneOffset;
        QStringList m_clipboardFormats;
        QStringList m_timeFormatStrings;
        QStringList m_timeFormatNames;
        QDateTime m_dateTime;
        QTime m_sunrise;
        QTime m_sunset;
        QAction* m_clipboardAction;
        KMenu *m_clipboardMenu;
        int m_timeDifference;
        bool m_rescaleContents;
        bool m_paintBackground;
        bool m_toolTipVisible;
        bool m_predefinedFormat;
        Ui::appearance m_appearanceUi;
        Ui::advanced m_advancedUi;
        Ui::clipboard m_clipboardUi;
};

#endif
