/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __PGT_CONTROLLER_H__
#define __PGT_CONTROLLER_H__

#include <glib.h>
#include <glib-object.h>
#include "pgt-model.h"
#include "pgt-view.h"

G_BEGIN_DECLS

#define PGT_TYPE_CONTROLLER                  (pgt_controller_get_gtype ())
#define PGT_CONTROLLER(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PGT_TYPE_CONTROLLER, PgtController))
#define PGT_CONTROLLER_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), PGT_TYPE_CONTROLLER, PgtControllerClass))
#define PGT_IS_CONTROLLER(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PGT_TYPE_CONTROLLER))
#define PGT_IS_CONTROLLER_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), PGT_TYPE_CONTROLLER))
#define PGT_CONTROLLER_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), PGT_TYPE_CONTROLLER, PgtControllerClass))

typedef struct _PgtController PgtController;
typedef struct _PgtControllerClass PgtControllerClass;

GType pgt_controller_get_gtype (void);

PgtController* pgt_controller_new (PgtModel *model, PgtView *view);

gboolean pgt_controller_read_config (PgtController *self);
gboolean pgt_controller_convert (PgtController *self);
gboolean pgt_controller_upload (PgtController *self, gchar const *basedir);

G_END_DECLS

#endif /* __PGT_CONTROLLER_H__ */
