/*
 * News Leech + Decode functions for PIMPPA
 *
 * by ~g / RRR S0R0R1TY Division
 *
 *
 * Uses: suck, uudeview
 *
 *
 */

#include <errno.h>
#include <time.h>
#include <ctype.h>
#include <dirent.h>
#include <fcntl.h>
#include <getopt.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <regex.h>

#include "pimppa.h"
#include "adopt.h"
#include "news.h"
#include "md5.h"

char GroupString[255];				// To match newsgroups

int Verbose=0;

int GainedFiles=0;

extern MYSQL *src_db, *dst_db;

// This is what we currently think important in a news message
struct newsmsg
{
	char *subject;
	char *id;
	char *lines;
};

char Filetypes[1024];

#define TMP_MSGS	"messages.txt"
#define TMP_HDRS	"headers.txt"
#define TMP_DENSE	"dense.txt"

int getncomp(char *string, int howmany, char *component);	
int decode(char *filename, int dstarea, int options);
int addnew(char *fullpath);
bint getfreespace(char *path);
int findmax(char *subject, int *this);
int parse(int destarea, struct newsmsg *linebuf, int messages, int options, bint maxlines);
int dl_servers(char *serverpat, char *grouppat, int options, int wait_after, int wait_secs, char *tmpdir);
int findfilename(regex_t *preq, char *subject, char *fnamebuf, int *curpart, int *maxparts);

int comp(struct newsmsg *a, struct newsmsg *b)
{
	return(strcmp(a->subject,b->subject));
}

/*
 * An ugly function with lots of ad-hoc kludking. 
 * Used to download newsgroups.
 *
 */
int p_dlnews(char *server, char *groups, 
		     int options, int wait_after, int wait_secs)
{
	char tmpdir[PATH_MAX];
	char olddir[PATH_MAX];
	char grouppat[255];
	struct stat st;
	char *value;
	time_t timetemp;
	int retval;
	
	if(groups && groups[0])
		strcpy(GroupString, groups);
	else
		GroupString[0]=0;

    if(options & OPT_KEYNAZI) {
	    printf("[PIMPPA] OPT_KEYNAZI enabled\n");
		if(options & OPT_NAZI) {
	      printf("[PIMPPA] OPT_KEYNAZI overrode OPT_NAZI\n");
		  options ^= OPT_NAZI;
		}
    }
	if(options & OPT_NAZI) {
		printf("[PIMPPA] OPT_NAZI enabled\n");
	}
	if(options & OPT_VERBOSE) {
		printf("[PIMPPA] OPT_VERBOSE enabled\n");
		Verbose=1;
	}
	if(options & OPT_SLOPPY) {	
		printf("[PIMPPA] OPT_SLOPPY enabled\n");
	}
	if(options & OPT_RESTART)
		printf("[PIMPPA] OPT_RESTART enabled\n");
	if(options & OPT_INSERTSUBJECTS)
		printf("[PIMPPA] OPT_INSERTSUBJECTS enabled\n");
	if(options & OPT_LENIENT)
		printf("[PIMPPA] OPT_LENIENT enabled\n");
		
// Init some shit

	Filetypes[0]=0;
	value=p_getmisc(dst_db, P_KEY_FILETYPES);
	if(value)
		strcpy(Filetypes, value);
	else
	{
		p_setmisc(dst_db, P_KEY_FILETYPES, P_FILETYPES);
		strcpy(Filetypes, P_FILETYPES);
	}

	setlinebuf(stdout);
	setlinebuf(stderr);

	umask(002);

	value=p_getmisc(dst_db, P_KEY_TMPDIR);
	if(!value)
		value=P_TMPDIR;

	getcwd(olddir, PATH_MAX);
	if(stat(value, &st)!=0)
		mkdir(value,0770);

	sprintf(tmpdir, "%s%spleech.%d",
		value, (p_checkp(value) ? "" : "/"),
		getpid());
	if(stat(tmpdir, &st)==0)
	{
		fprintf(stderr, "Ugh, %s exists. Remove it.\n",
				tmpdir); 
		return(-1);
	}
	mkdir(tmpdir,0770);
	chdir(tmpdir);

	if(GroupString[0])			// Special match orders for group name?
	{
		sprintf(grouppat, "AND g_name like '%s'", 
				GroupString);
	}
	else
		grouppat[0]=0;
	
	retval=dl_servers(server, grouppat, options, wait_after, wait_secs, tmpdir);
	if(retval==-1)
		fprintf(stderr, "Encountered trouble.\n");
	
	rmdir(tmpdir);
	chdir(olddir);
		
	timetemp=time(NULL);
	printf("Finished: %s\n", ctime(&timetemp));
	printf("Gained Files: %d\n\n",
			GainedFiles);
	fflush(stdout);

	return(0);
}

int dl_servers(char *serverpat, char *grouppat, int options, int wait_after, int wait_secs, char *tmpdir)
{
	FILE *fp, *dp;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	char combuf[BUFFSIZE];
	int densesize=0;
	char *hdrbuf;
	char suckkillfile[PATH_MAX];
	int spaceleft=1;
	struct stat st;
	struct newsmsg *linebuf=NULL;
	int accepted_msgs;

	sprintf(suckkillfile, "%s%ssuckkillfile",
			DATADIR, (p_checkp(DATADIR) ? "" : "/"));

	p_query(dst_db, "SELECT g_name, g_last, area_path, area_id, "
			"  s_name, s_id, s_user, s_pass, area_name "
			"FROM p_groups, p_areas, p_servers "
			"WHERE g_dest=area_id AND g_server=s_id "
			"  AND s_name like '%s' "
			"  %s "
		        "  AND NOT (g_flags & %ld) "
		        "ORDER BY g_name",
		(serverpat ? serverpat : "%%"),
		(grouppat[0] ? grouppat : ""),
		GROUP_DISABLED);
	sql_res=mysql_store_result(dst_db);
	if(!sql_res)
	{
		fprintf(stderr, "%s\n", mysql_error(dst_db));
		return(-1);
	}

	if(mysql_num_rows(sql_res)<=0)
	{
		fprintf(stderr, "No (active) groups match the given patterns.\n");
		return(0);
	}

	// Read newsroup data, fetch group, decode & process the articles
	while((sql_row=mysql_fetch_row(sql_res)))	
	{
		char buffer[QUERY_MAX];
		char dirtmp[PATH_MAX];
		char groupname[255];
		int lastread,i,j;
		int fd,destarea;
		int newlines=0;
		bint maxlines;
		int dlerr;
        int gotSubject,gotID,gotLines,articles;
		time_t timetemp;
		int serverid;
		char *servername, *user, *pass, *areaname;

		if(!spaceleft || !isalnum(sql_row[0][0]))	// Just a safety check
			continue;

		servername=sql_row[4];
		serverid=atoi(sql_row[5]);	
		user=sql_row[6];
		pass=sql_row[7];
		areaname=sql_row[8];

		i=1;dirtmp[0]=0;
		while(getncomp(sql_row[2], i, dirtmp)) // Try to create the directories
		{
//			fprintf(stderr, "Creat: %s %d\n", dirtmp, i);
			mkdir(dirtmp, 0770);
			i++;
		}
		mkdir(sql_row[2], 0770);			// Kludge: Create the last part

		if(stat(sql_row[2], &st)!=0)
		{
			fprintf(stderr, "Unable to create %s\n", sql_row[2]);
			continue;
		}

		dp=fopen("sucknewsrc", "w");		// Create rc for Suck
		if(!dp)
		{
			fprintf(stderr,"Unable to create 'sucknewsrc' to %s\n", tmpdir);
			return(-1);
		}
		// Create groupline
		fprintf(dp, "%s %s\n", 
				sql_row[0], 
				((options & OPT_RESTART) ? "0" : sql_row[1]));
		fclose(dp);

		// Copy suckkillfile to current tmp directory 
		if(stat(suckkillfile, &st)==0)
			p_cp(suckkillfile, ".");

		timetemp=time(NULL);
		printf("[PIMPPA] Date: %s", ctime(&timetemp));
		destarea=atoi(sql_row[3]);

/***** Download article headers *****/

		printf("[PIMPPA] <= Headers of %s\n", sql_row[0]);

		sprintf(combuf, "suck %s %s -g -dd %s "
						"%s%s "
						"%s%s "
						"%s >%s",
				servername, 
				P_SUCKOPTS_HEADER,
				tmpdir, 
				(user[0] ? "-U " : ""), (user[0] ? user : ""),
				(pass[0] ? "-P " : ""), (pass[0] ? pass : ""),
				((options & OPT_QUIET) ? "-q" : ""),
				TMP_HDRS);
		if(system(combuf)!=0)
		{
			fprintf(stderr, "[PIMPPA] nonzero suck exit status. Skipping.\n");
			unlink(TMP_HDRS);
			system("rm -f suck*");
			continue;
		}
		rename("sucknewsrc", "sucknewsrc.done");
		unlink("suckkillfile");		// Not needed anymore

		dp=fopen("sucknewsrc", "w");
		fclose(dp);

/***** Parse dled headers *****/

		printf("[PIMPPA] Sorting headers...\n");

		fp=fopen(TMP_HDRS, "r");
		if(!fp)
		{
			fprintf(stderr, "Unable to open %s for reading!\n", TMP_HDRS);
			continue;
		}
		dp=fopen(TMP_DENSE, "w");
		if(!dp)
		{
			fprintf(stderr, "Unable to open %s for writing!\n", TMP_DENSE);
			continue;
		}

		// Generate a "dense" file out of the headers, with just id,subj
		while((fgets(buffer, QUERY_MAX, fp)))
		{
			if(strncasecmp(buffer, "Subject: ", 9)==0)
			{
				fprintf(dp, "S: %s", &buffer[9]);
				continue;
			}
			if(strncasecmp(buffer, "Message-ID: ", 12)==0)
			{
				fprintf(dp, "I: %s", &buffer[12]);
				continue;
			}
			if(strncasecmp(buffer, "Lines: ", 7)==0)
			{
				fprintf(dp, "L: %s", &buffer[7]);
				continue;
			}
		}
		fclose(fp);
		fclose(dp);

		unlink(TMP_HDRS);			// Don't need this anymore

		// Memory map the dense file
		if((fd=open(TMP_DENSE, O_RDWR))<0)
		{
			fprintf(stderr, "Unable to open %s for mmapping %d\n", TMP_DENSE, fd);
			continue;
		}
		fstat(fd, &st);
		densesize=st.st_size;
		if(densesize<=0)
		{
			close(fd);
			continue;
		}	

		hdrbuf=mmap(0, densesize, PROT_READ|PROT_WRITE, MAP_PRIVATE, fd, 0);
		if(hdrbuf==MAP_FAILED)
		{
			fprintf(stderr, "mmap() of %s failed\n", TMP_DENSE);
			close(fd);
			continue;
		}
//		hdrbuf[densesize]=0;

		newlines=0;
		for(i=0;i<densesize;i++)
			if(hdrbuf[i]=='\n')
				newlines++;

		// Load subject,message_id pointers into a table
		linebuf=malloc((newlines/3)*sizeof(struct newsmsg));
	
		j=0;i=0;gotSubject=gotID=gotLines=0;
		while(j<newlines/3 && i<densesize)
		{
			if(hdrbuf[i]=='S')
			{
				gotSubject=1;
				linebuf[j].subject=&hdrbuf[i];
			}
			else if (hdrbuf[i]=='I')
			{
				gotID=1;
				linebuf[j].id=&hdrbuf[i];
			}
			else if (hdrbuf[i]=='L')
			{
				gotLines=1;
				linebuf[j].lines=&hdrbuf[i];
			}
			
			if(gotSubject && gotID && gotLines)
			{
				j++;
				gotSubject=gotID=gotLines=0;
			}
		
			// Terminate line end with null
			while(i<densesize && hdrbuf[i]!='\n')
				i++;
			if(i<densesize && hdrbuf[i]=='\n')
				hdrbuf[i]=0;
			i++;
		}
		articles=j;

		// Sort the subject,message_id table
		qsort(linebuf, articles, sizeof(struct newsmsg), 
			(int(*)(const void*, const void*)) comp);
		
		// Check free diskspace, conservatively assume
		// that average message line takes 100 bytes, should be
		// ok for binary postings.
		// (Its divided by 2 because we need space for BOTH
		// the temporary file and the decoded files.
		maxlines=(getfreespace(tmpdir)/100)/2;
	
//		printf("maxlines: %d\n", (int)maxlines);
		printf("[PIMPPA] Parsing headers...\n");

		// Find out filenames, check if all parts are around,
		// skip bad looking messages, create suckothermsgs.
		// (Don't accept more than maxlines of message lines)
		accepted_msgs=parse(destarea, linebuf, articles, options, maxlines);

		free(linebuf);
		if(munmap(hdrbuf, densesize))
			perror("munmap() error of hdrbuf");
		close(fd);

		if(accepted_msgs<=0)
		{
			fprintf(stderr, "[PIMPPA] Nothing to download.\n");
			unlink(TMP_DENSE);
			unlink(TMP_MSGS);
			system("rm -f suck*");
			continue;
		}	

/***** Download good articles based on created suckothermsgs ****/

		printf("[PIMPPA] <= Articles of %s to %s...\n", 
			sql_row[0], areaname);
	
		sprintf(combuf, "suck %s %s -dd %s -W %d %d "
						"%s%s "
						"%s%s "
						"%s"
						"-w %d %d >%s",
				servername, 
				P_SUCKOPTS_BODY,
				tmpdir, wait_secs, wait_after,
				(user[0] ? "-U " : ""), (user[0] ? user : ""),
				(pass[0] ? "-P " : ""), (pass[0] ? pass : ""),
				((options & OPT_QUIET) ? "-q " : ""),
				wait_secs*2, wait_after*2, TMP_MSGS);
//		fprintf(stderr, "%s\n", combuf);
		dlerr=system(combuf);						// Fetch messages
		if(dlerr)
			fprintf(stderr, "[PIMPPA] nonzero suck exit status. Not updating g_last ptr.\n");

		if(stat(TMP_MSGS, &st)==0 &&
			(bint)st.st_size>getfreespace(tmpdir))		// Check hd space
		{
			fprintf(stderr, "Eek, file larger than free space! Stopping.\n");
			spaceleft=0;
		}
	
		if(spaceleft)
			if(!decode(TMP_MSGS, destarea, options)) // Decode the message file	
			{
				fprintf(stderr, "Critical error with decode to %s\n", sql_row[2]);
				return(-1);
			}

		// If everything went fine, read & set new group_last pointer
		if(!dlerr)
		{
			dp=fopen("sucknewsrc.done", "r");	// Get the modified rc line
			if(!dp)
			{
				fprintf(stderr, "Unable to open 'sucknewsrc.done' for reading...\n");
				return(-1);
			}
		
			fscanf(dp, "%s %d", groupname, &lastread);
			fclose(dp);

			p_query(dst_db, "UPDATE p_groups SET g_last=%d "
					"WHERE g_name='%s' AND g_server=%d",
				lastread, groupname, serverid);
		}
		else
			system("rm -f suck*");

		printf("\n");
	
		if(options & OPT_INSERTSUBJECTS)
			unlink("pimppasubjects.txt");
		unlink(TMP_DENSE);
		unlink("suckothermsgs");	
		unlink("sucknewsrc");
		unlink("sucknewsrc.done");
		unlink("sucknewsrc.old");
	}
	
	mysql_free_result(sql_res);

	if(spaceleft)
		unlink(TMP_MSGS);
	
	if(options & OPT_INSERTSUBJECTS)
		unlink("pimppasubjects.txt");
	unlink(TMP_DENSE);
	unlink("suckothermsgs");	
	unlink("sucknewsrc");
	unlink("sucknewsrc.done");
	unlink("sucknewsrc.old");

	return(0);
}

/*
 * Returns the n:th component of a string in style /joo/moo/muu
 *
 * NULL if none
 *
 */
int getncomp(char *string, int howmany, char *component)
{
	if(!string || !component)
		return(0);

	if(!string[0])
	{
		component[0]=0;
		return(0);
	}

//	printf("got: %d\n", howmany);

	while(*string!=0 && howmany>0)
	{
		if(string[0]=='/')
		{
			howmany--;
		}
		*component=*string;
		component++; string++;
	}

	*component=0;

	if(howmany==0)
		return(1);
	else
		return(0);
}

/*
 * Decodes the contents of file "filename" to dstarea
 *
 */
int decode(char *filename, int dstarea, int options)
{
	char curdir[PATH_MAX];
	char buffer[BUFFSIZE];
	char tmp_path[PATH_MAX];
	time_t exectime;

	getcwd(curdir, PATH_MAX);
//	printf("cur: %s", curdir);

	sprintf(tmp_path, "%s%sdecode_tmp",
			curdir, (p_checkp(curdir) ? "" : "/"));	
	mkdir(tmp_path,0770);
	
	printf("[PIMPPA] Decoding to %s\n", tmp_path);
	fflush(stdout);

/* ydec dependency disabled as uudeview handles yyencodes these days */
#if 0
#ifdef WITH_YDEC
	// Try to decode the file for yEnc stuff first

	exectime=time(NULL);
	if(Verbose)
		printf("[PIMPPA] Launching ydec at %d\n", (int)exectime);
    sprintf(buffer, "ydec -D %s %s >/dev/null",
            tmp_path, filename);
    system(buffer);                     // Decode to temp dir
	if(Verbose)
		printf("[PIMPPA] ydec took %d sec\n", (int)(time(NULL)-exectime));

#endif
#endif
	
	// Decode typical uuencoded messages
	exectime=time(NULL);
	if(Verbose)
		printf("[PIMPPA] Launching uudeview at %d\n", (int)exectime);	

	sprintf(buffer, "uudeview -m -n -v -i +o -p %s %s >/dev/null", 
			tmp_path, filename);
	system(buffer);						// Decode to temp dir
//	fprintf(stderr, "%s\n", buffer);
	if(Verbose)
		printf("[PIMPPA] uudeview took %d sec\n", (int)(time(NULL)-exectime));

	printf("[PIMPPA] Processing decoded files...\n");
	fflush(stdout);
	exectime=time(NULL);
	GainedFiles+=p_adopt(tmp_path, dstarea, options|OPT_MOVE|OPT_STATS);
	if(Verbose)
		printf("[PIMPPA] Processing took %d secs\n", (int)(time(NULL)-exectime));

	rmdir(tmp_path);
	
//	fprintf(stderr, "Result: %d\n", system(buffer));
	fflush(stdout);
	fflush(stderr);

	return(1);
}

/*
 * Returns free HD space
 *
 */
bint getfreespace(char *path)
{
	struct statfs freest;

	if(!statfs(path,&freest))
		return((bint)freest.f_bsize*(bint)freest.f_bavail);

	return(0);
}

/*
 * This is a rather stupid fuck. If e.g. part 3 is missing
 * but there's a part 4 duplicate, it will think the posting 
 * complete and download. Also, it only understands messages 
 * to belong together if their subjects follow each 
 * other when sorted.
 *
 */
int parse(int destarea, struct newsmsg *linebuf, int messages, int options, bint maxlines)
{
	regex_t preq;
	char fnamebuf[256];
	int i=0,lincnt;
	int howmany=0;
	int maxparts=0;
	int curpart;
	int accepted_msgs=0;
	bint acceptedlines=0;
	FILE *dp;
	FILE *qp=NULL;

	dp=fopen("suckothermsgs", "w");
	if(!dp)
	{
		fprintf(stderr, "Unable to open suckothermsgs for writing\n");
		return(-1);
	}

	if(options & OPT_INSERTSUBJECTS)
	{
		qp=fopen("pimppasubjects.txt", "w");
		if(!qp)
		{
			fclose(dp);
			fprintf(stderr, "Unable to open 'pimppasubjects.txt' for writing\n");
			return(-1);
		}
	}

	regcomp(&preq, Filetypes, REG_ICASE|REG_EXTENDED);

	if((options & OPT_LENIENT) || (options & OPT_SLOPPY))
	{
		printf("[PIMPPA] Using %s mode, taking all articles...\n",
				((options & OPT_SLOPPY) ? "sloppy" : "lenient") );

		for(i=0;i<messages && acceptedlines<=maxlines;i++)
		{
			acceptedlines+=atoi(&linebuf[i].lines[3]);
			fprintf(dp, "%s\n", &linebuf[i].id[3]); 

			if(options & OPT_INSERTSUBJECTS) {
		        if(findfilename(&preq,linebuf[i].subject,
								fnamebuf,&curpart,&maxparts)==RESULT_OK) {
  	  	  	  		fprintf(qp, "%s%c%s%c", fnamebuf, 0,
								linebuf[i].subject, 0);
				}
			}
		}
		if(acceptedlines>maxlines)
			printf("[PIMPPA] HD shortage, not downloading all articles (L)");
		
		fclose(dp);
		if(options & OPT_INSERTSUBJECTS)
		  fclose(qp);
	    regfree(&preq);
		return(messages);
	}

	lincnt=0;
	while(lincnt<messages)
	{
	    char *subject;
			
		howmany=1;
		subject=linebuf[lincnt].subject;
		if(Verbose)
			printf("%s\n", subject);

		if(findfilename(&preq,subject,fnamebuf,&curpart,&maxparts)==RESULT_OK) {
			int chkval;
			int subjval;

//			if(Verbose)
//				printf("  FILE %s\n", fnamebuf);

			if(curpart==0 && maxparts>0)
				howmany=0;

			lincnt++;
			while(lincnt<messages && strstr(linebuf[lincnt].subject, fnamebuf))
			{
				lincnt++;
				howmany++;
			}

			subjval=p_checksubject(src_db, destarea,subject);
			if(subjval<0) {
				if(Verbose)
  	 	  	       printf("  SKIP %s: Rejected keyword found in the subject\n",
				   fnamebuf);
 	 	 	   continue;
			} 

            if(options & OPT_KEYNAZI)
  	  		  chkval=p_checkfile(src_db, destarea, fnamebuf, (options | OPT_NAZI));
  	  		else
			  chkval=p_checkfile(src_db, destarea, fnamebuf, options);
			if(chkval!=RESULT_OK) {
			  // Let p_checksubject override nazimode p_checkfile in positive keyword hit case
			  if(! (chkval == RESULT_NAZI_KILL 
			        && (options & OPT_KEYNAZI) 
				&& (subjval>0) )
			     ) {
				if(Verbose)
					printf("  SKIP %s: %s\n", fnamebuf, Results[chkval]);
				continue;
			  }
			}
			
//			printf("  Found %d of %d pieces \n", howmany, maxparts);
			if(howmany>=maxparts)
			{
				int k, templines;
				
				templines=0;
				for(k=howmany;k>0;k--)
					templines+=atoi(&linebuf[lincnt-k].lines[3]);
				
				if(templines+acceptedlines>maxlines)
				{
					printf("[PIMPPA] HD shortage, not downloading all articles (N)");
					break;
				}
				
				if(Verbose)
					printf("  TAKE %s (%d parts)\n",fnamebuf, 
						(maxparts ? maxparts : 1));

				acceptedlines+=templines;

//				printf("Total lines now %d\n", (int)acceptedlines);

				for(k=howmany;k>0;k--)
				{
					fprintf(dp, "%s\n", &linebuf[lincnt-k].id[3]);
//					printf("  TAKE %s\n", linebuf[lincnt-k].id);
					accepted_msgs++;
				}
				if(options & OPT_INSERTSUBJECTS)
  		 	 	  fprintf(qp, "%s%c%s%c", fnamebuf, 0, subject, 0);
			}
			else
			{
				if(Verbose)
					printf("  ERROR, found only %d of %d parts\n", howmany, maxparts);
			}
		}
		else
		{
			lincnt++;
			if(Verbose)
				printf("  NOMATCH\n");
		}
	}

	if((options & OPT_INSERTSUBJECTS) && qp)
		fclose(qp);
	fclose(dp);
	regfree(&preq);

	if(Verbose)
		printf("[PIMPPA] Accepted %d of %d articles\n", 
			accepted_msgs, messages);

	return(accepted_msgs);
}

/* 
 * Tries to find the maximum part amount of this subject
 * The current part is returned in *this.
 *
 */
int findmax(char *subject, int *this)
{
	regex_t parts;
	regmatch_t partmatch[1];
	char partscratch[256];
	int curpart,maxparts;
	int i,j;
	int gotparts;
	char *tmp=subject;

	curpart=gotparts=maxparts=0;

	regcomp(&parts, "\\([0-9]*/[0-9]*\\)|\\[[0-9]*/[0-9]*\\]", REG_ICASE|REG_EXTENDED);

//	printf("  LOOKFROM %s\n", subject);

	if(!regexec(&parts, tmp, 1, partmatch, 0))
	{
		j=0;
		for(i=partmatch[0].rm_so;i<partmatch[0].rm_eo;i++)
			partscratch[j++]=tmp[i];
		partscratch[j]=0;
		
//		printf("  SCRATCH: %s\n", partscratch);
		if(sscanf(partscratch, "(%d/%d)", &curpart, &maxparts)!=2)
		{
			sscanf(partscratch, "[%d/%d]", &curpart, &maxparts);
		}
//		printf("  FOUND part %d of %d\n", curpart, maxparts);
	}

	*this=curpart;

	regfree(&parts);
	return(maxparts);
}

/* 
 * finds the filename on the subject line, fills it to fnamebuf,
 * and sets the curpart and maxparts if found.
 */
int findfilename(regex_t *preq, char *subject, char *fnamebuf, int *curpart, int *maxparts) 
{
	regmatch_t pmatch[1];
	char *tmp=NULL;
    int laststart=0,lastend=0;

	// Find out where the last matching filename extension on the line starts
	while(regexec(preq, subject, 1, pmatch, 0)!=REG_NOMATCH)
	{
		laststart=pmatch[0].rm_so;
		lastend=pmatch[0].rm_eo;
		tmp=subject;
		subject=&subject[lastend];
	}
	
	// If extension was found, parse backwards to get the filename to fnamebuf
	if(tmp)
	{
		int i,j;
		
		for(i=laststart;
			i>=0 && tmp[i]!=' ' && tmp[i]!='\"' && tmp[i]!='/' && tmp[i]!='\\';
			i--);
			
		i++;
		//if(tmp[i]==' ') i++;
			
		j=0;
		while(i<lastend)
			fnamebuf[j++]=tmp[i++];
		fnamebuf[j]=0;

//		if(Verbose)
//			printf("  FILE %s\n", fnamebuf);

	    // finally, find out the maximum number of parts from the subject line 
		*maxparts=findmax(&tmp[i], curpart);

		return(RESULT_OK);
    } else {
		return(-1);
	}
}

