<?php
/**
 * Polish texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2007  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Michael Paluchowski, http://genealogy.nethut.pl
 * @author Tymoteusz Motylewski www.motylewscy.com
 * @author Katarzyna Adamska <adamska_k AT wp DOT pl>
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.pl.php 1823 2007-10-03 16:57:18Z canajun2eh $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Nie można uzyskać bezpośredniego dostępu do pliku.";
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedconf_head"]		= "Konfiguracja GEDCOM";
$pgv_lang["other_theme"]		= "Inne, wprowadź";
$pgv_lang["performing_update"]		= "Trwa aktualizacja.";
$pgv_lang["config_file_read"]		= "Wczytano plik konfiguracyjny.";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["accpriv_conf"]		= "Dostęp i prywatność";
$pgv_lang["displ_conf"]			= "Wygląd i układ";
$pgv_lang["displ_names_conf"]	= "Nazwiska";
$pgv_lang["displ_comsurn_conf"] = "Najczęstsze nazwiska";
$pgv_lang["displ_layout_conf"]	= "Układ";
$pgv_lang["displ_hide_conf"]	= "Ukryj i pokaż";
$pgv_lang["editopt_conf"]		= "Opcje edycji";
$pgv_lang["useropt_conf"]		= "Opcje użytkownika";
$pgv_lang["contact_conf"]		= "Kontakt";
$pgv_lang["meta_conf"]			= "Strona WWW i ustawienia znacznika META";
$pgv_lang["does_not_exist"]		= "nie istnieje";
$pgv_lang["media_drive_letter"]		= "Ścieżka do multimediów nie zawiera litery dysku; nie można wyświelić multimediów.";
$pgv_lang["db_setup_bad"]		= "Błędna konfiguracja bazy danych. Sprawdź parametry połączenia z bazą danych i skonfiguruj ponownie.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView nie mógł nawiązać połączenia z twoim hostem bazy danych. Sprawdź poprawność ustawień hosta, loginu i hasła.";
$pgv_lang["bad_database_name"]		= "PhpGedView nawiązał połączenie z twoim hostem bazy danych, ale nie mógł połączyć się z bazą danych o podanej nazwie. Sprawdź, czy baza danych istnieje, i czy podany użytkownik ma odpowienie uprawnienia do tej bazy danych.";
$pgv_lang["db"]				= "Baza danych";
$pgv_lang["dbase"]			= "dBase";
$pgv_lang["current_gedcoms"]		= "Bieżące pliki GEDCOM";
$pgv_lang["ged_gedcom"]			= "Plik GEDCOM";
$pgv_lang["ged_title"]			= "Tytuł pliku GEDCOM";
$pgv_lang["ged_config"]			= "Plik konfiguracyjny";
$pgv_lang["ged_search"]			= "Pliki SearchLog";
$pgv_lang["ged_change"]			= "Pliki ChangeLog";
$pgv_lang["ged_privacy"]		= "Plik prywatności";
$pgv_lang["gregorian"]			= "gregoriański";
$pgv_lang["julian"]			= "juliański";
$pgv_lang["config_french"]		= "francuski";
$pgv_lang["jewish"]			= "żydowski";
$pgv_lang["config_hebrew"]		= "hebrajski";
$pgv_lang["jewish_and_gregorian"]	= "żydowski i gregoriański";
$pgv_lang["hebrew_and_gregorian"]	= "hebrajski i gregoriański";
$pgv_lang["hijri"]				= "Hijri";
$pgv_lang["arabic_cal"]				= "arabski";
$pgv_lang["disabled"]			= "Wyłączony";
$pgv_lang["mouseover"]			= "Po najechaniu";
$pgv_lang["mousedown"]			= "Po naciśnięciu";
$pgv_lang["click"]			= "Po kliknięciu";
$pgv_lang["enter_db_pass"]		= "Ze względów bezpieczeństwa przed zmianą ustawień konfiguracyjnych musisz zawsze podać login i hasło.";
$pgv_lang["server_url_note"]	= "Adres URL do twojego katalogu PhpGedView. Zmień ten parametr tylko wtedy, jeśli naprawdę wiesz, co robisz. PhpGedView ustalił wartość tego parametru jako <b>#GUESS_URL#</b>";
$pgv_lang["DBTYPE"]			= "Typ bazy danych";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Typ bazy danych ze sterownikiem PEAR.<br /><br />PhpGedView obsługuje bazy danych MySQL, PostgreSQL i SQLite. MySQL i PostgreSQL wymagają zainstalowania odpowiednich bibliotek w PHP. SQLite jest domyślnie zainstalowany w PHP 5.<br /><br />Jeśli używasz SQLite, nie musisz konfigurować hosta, loginu ani hasła, ale musisz ustawić ścieżkę pliku do swojej bazy danych w polu \"Nazwa bazy danych\".<br /><br />Ustawia zmienną \$DBTYPE w pliku <i>config.php</i>.<br />";
$pgv_lang["DBHOST"]			= "Host bazy danych";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />Adres DNS lub IP komputera, na którym znajduje się twój serwer bazy danych. Ten parametr nie jest brany pod uwagę jeśli korzystasz z bazy danych SQLite.<br /><br />Ustawia zmienną \$DBHOST w pliku <i>config.php</i>.<br />";

$pgv_lang["DBUSER"]			= "Użytkownik bazy danych";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />Nazwa użytkownika bazy danych, wymagana do zalogowania do twojej bazy danych. Ten parametr nie jest brany pod uwagę jeśli korzystasz z bazy danych SQLite.<br /><br />Ustawia zmienną \$DBUSER w pliku <i>config.php</i>.<br />";
$pgv_lang["DBPASS"]			= "Hasło do bazy danych";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />Hasło do bazy danych dla użytkownika podanego w polu #pgv_lang[DBUSER]#. Ten parametr nie jest brany pod uwagę jeśli korzystasz z bazy danych SQLite.<br /><br />Ustawia zmienną \$DBPASS w pliku <i>config.php</i>.<br />";
$pgv_lang["DBNAME"]			= "Nazwa bazy danych";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />Nazwa bazy danych, z której ma korzystać PhpGedView.<br /><br />Użytkownik wprowadzony w polu #pgv_lang[DBUSER]# musi mieć prawa tworzenia, dodawania, modyfikacji, usuwania i wybierania do tej bazy danych. W przypadku SQLite musisz podać nazwę pliku w katalogu, w którym PHP ma prawo zapisu, na przykład głównego katalogu indeksowego (index/phpgedview.db).<br /><br />Ustawia parametr \$DBNAME w pliku <i>config.php</i>.<br />";
$pgv_lang["TBLPREFIX"]			= "Przedrostek tabel bazy danych";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Przedrostek do dołączenia na początku nazw tabel utworzonych przez PhpGedView. Zmieniając tą wartość możesz pozwolić wielu stronom PhpGedView na korzystanie z tej samej fizycznej bazy danych, ale różnych tabel. Na przykład ta sama strona może jednocześnie obsługiwać \"testową\" i \"produkcyjną\" wersję PhpGedView za pomocą zupełnie różnych tabel.<br /><br />Ustawia parametr \$TBLPREFIX w pliku <i>config.php</i>.<br />";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]	= "Zezwól na przełączanie plików GEDCOM";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Jeśli masz środowisko, w którym istnieje wiele plików GEDCOM, wybranie opcji <b>Tak</b> pozwoli odwiedzającym twoją stronę gościnnie <u>oraz</u> użytkownikom na zmianę aktywnego pliku GEDCOM. Wybranie opcji <b>Nie</b> uniemożliwi przełączanie plików GEDCOM <u>zarówno</u> gościom, <u>jak i </u> zalogowanym użytkownikom.<br /><br />Ustawia wartość parametru \$ALLOW_CHANGE_GEDCOM w pliku <i>config.php</i>.<br />";
$pgv_lang["upload_path"]			= "Ścieżka wgrywania";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />To jest ścieżka do miejsca, w którym znajduje się wgrywany plik na twoim komputerze lokalnym. Aby wybrać ścieżkę, kliknij <b>Przeglądaj</b>, odszukaj swój plik GEDCOM i kliknij <b>Otwórz</b>.";
$pgv_lang["gedcom_path"]			= "Ścieżka i nazwa pliku GEDCOM na serwerze";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Istnieją dwa sposoby importowania plików GEDCOM do PhpGedView:<ol><li>Wgraj plik na serwer za pomocą FTP.</li><li>Wgraj plik za pomocą PhpGedView.</li></ol>Kiedy twój plik znajduje się już na serwerze, rozpoczynasz procedurę <i>#pgv_lang[add_gedcom]#</i> i podajesz ścieżkę i nazwę swojego pliku GEDCOM na serwerze. Nazwa może, ale nie musi zawierać rozszerzenia. Jeśli nie podano rozszerzenia, domyślnie przyjmowane jest rozszerzenie .ged. Podanie ścieżki nie jest obowiązkowe. Jeśli nie podano ścieżki, domyślnie przyjmowana jest wartość parametru <i>#pgv_lang[INDEX_DIRECTORY]#</i> (ustawionego w konfiguracji twojej strony PhpGedView). Pamiętaj, że na większości serwerów wielkość liter w ścieżkach i nazwach plików ma znaczenie.<br /><br />Kiedy rozpoczynasz procedurę <i>#pgv_lang[upload_gedcom]#</i> w PhpGedView, możesz użyć przycisku <b>Przeglądaj</b> do odszukania odpowiedniego pliku na twoim komputerze. Może być to zwykły plik GEDCOM lub plik ZIP zawierający plik GEDCOM. PhpGedView automatycznie rozpakuje i użyje pliku GEDCOM zawartego w tym pliku ZIP.<br /><br />Przy wgrywaniu pliku możesz podać inną ścieżkę i/lub nazwę pliku, pod którą chcesz go zapisać na serwerze.<br /><br />Więcej informacji w pliku <a href=\"readme.txt\">Readme.txt</a>.<br />";
$pgv_lang["CHARACTER_SET"]		= "Kodowanie znaków";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />To jest kodowanie twojego pliku GEDCOM. Domyślnym kodowaniem jest UTF-8, które działa dla prawie wszystkich stron. Jeśli używasz kodowania IBM Windows przy eksporcie pliku GEDCOM, wpisz tutaj WINDOWS.<br /><br />Uwaga: PhpGedView nie może obsługiwać UNICODE (UTF-16), ponieważ ten standard nie jest obsługiwany przez PHP.<br />";
$pgv_lang["LANGUAGE"]			= "Język";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Ustaw domyślny język dla strony.<br /><br />Jeśli wybrana jest opcja <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>, użytkownicy mogą nadpisywać to ustawienie poprzez konfigurację preferowanego języka w swojej przeglądarce, ustawienia konfiguracyjne swojego konta lub za pomocą odnośników lub przycisków na większości stron PhpGedView.<br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Zezwalaj użytkownikom na zmianę języka";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Wybierz <b>Tak</b> aby zezwolić użytkownikom na nadpisywanie domyślnego języka strony. Mogą to zrobić przez konfigurację preferowanego języka w swojej przeglądarce, ustawienia konfiguracyjne swojego konta lub za pomocą odnośników lub przycisków na większości stron PhpGedView.<br />";
$pgv_lang["CALENDAR_FORMAT"]		= "Format kalendarza";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Ta opcja pozwala wybrać rodzaj kalendarza, którego chcesz używać dla tego pliku GEDCOM.<br /><br />Kalendarz hebrajski jest identyczny z żydowskim, ale wykorzystuje znaki hebrajskie.<br /><br />Uwaga: daty żydowskie i hebrajskie są obliczane na podstawie dat gregoriańskich lub juliańskich. Ponieważ żydowski dzień kalendarzowy zaczyna się o zmierzchu, każde wydarzenie od zmierzchu do północy zostanie wyświetlone dzień wcześniej w stosunku do poprawnej daty żydowskiej. Wyświetlanie alfabetu hebrajskiego może sprawiać kłopoty starszym przeglądarkom, które mogą wyświetlać tekst od końca (od lewej do prawej) lub wcale.<br />";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Wyświetl hebrajskie tysiące";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Pokaż Alafim w kalendarzach hebrajskich.<br /><br />Wybranie <b>Tak</b> spowoduje wyświetlenie roku 1969 jako <span lang=\"he-IL\" dir=\'rtl\'>&#1492;\'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;, podczas gdy wybranie <b>Nie</b> wyświetli ten rok jako <span lang=\"he-IL\" dir=\'rtl\'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Nie ma to wpływu na ustawienie żydowskiego roku. Rok zostanie wyświetlony jako 5729 niezależnie od tego ustawienia.<br /><br />Ustawia parametr \$DISPLAY_JEWISH_THOUSANDS w pliku <i><u>xxx</u>.GED_conf.php</i>.<br /><br />Uwaga: to ustawienie działa podobnie do stałej kalendarzowej CAL_JEWISH_ADD_ALAFIM w PHP 5.0.<br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Wyświetl hebrajski Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Pokaż pojedyncze i podwójne cudzysłowy przy wyświetlaniu dat hebrajskich.<br /><br />Wybranie <b>Tak</b> spowoduje wyświetlenie February 8 1969 jako <span lang=\'he-IL\' dir=\'rtl\'>&#1499;\'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;, podczas gdy wybranie <b>Nie</b> spowoduje wyświetlenie tej daty jako <span lang=\'he-IL\' dir=\'rtl\'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Nie ma to wpływu na ustawienie żydowskiego roku, ponieważ w żydowskich datach wyświetlonych za pomocą alfabetu łacińskim cudzysłowy nie występują.<br /><br />Ustawia parametr \$DISPLAY_JEWISH_GERESHAYIM w pliku <i><u>xxx</u>.GED_conf.php</i>.<br /><br />Uwaga: to ustawienie działa podobnie do stałych kalendarzowych<br />CAL_JEWISH_ADD_ALAFIM_GERESH i CAL_JEWISH_ADD_GERESHAYIM w PHP 5.0. To ustawienie ma wpływ na obie te stałe.<br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Żydowska wymowa Ashkenaz";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Zastosuj wymowę Ashkenaz.<br /><br />Wybranie <b>Tak</b> spowoduje transliterację miesięcy Cheshvan i Teves według wymowy Ashkenazi. Wybranie <b>Nie</b> spowoduje zmianę tych miesięcy na Hesvan i Tevet. Ma to wpływ wyłącznie na żydowskie ustawienia. Ustawienia hebrajskie bedą zawsze stosować alfabet hebrajski.<br /><br />Ustawia parametr \$JEWISH_ASHKENAZ_PRONUNCIATION w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_RTL_FUNCTIONS"]	= "Zastosuj przetwarzanie RTL (od prawej do lewej)";
$pgv_lang["USE_RTL_FUNCTIONS_help"]	= "~#pgv_lang[USE_RTL_FUNCTIONS]#~<br /><br />Zastosuj przetwarzanie aby poprawnie wyświetlić dane GEDCOM w językach RTL (od prawej do lewej). Wybranie <b>Tak</b>spowoduje przetwarzanie na bieżąco bazy danych, tak, aby zapewnić poprawne wyświetlanie danych. To ustawienie może spowolnić działanie systemu.<br /><br />Ustawia parametr \$USE_RTL_FUNCTIONS w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Liczba pokoleń rodowodu";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Wybierz domyślną liczbę pokoleń, pokazywaną na wykresach rodowodu.<br />";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maksymalna liczba pokoleń rodowodu";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Wybierz maksymalną liczbę pokoleń, pokazywaną na wykresach rodowodu.<br />";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maksymalna liczba pokoleń potomków";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Wybierz maksymalną liczbę pokoleń, pokazywanych na wykresach potomków.<br />";
$pgv_lang["USE_RIN"]			= "Użyj RIN zamiast identyfikatora GEDCOM";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Wybierz <b>Tak</b> jeśli chcesz używać numeru RIN zamiast identyfikatora GEDCOM przy wprowadzaniu identyfikatorów osób w plikach konfiguracyjnych, ustawieniach użytkownika i wykresach. To ustawienie jest przydatne dla aplikacji genealogicznych, które przy eksporcie plików GEDCOM nie przypisują tym samym osobom stałych identyfikatorów, ale zawsze używają tego samego numeru RIN.<br />";
$pgv_lang["GENERATE_GUID"]		= "Automatycznie twórz unikalne identyfikatory globalne";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> w tym kontekście oznacza «indentyfikator unikalny globalnie» (Globally Unique ID).<br /><br />Identyfikatory GUID mają za zadanie identyfikować każdą osobę w powtarzalny sposób, tak, aby organizacje takie jak  mormońskie Family History Center, a nawet kompatybilne programy uruchamiane na twoim własnym serwerze, mogły określić, czy mają do czynienia z tą samą osobą, niezależnie od tego, skąd pochodzi plik GEDCOM. Family History Center dąży do stworzenia centralnego repozytorium informacji genealogicznej i udostępnienia go za pośrednictwem usług sieciowych. Pozwoli to dowolnej aplikacji na dostęp i aktualizację danych w repozytorium.<br /><br />Jeśli nie zamierzasz dzielić się tym plikiem GEDCOM z nikim innym, nie musisz zezwalać PhpGedView na tworzenie identyfikatorów GUIDs, jednak nie przyniesie to żadnej szkody poza nieznacznym zwiększeniem rozmiaru pliku GEDCOM.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Domyślna osoba dla wykresu rodowodu i potomków";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Wybierz identyfikator domyślnej osoby, pokazywanej na wykresach rodowodu i potomków.<br />";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Przedrostek identyfikatora osoby";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Podczas dodawania nowej osoby w PhpGedView jest dla niej automatycznie generowany nowy identyfikator. Identyfikator osoby będzie miał podany przedrostek.<br />";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Przedrostek identyfikatora źródła";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Podczas dodawania nowego źródła w PhpGedView jest dla niego automatycznie generowany nowy identyfikator. Identyfikator źródła będzie miał podany przedrostek.<br />";
$pgv_lang["REPO_ID_PREFIX"]		= "Przedrostek identyfikatora repozytorium";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Podczas dodawania nowego repozytorium PhpGedView jest dla niego automatycznie generowany nowy identyfikator. Identyfikator repozytorium będzie miał podany przedrostek.<br />";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Pokaż szczegóły urodzenia i śmierci na wykresach rodowodu i potomków";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Ta opcja pozwala określić, czy szczegóły urodzenia i śmierci danej osoby mają być domyślnie widoczne.<br />";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Domyślny układ wykresu rodowodu";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Ta opcja pozwala określić, czy wykres rodowodu ma być domyślnie generowany w układzie poziomym, czy pionowym.<br />";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Pokaż puste ramki na wykresach rodowodu";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Ta opcja pozwala określić, czy puste ramki na wykresach rodowodu mają być widoczne.<br />";
$pgv_lang["ZOOM_BOXES"]			= "Powiększaj ramki na wykresach";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Pozwalaj użytkownikom powiększać ramki na wykresie, aby mogli zobaczyć więcej informacji.<br /><br />Wybierz <b>#pgv_lang[disabled]#</b> aby wyłączyć tę opcję. Wybierz <b>#pgv_lang[mouseover]#</b> aby powiększać ramki, kiedy użytkownik najedzie kursorem na ikonkę w ramce. Wybierz  <b>#pgv_lang[click]#</b> aby powiększać ramki, kiedy użytkownik kliknie na ikonkę w ramce.<br />";
$pgv_lang["LINK_ICONS"]			= "Otwieraj odnośniki w nowych oknach na wykresach";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Pozwala użytkownikowi na wybranie odnośników do innych wykresów i bliskich krewnych osoby.<br /><br />Wybierz <b>#pgv_lang[disabled]#</b> aby wyłączyć tę opcję. Wybierz <b>#pgv_lang[mouseover]#</b> aby otwierać odnośnik w nowym oknie, kiedy użytkownik najedzie kursorem na ikonkę w ramce. Wybierz <b>#pgv_lang[click]#</b> aby otwierać odnośnik w nowym oknie, kiedy użytkownik kliknie na ikonkę w ramce.<br />";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Skracaj etykiety na wykresach";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Ta opcja pozwala skracać etykiety na wykresach do ich pierwszej litery, na przykład urodzenie do \"U\".<br />";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Pokaż wiek rodziców obok daty urodzenia dziecka";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Ta opcja określa, czy na wykresach obok daty urodzenia dziecka ma być widoczny wiek ojca i matki.<br />";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Pokaż wydarzenia bliskich na stronie osoby";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Urodzenia, śluby i śmierci bliskich są ważnymi wydarzeniami w życiu każdej osoby. Ta opcja określa, czy te wydarzenia mają być widoczne na zakładce <i>Fakty i szczegóły osoby</i> na stronie osoby.<br /><br />Ta opcja ma wpływ na następujące wydarzenia:<ul><li>śmierć małżonka</li><li>urodzenie i śmierć dziecka</li><li>śmierć rodzica</li><li>urodzenie i śmierć rodzeństwa</li><li>śmierć dziadków</li><li>urodzenie i śmierć rodzeństwa rodziców</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Automatycznie rozwijaj listę wydarzeń bliskich";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Ta opcja określa, czy lista <i>Wydarzenia bliskich</i> ma być automatycznie rozwijana.<br />";
$pgv_lang["EXPAND_SOURCES"]      = "Automatycznie rozwijaj źródła";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Ta opcja określa, czy zawartość wpisu <i>Źródło</i> na stronie osoby.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Włącz ochronę prywatności";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Ta opcja spowoduje włączenie wszystkich ustawień prywatności i ukrycie szczegółów osób żyjących.<br /><br />Osoby żyjące są zdefiniowane jako te, z którymi nie jest związane żadne wydarzenie, które nastąpiłoby później, niż liczba lat określona parametrem \$MAX_ALIVE_AGE. Do celów tych obliczeń za takie wydarzenie uznaje się także narodziny dziecka.<br />";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Wymagaj autoryzacji gościa";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Włączenie tej opcji zmusi wszystkich odwiedzających do zalogowania się zanim będą mogli zobaczyć jakiekolwiek informacje na tej stronie.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Treść powitania na stronie logowania";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Tutaj możesz wybrać treść komunikatu, który pojawi się na ekranie logowania. Musisz określić, który z predefiniowanych komunikatów będzie najlepszy.<br /><br />Możesz także wprowadzić własną treść powitania, jednak wprowadzony przez ciebie tekst nie zostanie przetłumaczony, kiedy użytkownik wybierze inny język strony. Jeśli jednak użyjesz w swoim komunikacie zmiennych językowych, które możesz zdefiniować w różnych plikach <i>languages/extra.xx.php</i>, będzie można wyświetlić odpowiednią wersję językową. Więcej informacji w pomocy do pola <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b>.<br /><br />Predefiniowane treści powitania:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Pomiń predefiniowaną treść";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Predefiniowana treść mówiąca, że każdy może otrzymać konto użytkownika";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Predefiniowana treść mówiąca, że administrator decyduje o otwarciu konta użytkownika";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Predefiniowana treść mówiąca, że tylko członkowie rodziny mogą otrzymać konto użytkownika";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Wybierz własną treść powitania wpisaną poniżej";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Własna treść powitania";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Jeśli wybrałeś(aś) własną treść powitania, możesz wprowadzić ją tutaj. Tekst nie zostanie przetłumaczony na język odwiedzającego i zostanie wyświetlony dokładnie tak, jak go wprowadzisz. Jeśli jednak użyjesz w nim odnośników do zmiennych językowych, które możesz zdefiniować w różnych plikach <i>languages/extra.xx.php</i>, będzie można pokazać różne wersje językowe.<br /><br />Możesz używać znaczników HTML w swojej własnej treści powitania.<br /><br />Poniższy opis, wzięty z pomocy do listy FAQ, odnosi się również do własnej treści powitania.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standardowy nagłówek własnej treści powitania";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Wybierz standardowy nagłówek do twojej własnej treści powitania. Kiedy użytkownik zmieni język, nagłówek zostanie wyświetlony w nowym języku.<br /><br />Jeśli wybierzesz <b>Tak</b>, nagłówek będzie wyglądał następująco:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Pokaż zasady dozwolonego użytku na stronie «Załóż nowe konto»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Wybierz <b>#pgv_lang[yes]#</b> aby pokazać następujący komunikat nad formularzem na stronie «#pgv_lang[requestaccount]#»:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Sprawdź daty dzieci";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Sprawdź daty dzieci przy określaniu, czy dana osoba jeszcze żyje. Na starszych systemach i dużych plikach GEDCOM ta opcja może spowolnić działanie twojej strony.<br />";
$pgv_lang["MAX_ALIVE_AGE"]		= "Wiek, po którym uznać osobę za zmarłą";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Jeśli z tą osobą są powiązane jakiekolwiek wydarzenia poza śmiercią, pogrzebem lub kremacją, które nastąpiły później, niż ta liczba lat, zostanie ona uznana za żyjącą. Do celów tych obliczeń za takie wydarzenie uznaje się także narodziny dziecka.<br />";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Zezwól użytkownikom przeglądać nieprzetworzone wpisy GEDCOM";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Wybierz <b>Tak</b> aby przy osobach, rodzinach i źródłach umieścić odnośniki, które pozwolą użytkownikom otworzyć nowe okno, zawierające dane pobrane bezpośrednio z pliku GEDCOM.<br />";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Automatycznie zamykaj okno edycji";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Ta opcja określa, czy po pomyślnie zakończonej aktualizacji okno edycji ma zostać automatycznie zamknięte.<br />";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Zezwól na edycję online";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Ta opcja udostępnia możliwość edycji online dla tej bazy danych, dzięki czemu użytkownicy z uprawnieniami do edycji mogą modyfikować te dane.<br />";
$pgv_lang["INDEX_DIRECTORY"]		= "Katalog indeksowy";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Ścieżka do katalogu z prawem do zapisu i odczytu, w którym PhpGedView ma przechowywać pliki indeksowe (musi zawierać końcowy znak \"/\"). PhpGedView nie wymaga, aby katalog nazywał się \"index\". Możesz wybrać dowolną nazwę.<br /><br />Ze względów bezpieczeństwa ten katalog powinien być umieszczony w obszarze plikowym serwera, który nie jest dostępny z Internetu. Na przykład takiej struktury:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Indeks:</b> dir1/dir4/dir5/dir6/index<br /><br />Dla powyższego przykładu należy wprowadzić w tym polu ścieżkę <b>../../dir4/dir5/dir6/index/</b><br /><br />Ustawia parametr \$INDEX_DIRECTORY w pliku <i>config.php</i>.<br />";
$pgv_lang["POSTAL_CODE"]  = "Pozycja kodu pocztowego";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Różne kraje używają różnych sposobów zapisu adresu. Ta opcja pozwala umieścić kod pocztowy przed lub po nazwie miasta.<br />";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maksymalna liczba nazwisk dla osób";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Długie listy nazwisk osób o tym samym nazwisku można podzielić na mniejsze podlisty według pierwszej litery imienia.<br /><br />Ta opcja określa, kiedy ma zachodzić ten podział. Aby całkowicie wyłączyć dzielenie na podlisty, ustaw ten parametr na zero.<br />";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maksymalna liczba nazwisk dla rodzin";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Długie listy nazwisk rodzin o tym samym nazwisku można podzielić na mniejsze podlisty według pierwszej litery imienia.<br /><br />Ta opcja określa, kiedy ma zachodzić ten podział. Aby całkowicie wyłączyć dzielenie na podlisty, ustaw ten parametr na zero.<br />";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Styl listy nazwisk";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Listy nazwisk w sekcji #pgv_lang[block_top10]#, #pgv_lang[individual_list]# i #pgv_lang[family_list]# mogą być wyświetlane na różny sposób.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;W tym stylu nazwiska są pokazane w formie tabelki, którą można sortować po nazwisku lub liczniku.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;W tym stylu nazwiska są pokazane w formie listy, w której rozmiar czcionki dla każdego nazwiska zależy od liczby wystąpień tego nazwiska w bazie danych. Listy nie można sortować.</li></ul><br />";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Pobierz wyświetlane imię i nazwisko z pliku GEDCOM";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "~#pgv_lang[NAME_FROM_GEDCOM]#~<br /><br />Zwykle aby wyświetlić imię i nazwisko osoby PhpGedView używa danych przechowywanych w indeksach. W przypadku niektórych formatów i języków imiona i nazwiska przechowywane w indeksach nie są wyświetlane poprawnie - wówczas najlepszym rozwiązaniem jest pobranie danych z pliku GEDCOM.<br /><br />Dobrym przykładem jest notacja hiszpańska, w której dane mogą mieć postać: (Imiona) (Nazwisko ojca) (Nazwisko matki). Wykorzystanie indeksów do sortowania i wyświetlania spowodowałoby (niepoprawne) wyświetlenie tych danych jako: (Imiona) (Nazwisko matki) (Nazwisko ojca). Ponowne pobranie danych z pliku GEDCOM pozwoli uzyskać poprawny zapis, jednak spowolni działanie systemu.<br />";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Ta opcja określa, czy na wykresach i listach po nazwiskach mają być widoczne ujęte w nawiasy identyfikatory.<br />";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Pokaż na listach datę ostatniej zmiany wpisu GEDCOM";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Ta opcja określa, czy na listach ma być widoczna data ostatniej zmiany wpisu GEDCOM.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Liczba poziomów miejsc widoczna w ramkach osoby";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Ta opcja określa, jak wiele informacji o miejscach będzie widoczne na wykresach w ramkach osoby.<br /><br />Ustawienie wartości na 9 zagwarantuje pokazanie wszystkich poziomów hierarchii miejsc. Wartość 0 spowoduje całkowite ukrycie informacji o miejscach. Wartość 1 pozwoli pokazać pierwszy poziom, 2 - pierwsze dwa poziomy, itd.<br />";
$pgv_lang["MULTI_MEDIA"]		= "Włącz obsługę multimediów";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 pozwala dołączać do pliku GEDCOM obrazki, filmy video i inne obiekty multimedialne. Jeśli nie korzystasz z obiektów multimedialnychm, możesz wyłączyć obsługę multimediów wybierając <b>Nie</b>.<br /><br />Więcej informacji na temat wykorzystania multimediów na stronie w sekcji Multimedia pliku <a href=\"readme.txt\">readme.txt</a>.<br />";
$pgv_lang["MEDIA_EXTERNAL"]			= "Zachowaj odnośniki do multimediów";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Jeśli wybierzesz <b>Tak</b>, odnośniki do multimediów zaczynające się na http://, ftp://, mms:// itd. nie zostaną zmienione, na przykład http://www.myfamily.com/photo/dad.jpg pozostanie  http://www.myfamily.com/photo/dad.jpg. Jeśli wybierzesz <b>Nie</b>, odnośnik będzie traktowany jako odniesienie lokalne w katalogu multimediów. Na przykład http://www.myfamily.com/photo/dad.jpg zostanie zmienione na ./media/dad.jpg<br />";
$pgv_lang["MEDIA_DIRECTORY"]		= "Katalog multimediów";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Ścieżka do katalogu z prawem do odczytu i zapisu, w którym PhpGedView ma przechowywać pliki multimedialne (musi zawierać końcowy znak \"/\"). Katalog nie musi nazywać się \"media\". Możesz wybrać dowolną nazwę.<br /><br />Ze względów bezpieczeństwa ten katalog powinien znajdować się w obszarze plikowym serwera niedostępnym z Internetu. Przykład odpowiedniej struktury:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Media:</b> dir1/dir4/dir5/dir6/media<br /><br />Dla powyższego przykładu w to pole należy wprowadzić <b>../../dir4/dir5/dir6/media/</b>.<br />";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Liczba poziomów katalogu multimediów do zachowania";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Wartość 0 spowoduje pominięcie wszystkich katalogów w ścieżce pliku do obiektu multimedialnego. Wartość 1 spowoduje zachowanie pierwszego katalogu zawierającego obiekt. Zwiększanie wartości zwiększa liczbę nadkatalogów, które zostaną zachowane w ścieżce.<br /><br />Na przykład, jeśli w swoim pliku GEDCOM dodasz obrazek ze ścieżką <b>C:\Documents&nbsp;and&nbsp;Settings\User\My&nbsp;Documents\My&nbsp;Pictures\Genealogy\Surname&nbsp;Line\dziadek.jpg</b>, wartość 0 spowoduje zamianę podanej ścieżki na <b>./media/dziadek.jpg</b>. Wartość 1 spowoduje zamianę ścieżki na <b>./media/Surname&nbsp;Line/dziadek.jpg</b>, itd. W większości przypadków najlepiej ustawić 0. Jednak jeśli obiekty multimedialne przechowywane w różnych katalogach mają taką samą nazwę, mogłyby zostać nadpisane kiedy ta opcja jest ustawiona na 0. Ustawienie wartości różnej od zera pozwoli ci zachować potrzebny poziom struktury multimediów, zapobiegając konfliktowi nazw.<br />";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Kiedy włączona jest obsługa multimediów na stronie, PhpGedView może wyświetlać na wykresach i w ramkach miniaturkę zdjęcia obok nazwiska osoby.<br /><br />Obecnie PhpGedView używa pierwszego obiektu multimedialnego z wpisu GEDCOM. W przypadku osób, które mają więcej zdjęć, musisz zmienić kolejność obiektów multimedialnych tak, aby to, które chcesz wyróżnić, było pierwsze.<br /><br />Więcej informacji na temat korzystania z multimediów w sekcji Multimedia w pliku <a href=\"readme.txt\">readme.txt</a>.<br />";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Ta opcja określa, czy zdjęcia przypisane do osób, rodzin i źródeł będą widoczne jako miniaturki (pomniejszone), czy też zostanie wyświetlone oryginalne zdjęcie. To ustawienie ma także wpływ na kilka stron, takich jak \"Przeglądarka multimediów\". Strony \"Zarządzaj mediami\" i \"Lista mediów\" zawsze stosują miniaturki.<br /><br />Wybranie <b>#pgv_lang[yes]#</b> spowoduje wyświetlanie na wszystkich stronach poza diagramami miniaturki w dokładnie takiej postaci, w jakiej znajduje się ona w bazie. Oznacza to, że nie będzie sprawdzany jej rozmiar, co może dawać niespodziewane rezultaty.<br /><br />Ustawienie tej opcji na <b>#pgv_lang[no]#</b> spowoduje zmniejszenie oryginalnego zdjęcia przez przeglądarkę do standardowej wielkości miniaturki przed wyświetleniem go na stronach osoby, rodziny i źródła. Miniaturka będzie miała szerokość 150 pikseli i obramowanie (w przypadku istniejącej miniaturki nie ma obramowania). Przeglądarka multimediów będzie wyświetlać oryginalne zdjęcie o maksymalnej szerokości 300 pikseli. Jeśli oryginalne zdjęcie jest mniejsze, Przeglądarka multimediów pokaże je w pełnym rozmiarze.<br /><br />Zaleca się unikanie ustawiania tej opcji na <b>#pgv_lang[no]#</b>, ponieważ PhpGedView będzie wysyłać do przeglądarki zdjęcie w pełnym rozmiarze nawet wtedy, kiedy przeglądarka będzie pokazywać pomniejszoną wersję, co spowoduje nadmierne wzmożenie przepływu informacji.<br /><br />";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Pokaż nazwę pliku w Przeglądarce multimediów";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Przeglądarka multimediów może pokazywać nazwy przeglądanych plików. Ta opcja określa, czy nazwy mają być widoczne dla użytkowników, czy nie.<br /><br />Ze względów bezpieczeństwa zaleca się ukryć nazwy plików.<br /><br />";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Pokaż odnośnik do pobierania w Przeglądarce multimediów";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Przeglądarka multimediów może wyświetlać odnośnik, którego kliknięcie spowoduje pobranie pliku multimedialnego na lokalny komputer użytkownika.<br /><br />Ze wzglęgów bezpieczeństwa zaleca się ukryć odnośnik do pobierania plików.<br /><br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Udostępnij Wycinki";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Wycinki pozwalają użytkownikom dodawać osoby do pliku tymczasowego, który mogą następnie pobrać w formacie GEDCOM i zaimportować do swojej aplikacji genealogicznej.<br />";
$pgv_lang["USE_THUMBS_MAIN"]	= "Użyj miniaturki";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Ukrywaj błędy GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Wybranie <b>Tak</b> spowoduje ukrywanie wszelkich komunikatów o błędach generowanych przez PhpGedView w przypadku, kiedy system nie może zinterpretować znacznika w pliku GEDCOM. PhpGedView stara się jak najściślej przestrzegać standardu GEDCOM 5.5.1, ale wiele aplikacji genealogicznych dopisuje własne znaczniki. Więcej informacji w pliku <a href=\"readme.txt\">readme.txt</a>.<br />";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Wstawiaj spacje zamiast zawijania wierszy notatek";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Niektóre aplikacje genealogiczne zawijają wiersze notatek tam, gdzie kończą się słowa, inne - w dowolnym miejscu. Z tego powodu PhpGedView może czasem wyświetlać słowa bez przerwy między nimi. Wybranie <b>Tak</b> spowoduje wstawienie spacji pomiędzy słowa, które były rozdzielone końcem linii w oryginalnym pliku GEDCOM.<br />";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Pokaż odnośniki pomocy kontekstowej <b>?</b>";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Ta opcja pozwala wyświetlać znaczniki w formie znaków zapytania obok elementów na wielu stronach. Odnośniki umożliwiają użytkownikom uzyskanie informacji lub pomocy na temat tych elementów.<br />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Ograniczenie liczby dni sekcji Nadchodzące wydarzenia";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Wprowadź maksymalną liczbę dni, która ma być widoczna w sekcjach Nadchodzące wydarzenia. Liczba nie może przekraczać 30.  Wprowadzenie większej liczby spowoduje zastosowanie liczby 30.<br /><br />Podana wartość określa, jak daleko w przyszłość wybiega PhpGedView szukając nadchodzących wydarzeń. Wyniki przeprowadzanego raz dziennie wyszukiwania są kopiowane do pliku tymczasowego.<br /><br />Sekcje wyświetlające nadchodzące wydarzenia na stronie powitalnej i portalu mogą stronach nie mogą wyświetlić więcej dni, niż podana wartość. Im większość wartość ustawisz, tym dłużej zajmie codzienne kompilowanie wyciągu z bazy danych i wyświetlanie sekcji, nawet, jeśli faktycznie będzie trzeba wyświetlić mniej dni, niż to ustawienie.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Minimalna liczba wystąpień do statusu \"Najczęstsze nazwisko\"";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />To jest liczba wystąpień, którą musi osiągnąć nazwisko, zanim zostanie wyświetlone na liście Popularnych nazwisk na stronie powitalnej.<br />";
$pgv_lang["COMMON_NAMES_ADD"]	= "Nazwiska do dodania do \"Najczęstszych nazwisk\" (rozdzielane przecinkami)";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Jeśli liczba wystąpień pewnego nazwiska jest niższa niż wartość progowa, nie zostanie wyświetlone na liście. Takie nazwisko może jednak zostać dodane ręcznie. Jeśli chcesz wprowadzić więcej niż jedno nazwisko, rozdziel kolejne nazwiska przecinkami. <b>Wielkie i małe litery w nazwiskach mają znaczenie.</b><br />";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Nazwiska do usunięcia z \"Najczęstszych nazwisk\" (rozdzielane przecinkami)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Jeśli chcesz usunąć nazwisko z listy \"Najczęstsze nazwiska\" bez zwiększania wartości progowej, wprowadź je tutaj. Jeśli chcesz wprowadzić więcej niż jedno nazwisko, rozdziel kolejne nazwiska przecinkami. <b>Wielkie i małe litery w nazwiskach mają znaczenie.</b>Wprowadzone tutaj nazwiska nie pojawią się również na liście \"Pierwsza dziesiątka\" na stronie głównej.<br />";
$pgv_lang["HOME_SITE_URL"]		= "URL strony głównej";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Każda strona PhpGedView zawiera odnośnik do głównej strony domowej. Wygląd tego odnośnika zależy od używanego motywu. Podajesz tutaj faktyczny URL do swojej strony domowej.<br />";
$pgv_lang["HOME_SITE_TEXT"]		= "Opis strony głównej";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Legenda do odnośnika do twojej głównej strony domowej.<br />";
$pgv_lang["CONTACT_EMAIL"]		= "Kontakt genealogiczny";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Osoba, z którą należy się kontaktować w sprawie informacji genealogicznych na stronie.<br />";
$pgv_lang["CONTACT_METHOD"]		= "Sposób kontaktowania się";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Metoda, która ma być wykorzystana do nawiązania kontaktu z #pgv_lang[CONTACT_EMAIL]# w sprawach genealogicznych.<ul><li>Wybranie opcji <b>#pgv_lang[mailto]#</b> spowoduje wyświetlenie odnośnika \"mailto\", którego można użyć aby wysłać email przez klienta pocztowego na komputerze użytkownika.</li><li>Wybranie opcji <b>#pgv_lang[messaging]#</b> spowoduje użycie wewnętrznego mechanizmu komunikacji PhpGedView, bez wysyłania emaili.</li><li>Domyślnie wybrana jest opcja <b>#pgv_lang[messaging2]#</b>. Powoduje ona wykorzystanie mechanizmu PhpGedView, a także przesyłanie kopii wiadomości emailem.</li><li>Wybranie opcji <b>#pgv_lang[messaging3]#</b> włączy obsługę wiadomości przez PhpGedView i wysyłanie wiadomości drogą emailową, ale nie będą one przechowywane wewnętrznie. Ta opcja jest podobna do <b>#pgv_lang[mailto]#</b> z tą różnicą, że wiadomość zostanie wysłana przez PhpGedView, a nie komputer użytkownika.</li><li>Wybranie opcji <b>#pgv_lang[no_messaging]#</b> sprawi, że twoi użytkownicy nie będą się mogli z tobą kontaktować w żaden sposób.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "Adres zwrotny PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Adres email, który ma się pojawić w polu &laquo;Od:&raquo; (&laquo;From:&raquo;) wiadomości wysyłanych automatycznie przez PhpGedView.<br /><br />PhpGedView może automatycznie wysyłać emaile aby powiadamiać administratorów o zmianach, które muszą zostać przejrzane. PhpGedView także wysyła powiadomienia emailowe do użytkowników, którzy rozpoczęli rejestrację konta.<br /><br />Zwykle pole  &laquo;Od:&raquo; (&laquo;From:&raquo;) tych automatycznie wygenerowanych wiadomości ma postać <i>From: phpgedview-noreply@yoursite</i>, która informuje, aby nie odpowiadać na ten email. Dla ochrony przez spamem i innymi nadużyciami niektóre systemy emailowe wymagają od każdej wiadomości poprawnego adresu email w polu &laquo;Od:&raquo; (&laquo;From:&raquo;) i nie dostarczą wiadomości wysłanych z konta  <i>phpgedview-noreply</i>.<br />";
$pgv_lang["WEBMASTER_EMAIL"]		= "Kontakt pomocy technicznej";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Osoba, z którą należy się kontaktować w sprawach technicznych lub błędów napotkanych na stronie.<br />";
$pgv_lang["SUPPORT_METHOD"]		= "Sposób kontaktowania się";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Metoda, która ma być wykorzystana do nawiązania kontaktu z #pgv_lang[WEBMASTER_EMAIL]# w sprawach technicznych.<ul><li>Wybranie opcji <b>#pgv_lang[mailto]#</b> spowoduje wyświetlenie odnośnika \"mailto\", którego można użyć aby wysłać email przez klienta pocztowego na komputerze użytkownika.</li><li>Wybranie opcji <b>#pgv_lang[messaging]#</b> spowoduje użycie wewnętrznego mechanizmu komunikacji PhpGedView, bez wysyłania emaili.</li><li>Domyślnie wybrana jest opcja <b>#pgv_lang[messaging2]#</b>. Powoduje ona wykorzystanie mechanizmu PhpGedView, a także przesyłanie kopii wiadomości emailem.</li><li>Wybranie opcji <b>#pgv_lang[messaging3]#</b> włączy obsługę wiadomości przez PhpGedView i wysyłanie wiadomości drogą emailową, ale nie będą one przechowywane wewnętrznie. Ta opcja jest podobna do <b>#pgv_lang[mailto]#</b> z tą różnicą, że wiadomość zostanie wysłana przez PhpGedView, a nie komputer użytkownika.</li><li>Wybranie opcji <b>#pgv_lang[no_messaging]#</b> sprawi, że twoi użytkownicy nie będą się mogli z tobą kontaktować w żaden sposób.</li></ul>";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Pokaż ikonki faktów";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Wybierz <b>#pgv_lang[yes]#</b> aby pokazać ikonki obok nazw faktów na stronie #pgv_lang[personal_facts]#. Ikonki faktów będą widoczne pod warunkiem, że znajdują się w katalogu <i>images/facts</i> bieżącego motywu.<br />";
$pgv_lang["FAVICON"]			= "Ikonka ulubionych";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Wskaż ikonkę, którą użytkownicy mają zobaczyć w menu przeglądarki Ulubione kiedy dodadzą zakładkę do twojej strony.<br />";
$pgv_lang["THEME_DIR"]			= "Katalog motywów";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />Katalog, w którym znajdują się twoje pliki motywów PhpGedView.<br /><br />Możesz dostosować dowolny ze standardowych motywów PhpGedView tak, aby nadać swojej stronie unikalny charakter. Więcej informacji w sekcji Dostosowywanie motywu w pliku <a href=\"readme.txt\">readme.txt</a>.<br />";
$pgv_lang["TIME_LIMIT"]			= "Limit czasu PHP:";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Maksymalny czas w sekundach, przez który może nieprzerwanie działać PhpGedView.<br /><br />Wartość domyślna to 1 minuta. Zależnie od rozmiaru pliku GEDCOM może zajść potrzeba zwiększenia tego limitu przy tworzeniu indeksów. Ustawienie 0 pozwoli PHP działać w nieskończoność.<br /><br />Uwaga: Ustawienie 0 lub za dużej wartości na niektórych systemach operacyjnych może spowodować wieszanie się strony  do czasu, aż nie zakończy się wykonywanie skryptu. Ustawienie 0 oznacza, że może się on nigdy nie zakończyć, chyba że administrator serwera zakończy proces lub zrestartuje serwer. Uruchomienie dużego wykresu rodowego może zająć bardzo długo; ustawienie minimalnej potrzebnej wartości uchroni przed sytuacją, w której ktoś mógłby spowodować awarię twojego serwera wczytując zbyt duży wykres.<br />";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Ścieżka zapisu sesji";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Ścieżka do miejsca, w którym PhpGedView ma przechowywać pliki sesji.<br /><br />Niektóre hosty nie mają poprawnie skonfigurowanego PHP i nie kontynuują sesji po przejściu na inną stronę. Ta opcja pozwala administratorom strony rozwiązać ten problem przez zapisywanie plików w jednym z ich katalogów lokalnych. Jeśli musisz to zrobić, dobrym miejscem jest katalog ./index/. Domyślnie pole to jest puste, co powoduje zastosowanie ścieżki zapisu skonfigurowanej w pliku <i>php.ini</i>.<br /><br />Ustawia parametr \$PGV_SESSION_SAVE_PATH w pliku <i>config.php</i>.<br />";
$pgv_lang["SERVER_URL"]			= "URL PhpGedView";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Jeśli korzystasz z https lub niestandardowego portu, musisz tutaj podać URL, który umożliwi dostęp do twojego serwera.<br /><br />Ustawia parametr \$SERVER_URL w pliku <i>config.php</i>.<br />";
$pgv_lang["LOGIN_URL"]			= "URL logowania";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />Wypełnij to pole tylko wówczas, jeśli chcesz zastosować przekierowanie użytkowników do innej strony lub miejsca po zalogowaniu. Jest to przydatne kiedy chcesz przejść z http do https po zalogowaniu. Podana wartość musi zawierać pełną ścieżkę URL do pliku <i>login.php</i>, na przykład https://www.twojserwer.com/phpgedview/login.php<br /><br />Ustawia parametr \$LOGIN_URL w pliku <i>config.php</i>.<br />";
$pgv_lang["ALLOW_USER_THEMES"]		= "Zezwalaj użytkownikom wybrać motyw";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Umożliwia użytkownikom wybranie motywu.<br /><br />Ustawia parametr \$ALLOW_USER_THEMES w pliku <i>config.php</i>.<br />";
$pgv_lang["PGV_SIMPLE_MAIL"] = "Użyj prostych nagłówków w zewnętrznych emailach";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />W zwykłych nagłówkach emaili zewnętrznych pokazuje się zarówno adres email, jak i nazwa użytkownika. Niektóre systemy pocztowe mogą odrzucać takie emaile. Wybranie <b>Tak</b> spowoduje, że w nagłówku pojawi się tylko adres email.<br /><br />Ustawia parametr \$PGV_SIMPLE_MAIL w pliku <i>config.php</i>.<br />";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Wprowadź opisowy tytuł, który ułatwi użytkownikom rozpoznanie go wśród innych plików GEDCOM na twojej stronie.<br />";
$pgv_lang["LOGFILE_CREATE"]		= "Archiwizuj pliki loga";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Jak często program powinien archiwizować pliki loga.<br /><br />Ustawia parametr \$LOGFILE_CREATE w pliku <i>config.php</i>.<br />";
$pgv_lang["PGV_MEMORY_LIMIT"]		= "Limit pamięci";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Maksymalna wielkość pamięci, którą mogą zająć skrypty PhpGedView. Domyślna wartość to 32 Mb. Wiele hostów wyłącza tę opcję w swojej konfiguracji PHP; zmienienie tej wartości może nie mieć wpływu bieżącego ustawienia maksymalnej pamięci.<br /><br />Ustawia parametr \$PGV_MEMORY_LIMIT w pliku <i>config.php</i>.<br />";
$pgv_lang["PGV_STORE_MESSAGES"]		= "Zezwalaj na przechowywanie wiadomości online";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Określa, czy wiadomości przesłane przez PhpGedView mają być przechowywane w bazie danych. Wybranie <b>Tak</b> spowoduje, że użytkownicy będą mogli przeglądać swoje wiadomości po zalogowaniu do PhpGedView. Wybranie <b>Nie</b> spowoduje, że wiadomości będą jedynie wysyłane emailem.<br /><br />Ustawia parametr \$PGV_STORE_MESSAGES w pliku <i>config.php</i>.<br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Pokaż listę wyboru motywów";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Umożliwia użytkownikom wybór motywu z listy.<br /><br />Nawet, kiedy ta opcja jest włączona, bieżący motyw może nie wyświetlić tej listy. Aby to ustawienie odniosło skutek, musi być jednocześnie włączona opcja <b>#pgv_lang[ALLOW_USER_THEMES]#</b>.<br /><br />Ustawia parametr \$ALLOW_THEME_DROPDOWN w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["MAX_VIEW_RATE"]		= "Maksymalna częstość odwiedzania strony";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Ta opcja ogranicza częstość, z jaką użytkownik może odwiedzać strony.<br /><br />Jeśli częstość zostanie przekroczona, PhpGedView potraktuje sesję jako próbę hackowania strony i zakończy sesję odpowiednim komunikatem. Te dwie wartości powinny stanowić rozsądne ograniczenie na przepustowość łącza i liczbę bajtów pobranych z serwera. Można wyłączyć tę opcję przez ustawienie odstępu czasu na 0.<br /><br />Ustawia parametr \$MAX_VIEWS i \$MAX_VIEW_TIME w pliku <i>config.php</i>.<br />";
$pgv_lang["META_AUTHOR"]		= "Znacznik META autora";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Wartość znacznika META autora w nagłówku HTML strony. Pozostaw to pole puste, jeśli chcesz użyć pełnego imienia i nazwiska #pgv_lang[CONTACT_EMAIL]#.<br /><br />Ustawia parametr \$META_AUTHOR w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_AUTHOR_descr"]	= "Pozostaw to pole puste, jeśli chcesz użyć pełnego imienia i nazwiska #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "Znacznik META wydawcy";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Wartość znacznika META wydawcy w nagłówku HTML strony. Pozostaw to pole puste, jeśli chcesz użyć pełnego imienia i nazwiska #pgv_lang[CONTACT_EMAIL]#.<br /><br />Ustawia parametr \$META_PUBLISHER w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PUBLISHER_descr"]	= "Pozostaw to pole puste, jeśli chcesz użyć pełnego imienia i nazwiska #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "Znacznik META praw autorskich";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Wartość znacznika META praw autorskich w nagłówku HTML strony. Pozostaw to pole puste, jeśli chcesz użyć pełnego imienia i nazwiska #pgv_lang[CONTACT_EMAIL]#.<br /><br />Ustawia parametr \$META_COPYRIGHT w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_COPYRIGHT_descr"]	= "Pozostaw to pole puste, jeśli chcesz użyć pełnego imienia i nazwiska #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "Znacznik META opisu";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Wartość znacznika META opisu w nagłówku HTML strony. Pozostaw to pole puste, jeśli chcesz użyć tytułu aktualnej bazy danych.<br /><br />Ustawia parametr \$META_DESCRIPTION w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_DESCRIPTION_descr"]	= "Pozostaw to pole puste, jeśli chcesz użyć tytułu aktualnej bazy danych.";
$pgv_lang["META_PAGE_TOPIC"]		= "Znacznik META tematu strony";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Wartość znacznika META tematu strony w nagłówku HTML strony. Pozostaw to pole puste jeśli chcesz użyt tytułu aktualnej bazy danych.<br /><br />Ustawia parametr \$META_PAGE_TOPIC w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Pozostaw to pole puste, jeśli chcesz użyć tytułu aktualnej bazy danych.";
$pgv_lang["META_AUDIENCE"]		= "Znacznik META publiczności";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Wartość znacznika META publiczności w nagłówku HTML strony.<br /><br />Ustawia parametr \$META_AUDIENCE w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TYPE"]		= "Znacznik META typu strony";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Wartość znacznika META typu strony w nagłówku HTML strony.<br /><br />Ustawia parametr \$META_PAGE_TYPE w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_ROBOTS"]		= "Znacznik META robotów";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />Wartość znacznika META robotów nagłówka HTML strony. Niektóre roboty i mechanizmy indeksujące nie biorą tego parametru pod uwagę.<br /><br />Ustawia parametr \$META_ROBOTS w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_REVISIT"]		= "Znacznik META ponownych odwiedzin";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Wartość znacznika HTML ponownych odwiedzin przez roboty indeksujące nagłówka HTML strony. Niektóre roboty indeksujące nie biorą pod uwagę tego parametru.<br /><br />Ustawia parametr \$META_REVISIT w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_KEYWORDS"]		= "Znacznik META słów kluczowych";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Wartość znacznika META słów kluczowych w nagłówku HTML strony. Niektóre wyszukiwarki korzystają ze słów kluczowych do indeksowania twojej strony.<br /><br />Poza wprowadzoną wartością, do tego znacznika można także dołączyć listę #pgv_lang[common_surnames]#, wyświetlanę w sekcji #pgv_lang[gedcom_stats]# na twojej stronie powitalnej.<br /><br />Ustawia parametr \$META_KEYWORDS w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Dodaj najczęstsze nazwiska do znacznika META słów kluczowych";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "~#pgv_lang[META_SURNAME_KEYWORDS]#~<br /><br />Wybranie <b>Tak</b> spowoduje dodanie do znacznika META słów kluczowych nazwisk z listy  #pgv_lang[common_surnames]#. Może to pomóc wyszukiwarkom lepiej dopasować twoją stronę do kryteriów wyszukiwania.<br /><br />Ustawia parametr \$META_SURNAME_KEYWORDS w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_TITLE"]		= "Dodaj do znacznika nagłówka TITLE";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Treść wprowadzona tutaj zostanie dopisana do znacznika TITLE w nagłówku HTML strony po zwykłym tytule strony i przed podziękowaniem dla PhpGedView.<br /><br />Ustawia parametr \$META_TITLE w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["ENABLE_RSS"]				= "Włącz RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Ta opcja umożliwa wyłączenie obsługi RSS.<br /><br />RSS pozwala użytkownikom śledzić zmiany na twojej stronie głównej bez konieczności regularnego wchodzenia na nią. Jeśli zbyt wielu użytkowników będzie chciało korzystać z RSS lub częstość odświeżania ustawiona przez nich jest zbyt wysoka, RSS może zabierać za  dużo przepustowości łącza lub przekraczać możliwości serwera.<br /><br />Ten <a href=\'http://en.wikipedia.org/wiki/RSS_(file_format)\' target=\'_blank\' alt=\'Artykuł Wikipedii\' title=\'Artykuł Wikipedii\'><b>artykuł w Wikipedii</b></a> zawiera szczegółowe informacje i odnośniki na temat RSS i różnych formatów RSS.<br />";
$pgv_lang["RSS_FORMAT"]				= "Format RSS";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Domyślny format kanału RSS dla strony. Przyrostki liczbowe <u>nie</u> wskazują wersji, lecz identyfikują format. Na przykład RSS 2.0 nie jest nowszy, niż RSS 1.0, ale jest innym formatem. Czytniki RSS powinny być w stanie odczytać każdy format.<br /><br />Ten <a href=\'http://en.wikipedia.org/wiki/RSS_(file_format)\' target=\'_blank\' alt=\'Artykuł Wikipedii\' title=\'Artykuł Wikipedii\'><b>artykuł w Wikipedii</b></a> zawiera szczegółowe informacje i odnośniki na temat RSS i różnych formatów RSS.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Sprawdź czy można pobrać pliki GEDCOM";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Ze względów bezpieczeństwa pliki GEDCOM nie powinny znajdować się w miejscu, z którego mogą zostać bezpośrednio pobrane, w ten sposób omijając zabezpieczenia prywatności. Kliknięcie na ten odnośnik spowoduje sprawdzenie, czy twoje pliki GEDCOM mogą zostać pobrane przez sieć.<br /><br />Wiadomo, że na niektórych systemach ten test może zająć bardzo długo lub w ogóle się nie zakończyć. Jeśli tak jest w twoim przypadku, powinieneś(powinnaś) wpisać w przeglądarce bezpośredni adres do pliku GEDCOM i zobaczyć, czy da się go pobrać.<br />";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# nie może zostać pobrany.";
$pgv_lang["welcome_new2"]			= "<br /><br />Jeśli widzisz tę stronę oznacza to, że poprawnie zainstalowałeś(aś) PhpGedView na swoim serwerze i możesz rozpocząć jego konfigurację według własnych potrzeb.<br /><br />";
$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]# Ta strona pomocy przeprowadzi cię przez proces konfiguracji. W miarę postępu konfiguracji w tym oknie będzie pojawiać się pomoc na temat pola, które aktualnie wypełniasz. Możesz zamknąć to okno; aby otworzyć je ponownie, kliknij na jeden ze znaków zapytania \"?\" obok etykiety pola.<br />";
$pgv_lang["return_editconfig"]		= "Możesz powrócić do konfiguracji w dowolnym momencie wpisując w przeglądarce adres do pliku <i>editconfig.php</i> lub klikając na odnośnik <b>Konfiguracja</b> na stronie <b>Administracja PhpGedView</b>.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "Możesz powrócić do konfiguracji w dowolnym momencie klikając odnośnik <b>Edycja</b> w tabelce <b>#pgv_lang[current_gedcoms]#</b> na stronie <b>#pgv_lang[gedcom_adm_head]#</b> lub wpisując w przeglądarce adres do pliku <i>editconfig_gedcom.php</i>.<br />";
$pgv_lang["PGV_SESSION_TIME"]		= "Limit czasu sesji";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Czas w sekundach, po którym sesja wygaśnie i będzie konieczne ponowne zalogowanie. Domyślna wartość to 7200 sekund (2 godziny)<br /><br />Ustawia parametr \$PGV_SESSION_TIME w pliku <i>config.php</i>.<br />";
$pgv_lang["SHOW_STATS"]			= "Pokaż statystyki wykonania";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Pokazuje statystyki bieżące i zapytania do bazy danych na dole każdej strony.<br />";
$pgv_lang["SHOW_COUNTER"]		= "Pokaż liczniki odwiedzin";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Wyświetlaj liczniki odwiedzin na stronie portalu i osoby.<br />";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Zezwalaj gościom na rejestrację konta";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Umożliwa gościom rejestrację w celu otrzymania konta na stronie.<br /><br />Gość otrzyma wiadomość email z kodem, który umożliwi mu potwierdzenie zgłoszenia. Po potwierdzeniu, zanim konto stanie się aktywne, musi zostać zatwierdzone przez administratora.<br /><br />Ustawia parametr \$USE_REGISTRATION_MODULE w pliku <i>config.php</i>.<br />";

$pgv_lang["save_config"] 	= "Zapisz konfigurację";
$pgv_lang["download_gedconf"]		= "Pobierz konfigurację GEDCOM.";
$pgv_lang["not_writable"]		= "Wykryto zabezpieczenie pliku konfiguracyjnego przez zapisem przez PHP. Możesz użyć przycisku <b>#pgv_lang[download_file]#</b> aby zapisać swoje ustawienia do pliku, który będzie można następnie wgrać ręcznie.";
$pgv_lang["upload_to_index"]		= "Wgraj plik do katalogu indeksowego";
$pgv_lang["import_sql"]			= "W katalogu indeksowym wykryto pliki SQL. Jeśli są one wygenerowane przez narzędzie migracji użytkowników, możesz zaimportować te dane do swojej bazy danych. Czy chcesz zaimportować te pliki? Wszystkie istniejące informacje w twojej bazie związane z użytkownikami (użytkownicy, artykuły, ulubione, układy sekcji i wiadomości) zostaną utracone.<br /><br />Jeśli będziesz kontynuować, PhpGedView spróbuje zaimportować dane. Jeśli import się nie powiedzie, będzie trzeba utworzyć konto pierwszego administratora.<br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"] = "Edytuj ustawienia prywatności";
$pgv_lang["edit_privacy_title"]			= "Edytuj ustawienia prywatności GEDCOM";
$pgv_lang["save_changed_settings"]	= "Zapisz zmiany";
$pgv_lang["add_new_pp_setting"]			= "Dodaj nowe ustawienie prywatności dla identyfikatora";
$pgv_lang["add_new_up_setting"]			= "Dodaj nowe ustawienie prywatności użytkownika";
$pgv_lang["add_new_gf_setting"]			= "Dodaj nowe ustawienie globalnej prywatności faktów";
$pgv_lang["add_new_pf_setting"]			= "Dodaj nowe ustawienie prywatności faktów dla identyfikatora";
$pgv_lang["file_read_error"]			= "Błąd! Nie można odczytać pliku prywatności.";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Zmień ustawienia prywatności dla identyfikatora";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Zmień ustawienia prywatności użytkownika";
$pgv_lang["edit_exist_global_facts_settings"]	= "Zmień ustawienia globalnej prywatności faktów";
$pgv_lang["edit_exist_person_facts_settings"]	= "Zmień ustawienia prywatności faktów dla identyfikatora";
$pgv_lang["general_privacy"]			= "Ogólne ustawienia prywatności";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Możesz mieć osobne ustawienia prywatności dla każdego pliku GEDCOM na swojej stronie PhpGedView. Sprawdź pod tytułem strony, czy edytujesz właściwy plik GEDCOM.<br /><br />Możesz nadpisać ogólne ustawienia korzystając z innych form prywatności na stronie #pgv_lang[edit_privacy_title]#.<br />#pgv_lang[more_config_hjaelp]#";
$pgv_lang["person_privacy"]				= "Ustawienia prywatności dla identyfikatora";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Te ustawienia pozwalają administratorowi nadpisywanie domyślnych ustawień prywatności dla poszczególnych osób, rodzin, źródeł i obiektów multimedialnych.<br /><br />Załóżmy dla przykładu, że miałeś(aś) dziecko, które zmarło jako niemowlę. Zwykle, ponieważ dziecko nie żyje, jego dane byłyby dostępne publicznie, mimo że ty i pozostała część twojej rodziny pozostalibyście ukryci. Nie chcesz usuwać informacji o śmierci dziecka, ale chcesz ukryć dane i uczynić je prywatnymi. Zakładając, że dziecko miało identyfikator I100, możesz wprowadzić następujące ustawienia prywatności:<br />Identyfikator: I100<br />Pokazuj: Pokazuj tylko autoryzowanym użytkownikom<br /><br />Działa to także w drugą stronę. Jeśli chcesz publicznie udostępnić dane osoby o identyfikatorze I101, o którym wiesz, że nie żyje, ale brak daty śmierci, możesz wprowadzić następujące ustawienia:<br />Identyfikator: I101<br />Pokazuj: Pokazuj publicznie<br /><br />Ustawia parametr \$person_privacy w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["user_privacy"]				= "Ustawienia prywatności użytkownika";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Te ustawienia umożliwiają administratorowi nadpisanie domyślnych ustawień prywatności dla osób w pliku GEDCOM na podstawie loginu. Zakładając, że nie chcesz, aby użytkownik o nazwie <b>Jan</b> widział jakiekolwiek szczegóły I100 w pliku GEDCOM, możesz wprowadzić:<br />Login: Jan<br />Identyfikator: I100<br />Pokaż?: \"Ukryj\"<br /><br />i szczegóły podanej osoby zostaną ukryte wyłącznie przed użytkownikiem z loginem \"Jan\".<br /><br />Aby pokazać szczegóły I101 (które zwykle byłyby ukryte, ponieważ osoba I101 żyje) użytkownikowi \"Jan\" ustaw:<br /><br />Login: Jan<br />Identyfikator: I101<br />Pokaż?: \"Pokaż\"<br /><br />Ustawia zmienną \$user_privacy w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["global_facts"]				= "Ustawienia globalnej prywatności faktów";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Te ustawienia określają fakty na poziomie globalnym, które mają być ukryte przed wszystkimi osobami w pliku GEDCOM. Ma to wpływ tylko na wpisy poziomu 1, takie jak urodzenie (BIRT) lub śmierć (DEAT), które mają swoje własne nagłówki na zakładce faktów i szczegółów o osobie.<br /><ul><li>Element <b>#pgv_lang[name_of_fact]#</b> określa, które fakty mają być ukryte.</li><li>Element <b>#pgv_lang[choice]#</b> wskazuje sam fakt lub powiązane z nim szczegóły.</li><li>Element <b>#pgv_lang[accessible_by]#</b> określa, na jakim poziomie dostępu fakt będzie widoczny.</li></ul><br />To ustawienie ma za zadanie ukrycie pewnych faktów, identyfikowanych znacznikami GEDCOM, wszystkich osób, żyjących i zmarłych. Domyślnie numery ubezpieczenia (SSN) nie są dostępne publicznie, aby zapobiegać ich kradzieży i podszywaniu się pod osoby zmarłe (ma znaczenie w Stanach Zjednoczonych).<br /><br />Jeśli na przykład chcesz ukryć wszystkie małżeństwa użytkownikami prywatnymi w pliku GEDCOM, możesz ustawić:<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Małżeństwo<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_show]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Małżeństwo<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_details]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br />Takie ustawienia ukryłyby małżeństwa i powiązane z nimi szczegóły przed wszystkimi, którzy nie są administratorami.<br /><br />W przeciwieństwie do innych ustawień, w <b>#pgv_lang[edit_exist_global_facts_settings]#</b> możesz ukryć fakty nawet przed administratorami. Niechciane fakty są całkowicie niewidoczne.<br /><br />Ustawia parametr \$global_facts w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["person_facts"]				= "Ustawienia prywatności faktów dla identyfikatora";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Te ustawienia określają fakty dotyczące konkretnej osoby, rodziny lub źródła i poziom, na którym są ukryte. Odnosi się to wyłącznie do wpisów faktów na poziomie 1, takich jak urodzenie (BIRT) czy śmierć (DEAT), które mają swoje własne nagłówki na odpowiedniej stronie szczegółów osoby, rodziny lub źródła.<br /><br />Pierwszym elementem jest identyfikator osoby, rodziny lub źródła. Drugim elementem jest fakt. Element <b>#pgv_lang[choice]#</b> wskazuje sam fakt lub powiązane z nim szczegóły. Element <b>#pgv_lang[accessible_by]#</b> określa, na jakim poziomie dostępu fakt będzie widoczny. Niektóre fakty na liście nie są odpowiednie dla pewnych typów identyfikatorów. Na przykład urodzenie i śmierć nie są odpowiednie dla źródeł.<br /><br />Tablica  \$person_facts działa tak samo, jak tablica \$global_facts poza tym, że możesz także podać identyfikator GEDCOM osoby, dla której chcesz ukryć fakty. Możesz na przykład ukryć małżeństwo dla konkretnej osoby.<br /><br />Ustawia parametr \$person_facts w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["accessible_by"]			= "Komu pokazać?";
$pgv_lang["hide"]				= "Ukryj";
$pgv_lang["show_question"]			= "Pokazać?";
$pgv_lang["user_name"]				= "Login";
$pgv_lang["name_of_fact"]			= "Nazwa faktu";
$pgv_lang["choice"]				= "Wybór";
$pgv_lang["fact_show"]				= "Pokaż fakt";
$pgv_lang["fact_details"]			= "Pokaż szczegóły faktu";
$pgv_lang["privacy_header"]			= "Edytuj ustawienia prywatności";
$pgv_lang["unable_to_find_privacy_indi"]	= "Nie znaleziono osoby o podanym identyfikatorze";
$pgv_lang["save_and_import"]			= "Po zapisaniu tej konfiguracji GEDCOM musisz zaimportować plik GEDCOM klikając na przycisk <b>Importuj plik GEDCOM</b> lub wybierając z menu  <b>Administracja | Zarządzaj plikami GEDCOM | Importuj</b>";
$pgv_lang["help_info"]				= "Możesz uzyskać pomoc dla każdego elementu klikając na znak zapytania &quot;?&quot; obok etykiety komórki.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Pokaż imiona i nazwiska żyjących";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Określa, czy imiona i nazwiska osób żyjących mają być widoczne publicznie.<br /><br />Ustawia parametr \$SHOW_LIVING_NAMES w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Pokaż asystenta badań";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Określa, jaki typ użytkowników może korzystać z asystenta badań, jeśli ten moduł jest zainstalowany.<br /><br />Ustawia parametr \$SHOW_RESEARCH_ASSISTANT w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Użyj prywatności pokrewieństwa";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br />Wybranie <b>Nie</b> spowoduje udostępnienie szczegółów osób żyjących wszystkim autoryzowanym użytkownikom. Wybranie <b>Tak</b> umożliwi dostęp do danych osób żyjących tylko użytkownikom, którzy są z nimi spokrewnieni.<br /><br />Ustawia parametr \$USE_RELATIONSHIP_PRIVACY w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Maksymalna długość ścieżki pokrewieństwa";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Jeśli włączona jest opcja If #pgv_lang[USE_RELATIONSHIP_PRIVACY]#, zalogowani użytkownicy będą mogli przeglądać i edytować tylko osoby, z którymi łączy ich ścieżka pokrewieństwa nie dłuższa niż podana liczba kroków.<br /><br />Ustawia parametr \$MAX_RELATION_PATH_LENGTH w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Sprawdź powinowactwo";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Sprawdza powiązania włączając związek przez małżeństwo.<br /><br />Ustawia parametr \$CHECK_MARRIAGE_RELATIONS w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_DEAD_PEOPLE"]		= "Pokaż zmarłych";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Ustawia poziom dostępu prywatności do danych wszystkich osób zmarłych.<br />";
$pgv_lang["select_privacyfile_button"]		= "Wybierz plik prywatności";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Ogranicz prywatność wiekiem w momencie";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />To ustawienie umożliwia ukrycie szczegółów osób stosując kryterium ich wieku w momencie zajścia określonego wydarzenia, niezależnie od tego, czy są to osoby żyjące, czy zmarłe.<br /><br />Używaj tego ustawienia w połączeniu z ustawieniem <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Na przykład jeśli ustawisz ten wiek na 100 i wybierzesz <b>Tak</b>, wszystkie osoby, żyjące lub nie, urodzone później, niż 100 lat temu, zostaną ukryte. Osoby, które pobrały się mniej nież 85 lat temu i osoby, które zmarły mniej niż 75 lat temu również zostałyby ukryte. Pamiętaj, że zastosowanie tej opcji może nieco spowolnić działanie systemu.<br /><br />This sets \$PRIVACY_BY_YEAR in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Ta strona jest przeznaczona dla tłumaczy. Możesz tłumaczyć, porównywać i eksportować pliki językowe. Istnieje także możliwość określenia pochodzenia tekstu, wypisywanego przez PhpGedView.<br /><br />Masz do dyspozycji następujące opcje i narzędzia:<br />";

//-- language edit utility
$pgv_lang["edit_langdiff"]	= "Edytuj i konfiguruj pliki językowe";
$pgv_lang["bom_check"]		= "Sprawdzanie znaku BOM (Byte Order Mark)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br />";
$pgv_lang["bom_check_desc"]		= "Sprawdzenie przeanalizuje wszystkie pliki językowe pod kątem występowania znaku BOM (Byte Order Mark). Wykryte znaki BOM zostaną usunięte. Znak BOM może powodować nieprawidłowe działanie w niektórych miejscach PhpGedView.";
$pgv_lang["lang_debug"]			= "Wykrywanie usterek w treści pomocy";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["lang_debug_desc"]	= "Włączenie tej opcji spowoduje wyświetlenie w nowym oknie nazw zmiennych językowych, używanych w treści pomocy. Ułatwi to tłumaczom ustalenie nazwy zmiennej w razie zajścia konieczności zmiany treści.<br /><br />To ustawienie będzie ważne tylko podczas twojej aktualnej sesji PhpGedView.";
$pgv_lang["lang_debug_use"]		= "Zastosuj wykrywanie usterek w treści pomocy";
$pgv_lang["bom_not_found"]		= "Nie znaleziono znaku BOM.";
$pgv_lang["bom_found"]			= "Znaleziono znak BOM w";
$pgv_lang["edit_lang_utility"]		= "Edytor plików językowych";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#<br />";
$pgv_lang["edit_lang_utility_desc"]	= "To narzędzie umożliwia edycję pliku językowego na podstawie wersji angielskiej.<br /><br />Zobaczysz oryginalną treść w języku angielskim i zawartość pliku tego samego typu (jednego z czterech) w języku wybranym przez ciebie. Kiedy klikniesz na komunikat pod wersją angielską, otworzy się nowe okno, w którym będzie można edytować treść. Możesz zapisać lub odrzucić zmiany.";
$pgv_lang["edit_lang_utility_warning"]	= "Uwaga! Jeśli użyjesz przycisku <b>#pgv_lang[close_window_without_refresh]#</b>, zmiany na ekranie mogą nie pojawić się, dopóki ręcznie nie odświeżysz strony. Twój plik językowy może zostać uszkodzony jeśli dodasz komunikat, którego jeszcze w nim nie było, lub jeśli spróbujesz zmienić komunikat edytowany ostatnio. Nie używaj przycisku <b>#pgv_lang[close_window_without_refresh]#</b> jeśli nie jesteś pewien(pewna), co robisz.";
$pgv_lang["language_to_edit"]		= "Edytowany język";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />Z tej listy wybierasz język komunikatów, które chcesz edytować.<br />";
$pgv_lang["file_to_edit"]		= "Typ pliku językowego";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView implementuje obsługę wielu różnych języków. Dzieje się tak dzięki umieszczeniu tekstu widzianego przez użytkowników w osobnych plikach, całkowicie niezależnych od głównego programu. Dla każdego języka istnieje zbiór ośmiu plików, w które zostały pogrupowane komunikaty w zależności od ich funkcji. <b>Nie wszystkie pliki są niezbędne.</b> Jeśli dla danego tekstu nie istnieje jeszcze tłumaczenie, PhpGedView zastosuje wersję angielską.<br /><br />Zbiór plików językowych składa się z:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Ten plik zawiera terminy i wyrażenia używane podczas administrowania PhpGedView i genealogicznymi bazami danych.<br /><br /></li><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Ten plik zawiera treść pomocy używaną w czasie konfiguracji PhpGedView. Do treści pomocy nie mają dostępu zwykli użytkownicy.<br /><br /></li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Jest to lista nazw państw pobrana ze strony działu statystyk Ekonomicznej i Społecznej Rady Organizacji Narodów Zjednoczonych. Tu jest <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>odnośnik</b></a> do listy w języku angielskim. Lista jest dostępna w wersji angielskiej i francuskiej.<br /><br /></li><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Ten plik zawiera terminy i wyrażenia używane podczas edycji wpisów w genealogicznych bazach danych.<br /><br /></li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Ten plik zawiera tekstowe odpowiedniki kodów faktów GEDCOM według standardu  GEDCOM 5.5.1. Ponadto plik zawiera dodatkowe kody faktów nie będące częścią standardu, ale używane przez różne aplikacje genealogiczne.<br /><br />Angielską wersję <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>standardu GEDCOM 5.5.1</b></a> można pobrać w formacie PDF.<br /><br /></li><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Ten plik jest zbiorem często zadawanych pytań, skompilowanym przez zespół PhpGedView. Każde pytanie jest podzielone na dwa wpisy w tym pliku. Jeden z nich to nagłówek (zwykle pytanie), a drugi to treść (zwykle odpowiedź). Nowe wersje plików <b><i>faqlist.xx.php</i></b>, które są często aktualizowane, można pobrać ze strony domowej PhpGedView.<br /><br />Administrator może korzystać z wpisów w tym pliku aby utworzyć listę FAQ odpowiednią dla jego strony.<br /><br /></li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Ten plik zawiera treść pomocy dla zwykłych użytkowników. Niektóre tematy pomocy w tym pliku odnoszą się do administratorów i są niewidoczne dla użytkowników, którzy nie mają prawa do zarządzania systemem.<br /><br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;W tym pliku znajduje się wiele terminów i często występujących zwrotów.</li></ul><br />PhpGedView obsługuje także dodatkowy dziewiąty plik, <b><i>extra.xx.php</i></b>. Ten plik jest ładowany zawsze na końcu, po ośmiu pozostałych, i umożliwia administratorowi strony nadpisanie lub zmianę dowolnego standardowego komunikatu w wybranym języku. Można w nim także zdefiniować wersję tytułów genealogicznych baz danych, które będzie można wyświetlić przy zmianie ustawień językowych przez użytkownika.<br /><br />Zawartość pliku dodatkowego całkowicie zależy od administratora strony; ten plik <b>nigdy</b> nie będzie rozprowadzany z żadną wersją PhpGedView. Administrator nigdy nie powinien zmieniać standardowych plików językowych; wszystkie zmiany lokalne powinny się znaleźć w tym dodatkowym pliku.<br /><br />";
$pgv_lang["check"]			= "Sprawdź";
$pgv_lang["lang_save"]			= "Zapisz";
$pgv_lang["contents"]			= "Treść";
$pgv_lang["listing"]			= "Wyświetlane";
$pgv_lang["no_content"]			= "brak treści";
$pgv_lang["editlang"]			= "Edytuj";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Edytuj komunikat z pliku językowego.<br />";
$pgv_lang["savelang"]			= "Zapisz";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Zapisz zmieniony komunikat w  pliku językowym.<br />";
$pgv_lang["original_message"]		= "Oryginalny komunikat";
$pgv_lang["message_to_edit"]		= "Edytowany komunikat";
$pgv_lang["changed_message"]		= "Zmieniona treść";
$pgv_lang["message_empty_warning"]	= "-> Ostrzeżenie: Ten komunikat nie ma treści w pliku #LANGUAGE_FILE# <-";
$pgv_lang["language_to_export"]		= "Język do wyeksportowania";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Z tej listy możesz wybrać język, dla którego chcesz wyeksportować komunikaty.<br /><br />Obecnie procedura eksportuje wyłącznie zawartość plików <i>configure_help.xx.php</i>, <i>help_text.xx.php</i> i <i>lang.xx.php</i>. Wynikiem eksportu jest plik HTML, który można otworzyć  i wydrukować za pomocą przeglądarki.<br />";
$pgv_lang["export_lang_utility"]	= "Eksporter plików językowych";
$pgv_lang["time_format"]		= "Format godziny";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />To pole definiuje format godziny wykorzystywany przez PhpGedView.<br /><br />Możesz używać następujących symboli:<br /><b>a</b> - skrót ante meridiem (przed południem) lub post meridiem (po południu) pisany małymi literami; tzn. <b>am</b> lub <b>pm</b><br /><b>A</b> - skrót ante meridiem (przed południem) lub post meridiem (po południu) pisany dużymi literami; tzn. <b>AM</b> lub <b>PM</b><br /><b>B</b> - internetowy czas Swatch; tzn. od <b>000</b> do <b>999</b><br /><b>c</b> - data ISO 8601 (od wersji PHP 5); np. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - dwucyfrowy dzień miesiąca, wartość do 10 poprzedzona zerem; tzn. <b>01</b> do <b>31</b><br /><b>D</b> - trzyliterowy skrót nazwy dnia tygodnia; np. <b>Mon</b><br /><b>F</b> - pełna nazwa miesiąca; np. <b>January</b><br /><b>g</b> - godzina w formacie 12-godzinnym, wartość do 10 bez zera na początku; tzn. <b>1</b> do <b>12</b><br /><b>G</b> - godzina w formacie 24-godzinnym, wartość do 10 bez zera na początku; tzn. <b>0</b> do <b>23</b><br /><b>h</b> - godzina w formacie 12-godzinnym, wartość do 10 poprzedzona zerem; tzn. <b>01</b> do <b>12</b><br /><b>H</b> - godzina w formacie 24-godzinnym, wartość do 10 poprzedzona zerem; tzn. <b>00</b> do <b>23</b><br /><b>i</b> - minuty, wartość do 10 poprzedzona zerem; tzn. <b>00</b> do <b>59</b><br /><b>I</b> (wielka litera \"i\") - wskaźnik czasu letniego; <b>1</b> jeśli czas letni, <b>0</b> w przeciwnym wypadku.<br /><b>j</b> - dzień miesiąca, wartość do 10 bez zera na początku; tzn. <b>1</b> do <b>31</b><br /><b>l</b> (mała litera \"L\") - pełna nazwa dnia tygodnia; np. <b>Friday</b><br /><b>L</b> - wskaźnik roku przestępnego; <b>1</b> jeśli rok przestępny, <b>0</b> w przeciwnym wypadku.<br /><b>m</b> - numer miesiąca, wartość do 10 poprzedzona zerem; tzn. <b>01</b> do <b>12</b><br /><b>M</b> - trzyliterowy skrót nazwy miesiąca; np. <b>Jan</b><br /><b>n</b> - numer miesiąca, wartość do 10 bez zera na początku; tzn. <b>1</b> do <b>12</b><br /><b>O</b> (wielka litera \"o\") - różnica w godzinach między czasem lokalnym i czasem Greenwich time (GMT); np. <b>+0200</b><br /><b>r</b> - data w formacie RFC 2822; np. <b>Thu,&nbsp;21&nbsp;Dec&nbsp;2000nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - sekundy, wartość do 10 poprzedzona zerem; tzn. <b>00</b> do <b>59</b><br /><b>S</b> - dwuliterowy przyrostek (sufiks) dla angielskich dni miesiąca; tzn. <b>st</b>, <b>nd</b>, <b>rd</b> lub <b>th</b>. Dobrze działa w połączeniu z <b>j</b><br /><b>t</b> - liczba dni w danym miesiącu; tzn. <b>28</b> do <b>31</b><br /><b>T</b> - ustawienie strefy czasu tej maszyny; tzn. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - sekundy od początku epoki Unix (January&nbsp;1&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - numer dnia tygodnia; tzn. <b>0</b> (niedziela) do <b>6</b> (sobota)<br /><b>W</b> - numer tygodnia roku według ISO-8601, początek tygodnia w poniedziałek; np. <b>42</b> (42 tydzień roku)<br /><b>Y</b> - czterocyfrowy rok; np. <b>1999</b><br /><b>y</b> - dwucyfrowy rok; np. <b>99</b><br /><b>z</b> - numer dnia roku, wartość do 10 bez zera na początku; tzn. <b>0</b> (1 stycznia) do <b>364</b> (31 grudnia w roku zwykłym) lub  <b>365</b> (31 grudnia w roku przestępnym)<br /><b>Z</b> - różnica strefy czasowej w sekundach. Różnica dla stref czasowych na zachód od Greenwich jest zawsze ujemna, a na wschód - zawsze dodatnia. Tzn. <b>-43200</b> do <b>43200</b><br /><br />Możesz zmieniać kolejność tych symboli i dodawać do formatu znaki rozdzielające.<br /><br />Na przykład w języku niemieckim to pole zwykle ma wartość <b>H:i:s</b>, co daje rezultat podobny do <b>09:01:25</b>. Język angielski zwykle definiuje format jako <b>g:i:sa</b>, co powoduje wyświetlenie tej godziny jako <b>9:01:25am</b>.<br /><br />W systemie 24-godzinnym, północ to godzina 00:00. W formacie 12-godzinnym, północ to godzina 12:00am, a południe - 12:00pm.<br />";
$pgv_lang["rtl"]			= "Od prawej do lewej";
$pgv_lang["file_does_not_exist"]	= "Błąd! Plik nie istnieje.";
$pgv_lang["alphabet_upper"]		= "Wielkie litery alfabetu";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Wielkie litery alfabetu danego języka. Ta lista jest wykorzystywana do sortowania list imion, nazwisk i nazw.<br />";
$pgv_lang["alphabet_lower"]		= "Małe litery alfabetu";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Małe litery alfabetu danego języka. Ta lista jest wykorzystywana do sortowania list imion, nazwisk i nazw.<br />";
$pgv_lang["multi_letter_alphabet"]		= "Kombinacje znaków alfabetu";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Kombinacje znaków, które mają być traktowane jako pojedyncza, osobna litera podczas sortowania list imion, nazwisk, nazw i tytułów w tym języku.<br /><br />W niektórych językach, takich jak węgierskim i słowackim, pewne kombinacje znaków stanowią osobne litery alfabetu. Kolejność, podania tych kombinacji będzie odzwierciedlać kolejność, w której zostaną wstawione do alfabetu podstawowego podczas sortowania. Ma to znaczenie w przypadku, gdy kilka kombinacji zaczyna się tą samą literą. Za wyjątkiem <b>ch</b>, kombinacje znaków zostaną wstawione do alfabetu podstawowego według ich pierwszej litery. <b>ch</b> będzie zawsze wstawione po <b>h</b>.<br />";
$pgv_lang["dictionary_sort"]		= "Użyj reguł gramatycznych podczas sortowania";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Ta opcja określa sposób traktowania znaków diakrytycznych (umlautów, ogonków, kresek itp.) podczas sortowania list imion, nazwisk, nazw i tytułów.<br /><br />Wybranie <b>#pgv_lang[yes]#</b> spowoduje potraktowanie wszystkich liter ze znakami diakrytycznymi tak, jakby ich nie miały. Znaki diakrytyczne będą brane pod uwagę wyłącznie w przypadku, gdy dwa słowa nie różnią się niczym innym poza nimi. Wybranie <b>#pgv_lang[no]#</b> spowoduje potraktowanie każdej litery jako osobnej, zależnie od tego, czy posiada znaki diakrytyczne, czy też nie.<br />";
$pgv_lang["lang_config_write_error"]	= "Błąd podczas zapisywania ustawień do pliku <b>lang_settings.php</b>. Sprawdź uprawnienia i spróbuj ponownie.";
$pgv_lang["translation_forum"]		= "Forum tłumaczeniowe PhpGedView na SourceForge";
$pgv_lang["translation_forum_help"]	= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["translation_forum_desc"]	= "<a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"_blank\"><b>Ten odnośnik</b></a> otwiera w nowym oknie przeglądarki forum tłumaczeń PhpGedView, gdzie możesz podyskutować na tematy związane z tłumaczeniem.";
$pgv_lang["lang_set_file_read_error"]	= "Błąd! Wczytywanie pliku <b>lang_settings.php</b> nie powiodło się.";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Ta procedura umożliwia dodawanie nowego, wcześniej niedostępnego języka do PhpGedView.<br /><br />Możesz skonfigurować standardowe ustawienia nowego języka, m.in. kod wykrywania języka, kierunek tekstu, początek tygodnia dla tego języka, formatowanie czasu, alfabet itd.<br /><br />Więcej pomocnych informacji na temat ustawień języków obsługiwanych przez PhpGedView uzyskasz po wybraniu języka i kliknięciu przycisku <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Więcej pomocy znajduje się na stronie konfiguracji danego języka.<br />";
$pgv_lang["hide_translated"]		= "Ukryj przetłumaczone";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Wybranie <b>Tak</b> spowoduje, że widoczne będą tylko te komunikaty z wybranego pliku językowego, które nie zostały jeszcze przetłumaczone. Oznacza to, że nowy komunikat jeszcze <u>nie występuje</u> w docelowym pliku językowym.<br /><br />Niektóre pliki językowe zawierają angielski tekst różnych nieprzetłumaczonych komunikatów. Ta procedura nie może zidentyfikować tych nieprzetłumaczonych elementów, ponieważ już istnieją w pliku docelowym. Zakłada się, że jeśli komunikat występuje w pliku docelowym, musiał zostać przetłumaczony.<br />";
$pgv_lang["lang_file_write_error"]	= "Błąd! Zapisywanie zmian do pliku <b>#lang_filename#</b> nie powiodło się. Sprawdź uprawnienia i spróbuj ponownie.";
$pgv_lang["no_open"]	= "Błąd! Otwieranie pliku <b>#lang_filename#</b> nie powiodło się.";
$pgv_lang["users_langs"]			= "Języki użytkowników";
$pgv_lang["configured_languages"]	= "Używane języki";
$pgv_lang["um_header"] = "Migrator informacji o użytkownikach";
$pgv_lang["um_proceed"] = "Wybierz opcję lub kliknij na odnośnik poniżej aby powrócić do menu administracji.<br />";
$pgv_lang["um_creating"] = "Tworzenie";
$pgv_lang["um_sql_index"] = "To narzędzie utworzy plik <i>authenticate.php</i> i kilka plików <i>.dat</i> w twoim katalogu indeksowym.<br /><br />Kiedy tworzenie zakończy się pomyślnie, możesz przejść do trybu indeksowego, w którym będą dostępni wszyscy bieżący użytkownicy i ich wiadomości, ulubione, artykuły i ustawienia układu.<br /><br />Uwaga: po przejściu do trybu indeksowego musisz ponownie zaimportować swoje pliki GEDCOM.<br />";
$pgv_lang["um_file_create_fail1"] = "Tworzenie nowego pliku nie powiodło się - plik o tej nazwie już istnieje:";
$pgv_lang["um_file_create_fail2"] = "Tworzenie nie powiodło się";
$pgv_lang["um_file_create_fail3"] = "Sprawdź prawa dostępu do tego katalogu.";
$pgv_lang["um_file_create_succ1"] = "Tworzenie nowego pliku zostało zakończone pomyślnie:";
$pgv_lang["um_file_not_created"] = "Plik nie został utworzony.";
$pgv_lang["um_nomsg"] = "Brak wiadomości w systemie.";
$pgv_lang["um_nofav"] = "Brak ulubionych w systemie.";
$pgv_lang["um_nonews"] = "Brak artykułów w systemie.";
$pgv_lang["um_noblocks"] = "Brak sekcji w systemie.";
$pgv_lang["um_index_sql"] = "To narzędzie zaimportuje plik <i>authenticate.php</i> i kilka innych plików  <i>.dat</i> z twojego katalogu indeksowego do bazy danych.<br />";
$pgv_lang["um_noaction"] = "Nie trzeba nic robić, aby przenieść informację o użytkownikach do trybu SQL.<br /><br />Po przejściu w tryb SQL musisz ponownie uruchomić migrator użytkowników i zaimportować wszystkie dane do bazy danych SQL. PhpGedView użyje istniejących plików z trybu indeksowego.<br /><br /><b><u>Nie usuwaj</u> pliku <i>authenticate.php</i> ani plików <i>.dat</i> ze swojego katalogu indeksowego podczas zmiany trybu.</b><br />";
$pgv_lang["um_import"] = "Import";
$pgv_lang["um_export"] = "Eksport";
$pgv_lang["um_explain"] = "To narzędzie umożliwia eksportowanie danych o użytkownikach z trybu SQL do indeksowego oraz importowanie danych z plików indeksowych do tabel SQL.<br /><br />Informacje o użytkownikach, ulubione, ustawienia układu, wiadomości i artykuły będą ponownie dostępne po migracji.<br /><br /><b>Uwaga</b><br />Nie możesz użyć tego narzędzia do przenoszenia informacji o użytkownikach pomiędzy różnymi wersjami PhpGedView. Upewnij się, że dane pochodzą z lub są importowane do tej samej wersji PhpGedView.<br /><br /><b>IMPORT</b><br />Jeśli wybierzesz importowanie plików danych o użytkownikach z trybu indeksowego, wszystkie informacje na temat użytkowników istniejące w tabelach bazy danych zostaną <u>nadpisane</u>. To narzędzie <u>nie scala</u> informacji. Po wykonaniu importu nie ma sposobu odzyskania utraconych danych za pomocą PhpGedView.<br /><br /><b>EKSPORT</b><br />Jeśli eksportujesz informację o użytkownikach z bazy danych SQL do plików trybu indeksowego, to narzędzie utworzy plik <i>authenticate.php</i> oraz kilka plików <i>.dat</i> w twoim katalogu indeksowym. Jeśli pliki o takich samych nazwach już tam istnieją, system zapyta, czy chcesz je nadpisać. Po przejściu w tryb indeksowy wszystkie dane będą od razu dostępne.<br /><br /><b>Uwaga:</b> Po przejściu w tryb indeksowy musisz ponownie zaimportować swoje pliki GEDCOM.<br />";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Przenieś użytkowników z trybu SQL do indeksowego~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Przenieś użytkowników z trybu indeksowego do SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importowanie użytkowników";
$pgv_lang["um_imp_blocks"] = "Importowanie sekcji";
$pgv_lang["um_imp_favorites"] = "Importowanie ulubionych";
$pgv_lang["um_imp_messages"] = "Importowanie wiadomości";
$pgv_lang["um_imp_news"] = "Importowanie artykułów";
$pgv_lang["um_nousers"] = "Brak pliku <i>authenticate.php</i> w katalogu indeksowym. Migracja została anulowana.";
$pgv_lang["um_imp_succ"] = "Importowanie zakończone pomyślnie";
$pgv_lang["um_imp_fail"] = "Importowanie nie powiodło się";
$pgv_lang["um_backup"] = "Kopia zapasowa";
$pgv_lang["um_zip_succ"] = "Tworzenie pliku ZIP zakończone pomyślnie.";
$pgv_lang["um_zip_dl"] = "Pobierz plik kopii zapasowej spakowany ZIPem";
$pgv_lang["um_bu_explain"] = "To narzędzie umożliwia tworzenie kopii zapasowej kilku typów danych w PhpGedView.<br /><br />Wybrane do skopiowania dane zostaną spakowane w jeden plik ZIP, który możesz pobrać po pomyślnym zakończeniu tworzenia kopii zapasowej klikając odnośnik na dole strony.<br /><br />Plik ZIP pozostanie w twoim katalogu indeksowym dopóki nie usuniesz go ręcznie.<br />";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "Plik konfiguracyjny PhpGedView";
$pgv_lang["um_bu_gedcoms"] = "Pliki GEDCOM ";
$pgv_lang["um_bu_gedsets"] = "Pliki ustawień, konfiguracji i prywatności GEDCOM";
$pgv_lang["um_bu_logs"] = "Liczniki GEDCOM, pliki SearchLog i pliki logów PhpGedView";
$pgv_lang["um_bu_usinfo"] = "Definicje użytkowników, ustawienia układu, ulubione, wiadomości, artykuły";
$pgv_lang["um_bu_media"]	= "Pliki multimedialne";
$pgv_lang["um_mk_bu"] = "Twórz kopię zapasową";
$pgv_lang["um_nofiles"] = "Brak plików do utworzenia kopii zapasowej.";
$pgv_lang["um_files_exist"] = "Co najmniej jeden taki plik już istnieje. Czy chcesz je nadpisać?";
$pgv_lang["um_results"]		= "Wyniki";
$pgv_lang["preview_faq_item"] = "Przejrzyj wszystkie elementy FAQ";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />Ta opcja pozwala administratorowi zobaczyć stronę FAQ bez opcji edycji i odnośników.<br /><br />Za wyjątkiem pojedynczego odnośnika <b>Edytuj</b> nad pierwszym elementem FAQ, wygląd strony będzie identyczny z tym, co zobaczy zwykły użytkownik. Ten specjalny odnośnik <b>Edytuj</b> przywróci pełną możliwość edytowania strony FAQ.<br />";
$pgv_lang["restore_faq_edits"] = "Przywróć możliwość edycji FAQ";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />Ta opcja przywraca stronę FAQ do zwykłego stanu widzianego przez administratora, w którym można edytować poszczególne elementy FAQ.<br />";
$pgv_lang["add_faq_item"] = "Dodaj element FAQ";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />Ta opcja umożliwia dodanie nowego elementu do strony FAQ.<br />";
$pgv_lang["edit_faq_item"] = "Edytuj element FAQ";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />Ta opcja umożliwia edycję elementu na stronie FAQ.<br />";
$pgv_lang["delete_faq_item"] = "Usuń element FAQ";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />Ta opcja umożliwia usunięcie elementu ze strony FAQ.<br />";
$pgv_lang["moveup_faq_item"] = "Przesuń element FAQ do góry";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />Ta opcja umożliwia przesunięcie elementu FAQ w górę na stronie FAQ.<br /><br />Za każdym razem, kiedy używasz tej opcji, numer pozycji danego elementu zmniejsza się o jeden. Możesz osiągnąć ten sam efekt edytując dany element i zmieniając jego pole pozycji. Jeśli więcej niż jeden element ma ten sam numer pozycji, tylko jeden z nich będzie widoczny.<br />";
$pgv_lang["movedown_faq_item"] = "Przesuń element FAQ w dół";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />Ta opcja umożliwia przesunięcie elementu FAQ w dół na stronie FAQ.<br /><br />Za każdym razem, kiedy używasz tej opcji, numer pozycji danego elementu zwiększa się o jeden. Możesz osiągnąć ten sam efekt edytując dany element i zmieniając jego pole pozycji. Jeśli więcej niż jeden element ma ten sam numer pozycji, tylko jeden z nich będzie widoczny.<br />";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br />To jest tytuł lub temat elementu FAQ.<br /><br />Treść tego pola można formatować. Dozwolone są znaczniki HTML, takie jak &lt;b&gt; i &lt;br&gt; oraz encje HTML, takie jak &amp;amp; i &amp;nbsp;. Nie ma sposobu na wprowadzenie znaczników HTML, więc będą one interpretowane jako zwykły tekst.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br />To jest treść elementu FAQ.<br /><br />Treść tego pola można formatować. Dozwolone są znaczniki HTML, takie jak &lt;b&gt; i &lt;br&gt; oraz encje HTML, takie jak &amp;amp; i &amp;nbsp;. Nie ma sposobu na wprowadzenie znaczników HTML, więc będą one interpretowane jako zwykły tekst.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_pgvLangRefs"] = "Możesz wprowadzać odniesienia do wpisów w plikach językowych lub do zmiennych globalnych. Przykłady: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;to odniesienie do zmiennej językowej \$pgv_lang[\"add_to_cart\"], i jeśli miałoby się pojawić w tym polu, tak wyglądałoby w bieżącym języku: <b>#pgv_lang[add_to_cart]#</b></li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;to odniesienie do nazwy faktu \$factarray[\"AFN\"], i jeśli miałoby się pojawić w tym polu, tak wyglądałoby w bieżącym języku: <b>#factarray[AFN]#</b></li><li><b>&#x23;GLOBALS[VERSION]&#x23;&nbsp;&#x23;GLOBALS[VERSION_RELEASE]&#x23;</b>&nbsp;&nbsp;&nbsp;to odniesienie do zmiennej globalnej \$VERSION, spacja i odniesienie do zmiennej globalnej \$VERSION_RELEASE, i jeśli miałyby się pojawić w tym polu, tak wyglądałyby w bieżącym języku: <b>#GLOBALS[VERSION]#&nbsp;#GLOBALS[VERSION_RELEASE]#</b></li><li><b>&#x23;GLOBALS[GEDCOM]&#x23</b>&nbsp;&nbsp;&nbsp;to odniesienie do zmiennej globalnej \$GEDCOM, która jest nazwą bieżącego pliku GEDCOM, i jeśli miałoby się pojawić w tym polu, wyglądałoby tak: <b>#GLOBALS[GEDCOM]#</b></li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23</b>&nbsp;&nbsp;&nbsp;to odniesienie do zmiennej globalnej \$GEDCOM_TITLE, która jest tytułem bieżącego pliku GEDCOM, i jeśli miałoby się pojawić w tym polu, wyglądałoby tak: <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Ta opcja przydaje się, kiedy chcesz utworzyć listy FAQ osobne dla każdego języka obsługiwanego przez twoją stronę. Własne tytuły i wpisy FAQ należy umieszczać w plikach <i>languages/extra.xx.php</i> (gdzie <i>xx</i> jest kodem języka) w następującym formacie:<br />\$pgv_lang[\"faq_title1\"] = \"To jest przykładowy tytuł FAQ\";<br />\$pgv_lang[\"faq_body1\"] = \"To jest przykładowa treść FAQ.\";<br />";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br />To pole określa kolejność, w jakiej zostaną wyświetlone elementy FAQ.<br /><br />Nie trzeba wprowadzać kolejnych numerów. Jeśli zostawisz przerwy w numeracji, będzie można później wstawić w nie inne elementy. Na przykład jeśli użyjesz numerów 1, 6, 11, 16, możesz potem wstawić elementy o brakujących numerach. Dozwolone są także wartości ujemne i zero, przydatne przy wstawianiu elementów na samym początku.<br /><br />Jeśli więcej niż jeden element FAQ ma ten sam numer pozycji, tylko jeden z nich będzie widoczny.<br />";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br />Możesz określić, czy chcesz, żeby ten element FAQ był widoczny niezależnie od bieżącego pliku GEDCOM, czy ma być widoczny tylko dla bieżącego pliku GEDCOM.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Element FAQ pojawi się we wszystkich listach FAQ, niezależnie od bieżącego pliku GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;Element FAQ pojawi się tylko w liście FAQ do bieżącego pliku GEDCOM.</li></ul><br />";
$pgv_lang["index_gedcom_news_adm_help"]		= "Treść artykułów GEDCOM może zawierać <b>znaczniki HTML</b> oraz <b>encje HTML</b>. Nie należy stosować HTMLa w tytułach artykułów.<br /><br />Upewnij się, że zawsze zamykasz znaczniki. Pomocna jest znajomość HTMLa na poziomie administratora strony. Ten system korzysta także ze <b>stylów CSS (Cascading Style Sheets)</b>. Dla każdego motywu istnieje osobny styl CSS. Możesz stosować klasy z tych arkuszy stylów do sterowania wyglądem wiadomości.<br /><br />Na stronie PhpGedView możesz zobaczyć przykłady zastosowania znaczników w sekcji artykułów GEDCOM.<br /><br />Podobnie, jak w przypadku listy FAQ, w tytułach i treści artykułów można stosować odniesienia do \$pgv_lang, \$factarray, zmiennych globalnych \$GLOBALS, aby zapewnić całkowitą elastyczność tworzenia artykułów, które w dużym stopniu zależą od bieżącego języka.<br /><br />Następujący opis, pochodzący z treści pomocy listy FAQ, odnosi się także do artykułów GEDCOM.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br /><br />";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Limit czasu, przez który importer może nieprzerwanie działać przetwarzając plik GEDCOM.";
$pgv_lang["media_import_help"] = "~#pgv_lang[media_import]#~<br />Ten import przekonwertuje odnośniki do multimediów w twoim pliku GEDCOM do wpisów multimedialnych. Na przykład następujący wpis multimedialny zostanie zmieniony z: <blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/babcia.jpg<br />2 TITL Zdjęcie babci</code></blockquote>na:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/babcia.jpg<br />1 TITL Zdjęcie babci</code></blockquote>Nowy wpis multimedialny będzie przechowywany osobno w bazie danych. Odnośniki do zewnętrznych plików multimedialnych zostaną zamienione na odniesienia do nowego wpisu multimedialnego, który z kolei zawiera odniesienie do pliku zewnętrznego. Na przykład następujący wpis GEDCOM zostanie zmieniony z:<blockquote><code>0 @I1@ INDI<br />1 NAME Twoje/Nazwisko/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/babcia.jpg<br />2 TITL Zdjęcie babci</code></blockquote>na:<blockquote><code>0 @I1@ INDI<br />1 NAME Twoje/Nazwisko/<br />1 OBJE @M1@<br /></code></blockquote>Korzystanie z wpisów multimedialnych ma tą przewagę, że możesz łatwo zarządzać multimediami. Jeśli zmienisz tytuł wpisu multimedialnego, zostanie on zmieniony we wszystkich wpisach GEDCOM, które się do niego odnoszą. Do tego samego wpisu może się odnosić wiele osób, rodzin i źródeł.";
$pgv_lang["add_new_lang_button"]	= "Dodaj nowy język";
$pgv_lang["ltr"]			= "Od lewej do prawej";
$pgv_lang["name_reverse"]		= "Nazwiska pierwsze";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />W niektórych językach nazwisko powinno być wyświetlane na początku, a nie - jak jest domyślnie - na końcu. Włączenie tej opcji spowoduje wyświetlanie nazwiska na początku. Przykładami języków, w których nazwisko zwykle znajduje się na początku, są węgierski, chiński i japoński.<br />";
$pgv_lang["name_reverse"]		= "Imiona pierwsze";
$pgv_lang["week_start"]			= "Pierwszy dzień tygodnia";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />Dzień tygodnia rozpoczynający nowy tydzień w danym języku. W większości języków nowy tydzień rozpoczyna się w niedzielę, ale w pewnych językach jest to poniedziałek lub inny dzień.<br />";
$pgv_lang["lang_new_language"]		= "Nowy język";
$pgv_lang["original_lang_name"]		= "Nazwa języka w oryginale w #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Nazwa języka w oryginale~<br /><br />Nazwa języka w tym języku.<br /><br />Angielski nazywa się <b>English</b>; niemiecki -  <b>Deutsch</b>; holenderski - <b>Nederlands</b>; czeski - <b>Ceština</b>, itd.<br />";
$pgv_lang["lang_shortcut"]		= "Skrót dla plików językowych";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Ten kod definiuje skrót nazwy języka. Ten skrót tworzy część nazwy każdego pliku językowego, używanego przez PhpGedView. Na przykład skrót dla języka francuskiego to <b>fr</b>, dlatego nazwy francuskich plików językowych to <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i> i <i>lang.<b>fr</b>.php</i><br />";
$pgv_lang["lang_langcode"]		= "Kody wykrywania języka";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Te kody umożliwiają PhpGedView wykrywanie ustawienia preferowanego języka przeglądarki użytkownika. PhpGedView rozpoznaje żądany przez przeglądarkę język porównując kod języka przeglądarki z tą listą. Elementy listy muszą być rozdzielane średnikiem.<br />";
$pgv_lang["lang_filenames"]		= "Pliki językowe";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Plik flagi";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Nazwa pliku graficznego przedstawiającego flagę narodową dla wybranego języka.<br /><br />Grafiki flag wielu państw są dostępne na stronie <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a>.<br /><br />Kiedy znajdziesz odpowiednią flagę, kliknij na niej prawym przyciskiem i zapisz plik w katalogu tymczasowym.  Następnie otwórz zapisany obrazek w odpowiednim edytorze graficznym  (dla systemów windowsowych zaleca się IrfanView), zmniejsz jego rozmiar do 50x32 pikseli, czyli normalnego rozmiaru używanego w PhpGedView, i zapisz go jako plik GIF w katalogu <i><b>images/flags</b></i>.<br /><br />Chociaż możesz użyć dowolnej nazwy, powinno się wybierać nazwę zgodną z konwencją dwuliterowego skrótu nazwy języka. Na przykład dla chorwackiego, który ma skrót <i><b>hr</b></i>, plik z chorwacką flagą nazywałby się <i><b>hr.gif</b></i>.<br />";
$pgv_lang["text_direction"]		= "Kierunek tekstu";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Określa, w którym kierunku pisze i czyta się w danym języku. Większość języków ma orientację od lewej do prawej. Język arabski i hebrajski są przykładami języków, które mają odwrotną orientację (od prawej do lewej).<br />";
$pgv_lang["date_format"]			= "Format daty";
$pgv_lang["date_format_help"]		= "~#pgv_lang[date_format]#~<br /><br />To pole określa format daty wykorzystywany przez PhpGedView do wyświetlania dat z bazy danych.<ul><li><b>Format standardowy</b><br />Możesz używać następujących symboli:<br /><b>D</b> - dzień<br /><b>M</b> - miesiąc<br /><b>Y</b> - rok<br /><br />Możesz zmieniać kolejność tych symboli i dodawać do formatu znaki rozdzielające.<br /><br />W poniższych przykładach przyjęto, że data w bazie danych to 1965.08.20, która w rzeczywistości jest zapisana w postaci <b>DATE&nbsp;20&nbsp;Aug&nbsp;1965</b>.<br /><br />Domyślnym ustawieniem dla angielskiego formatu wyświetlania daty jest <b>D&nbsp;M&nbsp;Y</b>, co powoduje wyświetlenie daty jako <b>20&nbsp;August&nbsp;1965</b>.<br /><br />Niemiecki format daty to zwykle <b>D.&nbsp;M&nbsp;Y</b>, powodujące wyświetlenie przez PhpGedView <b>20.&nbsp;August&nbsp;1965</b>. Ósmy miesiąc nazywa się \"August\" zarówno po angielsku, jak i niemiecku.<br /><br />W języku węgierskim data ma zwykle format <b>Y.&nbsp;M&nbsp;D.</b> co powoduje wyświetlenie <b>1965.&nbsp;augusztus&nbsp;20.</b> przez PhpGedView. W języku węgierskim miesiące pisane są z małej litery, a ósmy miesiąc nazywa się \"augusztus\".<br /><br /></li><li><b>Format rozszerzony</b><br />Aby wyświetlić daty w specjalny sposób, niemożliwy do osiągnięcia za pomocą <b>formatu standardowego</b>, możesz użyć następujących kodów:<br /><b>d</b> - dzień miesiąca w postaci dwucyfrowej, dni do 10 mają zero na początku; tzn. <b>01</b> do <b>31</b><br /><b>D</b> - słowny trzyliterowy skrót dnia tygodnia; np. <b>Fri</b><br /><b>F</b> - pełna nazwa słowna miesiąca; np. <b>January</b><br /><b>j</b> - dzień miesiąca bez zera przed dniami do 10; tzn. <b>1</b> do <b>31</b><br /><b>l</b> (mała litera \"L\") - pełna nazwa słowna dnia tygodnia; tzn. <b>Friday</b><br /><b>M</b> - trzyliterowy skrót nazwy miesiąca; np. <b>Jan</b><br /><b>Y</b> - czterocyfrowy rok; np. <b>1999</b><br /><b>R</b> - format francuskiego kalendarza rewolucyjnego (zobacz uwagi)<br /><b>y</b> - dwucyfrowy rok; np. <b>99</b><br /><br />Na przykład format daty <b>D&nbsp;j&nbsp;F&nbsp;Y</b> spowodowałby wyświetlenie <b>Thu&nbsp;9&nbsp;January&nbsp;1806</b>, podczas gdy ta sama data w formacie <b>l&nbsp;d&nbsp;M&nbsp;Y</b> zostałaby wyświetlona jako <b>Thursday&nbsp;09&nbsp;Jan&nbsp;1806</b><br /><br /></li><li><b>Format francuskiego kalendarza rewolucyjnego</b><br />Kod <b>R</b> działa we wszystkich językach, ale powoduje wyświetlenie daty tylko z przedziału od 1792.09.22 do 1805.12.31. Kod <b>R</b> powoduje wyświetlenie wyłącznie tekstu francuskiego, i nie można w nim zmienić kolejności dnia, miesiąca i roku. Rezultat zastosowania kodu formatującego <b>R</b> jest podkreślony, dla rozróżnienia od zwykłej daty.<br /><br />Kiedy format daty zawiera tylko kody <b>D</b>, <b>M</b> i <b>Y</b>, kod formatujący <b>R</b> uznaje się za zwykły tekst, jak opisano w temacie <b>format standardowy</b> powyżej. Innymi słowy, aby kod <b>R</b> został rozpoznany jako kod specjalny, format daty musi zawierać kod z listy kodów <b>formatu rozszerzonego</b>, który nie występuje w <b>formacie standardowym</b>.<br /><br />Na przykład format <b>D&nbsp;M&nbsp;Y&nbsp;R</b> spowoduje wyświetlenie <b>13&nbsp;October&nbsp;1797&nbsp;R</b> w języku angielskim dla daty 1797.10.13. Z drugiej strony, format  <b>j&nbsp;F&nbsp;Y&nbsp;R</b> spowoduje wyświetlenie tej samej daty w języku angielskim jako <b>13&nbsp;October&nbsp;1797&nbsp;<u>22&nbsp;Vendemiaire&nbsp;An&nbsp;6</u></b>.</li></ul>";
$pgv_lang["lang_name_polish"]		= "polski";
$pgv_lang["lang_name_portuguese"]	= "portugalski";
$pgv_lang["lang_name_portuguese-br"]	= "portugalski (Brazylia)";
$pgv_lang["lang_name_russian"]		= "rosyjski";
$pgv_lang["lang_name_spanish"]		= "hiszpański";
$pgv_lang["lang_name_spanish-ar"]	= "hiszpański (Ameryka Łacińska)";
$pgv_lang["lang_name_swedish"]		= "szwedzki";
$pgv_lang["lang_name_turkish"]		= "turecki";
$pgv_lang["lang_name_greek"]		= "grecki";
$pgv_lang["lang_name_arabic"]		= "arabski";
$pgv_lang["lang_name_lithuanian"]	= "litewski";
$pgv_lang["lang_name_vietnamese"]	= "wietnamski";
$pgv_lang["lang_name_slovak"]		= "słowacki";
$pgv_lang["lang_name_estonian"]		= "estoński";
$pgv_lang["lang_language"]		= "Język";
$pgv_lang["export_filename"]		= "Nazwa pliku wynikowego";
$pgv_lang["lang_back"]			= "Powrót do menu konfiguracji plików językowych";
$pgv_lang["lang_back_admin"]		= "Powrót do menu administracji";
$pgv_lang["lang_back_manage_gedcoms"]	= "Powrót do menu zarządzania plikami GEDCOM";
$pgv_lang["lang_name_czech"]		= "czeski";
$pgv_lang["lang_name_chinese"]		= "chiński";
$pgv_lang["lang_name_danish"]		= "duński";
$pgv_lang["lang_name_dutch"]		= "holenderski";
$pgv_lang["lang_name_english"]		= "angielski";
$pgv_lang["lang_name_finnish"]		= "fiński";
$pgv_lang["lang_name_french"]		= "francuski";
$pgv_lang["lang_name_german"]		= "niemiecki";
$pgv_lang["lang_name_hebrew"]		= "hebrajski";
$pgv_lang["lang_name_hungarian"]	= "węgierski";
$pgv_lang["lang_name_italian"]		= "włoski";
$pgv_lang["lang_name_norwegian"]	= "norweski";
$pgv_lang["lang_edit"]			= "Edytuj";
$pgv_lang["export"]			= "Eksportuj";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#<br />";
$pgv_lang["export_lang_utility_desc"]	= "Umożliwia tworzenie dokumentacji dla administratorów.<br /><br />Narzędzie generuje wersję HTML pliku pomocy konfiguracyjnej w wybranym języku. Ten plik, w wersji do druku, można przeglądać za pomocą przeglądarki.";
$pgv_lang["export_ok"]			= "Komunikaty pomocy zostały wyeksportowane";
$pgv_lang["compare_lang_utility"]	= "Porównywanie plików językowych";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["compare_lang_utility_desc"]	= "Narzędzie porównuje dwa zbiory plików językowych i tworzy spis dodatków i usunięć, którymi się różnią. <br /><br />Aby śledzić zmiany w angielskiej wersji, przejrzyj plik <a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>. Pliki w języku angielskim stanowią szablon, z którego powinny korzystać inne wersje językowe.";
$pgv_lang["new_language"]		= "Pierwszy język";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Z tej listy możesz wybrać język, który chcesz porównać do drugiego języka.<br /><br />Wszelkie zmiany i dodatki do plików językowych pojawiają się najpierw w <b>angielskich</b> plikach językowych, więc zwykle jednym z porównywanych języków jest angielski.<br />";
$pgv_lang["old_language"]		= "Drugi język";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Z tej listy możesz wybrać język, który chcesz porównać do języka wybranego z listy <b>Pierwszy język</b>.<br /><br />Po wybraniu języka kliknij przycisk <b>Porównaj</b> aby zobaczyć listę wszystkich dodatków i usunięć we wszystkich czterech plikach obu języków.<br /><br />Dla przypomnienia:<br /><b>Dodatek</b> oznacza: ten komunikat <u>jest</u> w pliku pierwszego języka, ale <u>nie ma</u> go w pliku drugiego języka.<br /><br /><b>Usunięcie</b> oznacza:  tego komunikatu <u>nie ma</u> w pliku pierwszego języka, ale <u>jest</u> w pliku drugiego języka. Może się tak zdarzyć, jeśli komunikat został wycofany z użycia i usunięty z plików angielskich. Możesz bezpiecznie usunąć odpowiednik takiego komunikatu z pliku drugiego języka.<br />";
$pgv_lang["compare"]			= "Porównaj";
$pgv_lang["comparing"]			= "Porównane pliki językowe";
$pgv_lang["additions"]			= "Dodatki";
$pgv_lang["no_additions"]		= "Brak dodatków";
$pgv_lang["subtractions"]		= "Usunięcia";
$pgv_lang["no_subtractions"]		= "Brak usunięć";
$pgv_lang["config_lang_utility"]	= "Konfiguracja dostępnych języków";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Ta strona umożliwia kontrolę nad ustawieniami językowymi. Na przykład możesz pozostawić swoim użytkownikom wybór wyłącznie między niemieckim i francuskim. Ta opcja przydaje się na przykład wtedy, kiedy nie potrafisz porozumiewać się z użykownikami po węgiersku.<br /><br />Tutaj możesz także zmienić pewne aspekty PhpGedView, które zależą od wybranego języka. Na przykład możesz określić format daty i godziny.<br /><br />Aktywnych i zacieniowanych szarym kolorem języków nie można wyłączyć, ponieważ są aktualnie w użyciu. Na dole tabelki możesz zobaczyć, gdzie język jest używany. Kiedy język przestanie być używany, będzie można go wyłączyć.<br /><br />Wszystkie wprowadzone przez ciebie zmiany zostaną zapisane w nowym pliku o nazwie <b>lang_settings.php</b>, utworzonym w katalogu <b>#INDEX_DIRECTORY#</b>. Kolejne zmiany będą dokonywane i zapisywane wyłącznie w tym nowym pliku. Możesz powrócić do oryginalnych domyślnych ustawień językowych usuwając ten plik.<br /><br />Jeśli zgłaszasz problem z ustawieniami językowymi, poinformuj zespół pomocy technicznej, czy ten nowy plik istnieje.<br />";
$pgv_lang["active"]			= "Aktywny";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Pozwól użytkownikom wybierać ten język jeśli włączona jest opcja <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>.<br />";
$pgv_lang["edit_settings"]		= "Edytuj ustawienia";
$pgv_lang["SHOW_SOURCES"]		= "Pokaż źródła";
$pgv_lang["SHOW_SOURCES_help"]		= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Ustawia prywatny poziom dostępu dla wszystkich źródeł. Jeśli użytkownik nie ma dostępu do źródeł, lista źródeł zostanie usunięta z menu list, a zakładka źródła nie będzie widoczna na stronie danych osoby.<br />";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]		= "Wymagaj zatwierdzenia przez administratora rejestracji nowych użytkowników";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Jeśli jest łączona opcja <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b>, ta opcja określa, czy administrator musi zatwierdzać rejestrację.<br /><br />Ustawienie tej opcji na <b>Tak</b> wymaga potwierdzenia swojego zgłoszenia przez nowych użytkowników, a następnie zatwierdzenia przez administratora zanim będą mogli się zalogować. Ustawienie tej opcji na  <b>Nie</b> spowoduje, że pole wyboru <b>#pgv_lang[verified_by_admin]#</b> zostanie automatycznie zaznaczone kiedy użytkownicy będą potwierdzać swoje zgłoszenie, dzięki czemu będą mogli się od razu zalogować, bez interwencji administratora.<br /><br />Ta opcja ustawia zmienną \$REQUIRE_ADMIN_AUTH_REGISTRATION w pliku <i>config.php</i>.<br />";
$pgv_lang["SPLIT_PLACES"]		= "Rozdzielaj miejsca w trybie edycji";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Ustaw tą opcję na <b>Tak</b> aby rozdzielić każdą nazwę miejsca według przecinków na osobne pola dla łatwiejszej edycji. Na przykład:<br /><ol><li>Tryb domyślny<br /><u>Miejsce</u>: Half Moon Bay, San Mateo, California, USA<br /><br /></li><li>Tryb rozdzielania<br /><u>Państwo</u>: USA<br /><u>Stan</u>: California<br/><u>Województwo</u>: San Mateo<br/><u>Miasto</u>: Half Moon Bay</li></ol>";
$pgv_lang["ALLOW_REMEMBER_ME"]		= "Pokaż opcję <b>Zapamiętaj mnie</b> na stronie logowania";
$pgv_lang["ALLOW_REMEMBER_ME_help"]	= "~#pgv_lang[ALLOW_REMEMBER_ME]#~<br /><br />Wiele stron pozwala użytkownikom wybrać, czy chcą, aby ich dane zostały zapamiętane, kiedy następnym razem odwiedzą stronę z tego samego komputera. Włączenie tej opcji spowoduje umieszczenie pola wyboru <b>Zapamiętaj mnie</b> na stronie logowania. Zaznaczenie pola zezwala PhpGedView na przechowywanie pliku cookie (\"ciasteczka\") na komputerze użytkownika. Ten plik pozwala na przechowanie danych użytkownika pomiędzy kolejnymi wizytami z tego samego komputera zdalnego.<br /><br />Ustawia zmienną \$ALLOW_REMEMBER_ME w pliku <i>config.php</i>.<br />";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Podkreślaj imiona w cudzysłowiu";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Wiele aplikacji umieszcza preferowane imię w cudzysłowiu w pliku GEDCOM. Przyjętą konwencją jest podkreślanie preferowanego imienia. Włączenie tej opcji zamieni wszystkie imiona ujęte w cudzysłów na element <span> z klasą CSS \"starredname\".<br /><br />Na przykład włączenie tej opcji dla imienia zapisanego w pliku GEDCOM w postaci <br />1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ <br />spowodowałoby zamianę części ujętej w cudzysłów na<br /><span&nbsp;class=\"starredname\">Jean&nbsp;Paul</span> dla celów wydruku. W zależności od innych ustawień przeglądarka może wyświetlić to imię jako <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> lub <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b><br /><br />Ustawia zmienną \$UNDERLINE_NAME_QUOTES w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["PRIVACY_BY_RESN"]		= "Użyj ograniczenia prywatności GEDCOM (RESN)";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />Specyfikacja GEDCOM 5.5.1 daje możliwość wykorzystania znaczników RESN do ustawienia opcji prywatności dla osób i faktów w pliku GEDCOM. Włączenie tej opcji spowoduje, że system będzie szukał znaczników poziomu 1 we wpisach GEDCOM. Znaczniki poziomu 2 i wyższego są stosowane automatycznie i ta opcja nie będzie miała na nie wpływu. Pamiętaj, że ta opcja może spowolnić niektóre funkcje PhpGedView, takie jak wyświetlanie listy osób.<br /><br />Ustawia zmienną \$PRIVACY_BY_RESN w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Pokaż kody ceremonii mormońskich w ramkach wykresu";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Ustawienie tej opcji na <b>Tak</b> spowoduje pokazanie w ramkach wykresu kodów statutowych obrzędów mormońskich.<ul><li><b>B</b> - chrzest (Baptism)</li><li><b>E</b> - Namaszczenie (Endowment)</li><li><b>S</b> - Naznaczenie małżonka (Sealing to spouse)</li><li><b>P</b> - Naznaczenie rodziców (Sealing to parents)</li></ul>Osoba, która przeszła wszystkie obrzędy, będzie miała skrót <b>BESP</b> wyświetlony po nazwisku. Brakujące obrzędy są wskazane przez podkreślenie <b>_</b> w miejscu odpowieniej litery skrótu. Na przykład <b>BE__</b> oznacza brak obrzędów <b>S</b> i <b>P</b>.<br /><br />Ustawia zmienną  \$SHOW_LDS_AT_GLANCE w pliku <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Domyślna zakładka na stronie danych osoby";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Ta opcja pozwala określić, która zakładka zostanie wybrana automatycznie na stronie danych o osobie.<br /><br />Ustawia zmienną \$GEDCOM_DEFAULT_TAB w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Pokaż nazwiska po ślubie na liście osób";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Ta opcja umożliwia pokazanie na liście osób pełnego imienia i nazwiska małżonka po ślubie. Ta opcja wymaga wcześniejszego wygenerowania nazwisk po ślubie przy importowaniu pliku GEDCOM.<br /><br />Ustawia zmienną \$SHOW_MARRIED_NAMES w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_QUICK_RESN"]		= "Pokaż pola prywatności na formularzu #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Ta opcja pozwala na włączenie lub wyłączenie pól prywatności na formularzu #pgv_lang[quick_update_title]#. Pola prywatności pozwalają użytkownikowi wprowadzającemu dane za pomocą formularza na nadpisanie domyślnych ustawień prywatności dla faktu, który wprowadza.<br /><br />Ustawia zmienną \$SHOW_QUICK_RESN w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_QUICK_UPDATE"]		= "Użyj formularza #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Ta opcja pozwala zalogowanym użytkownikom nadsyłać zmiany za pomocą formularza #pgv_lang[quick_update_title]#.<br /><br />Ustawia zmienną \$USE_QUICK_UPDATE w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archiwizuj pliki SearchLog";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Jak często system powinien archiwizować pliki Searchlog files.<br /><br />Ustawia zmienną \$SEARCHLOG_CREATE w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHANGELOG_CREATE"]		= "Archiwizuj pliki ChangeLog";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Jak często system powinien archiwizować pliki Changelog files.<br /><br />Ustawia zmienną \$CHANGELOG_CREATE w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHART_BOX_TAGS"]		= "Inne fakty widoczne na wykresach";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Powinna być to lista faktów rozdzielana przecinkami lub spacjami (dodatkowo poza urodzeniem i śmiercią), które mają być widoczne w ramkach wykresów, takich jak wykres rodowy. Ta lista wymaga użycia znaczników faktów, zdefiniowanych w standardzie GEDCOM 5.5.1. Na przykład, jeśli chcesz pokazać w ramce zawód, dodajesz do tego pola znacznik \"OCCU\".<br /><br />Ustawia zmienną \$CHART_BOX_TAGS w pliku <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["gedcom_conf"]		= "Podstawy GEDCOM";

$pgv_lang["new_gedcom_title"]		= "Genealogia z [#GEDCOMFILE#]";
$pgv_lang["keep_media_help"]			= "~#pgv_lang[keep_media]#~<br /><br />Czy istniejące odnośniki do multimediów należy zachować w bazie danych przy wgrywaniu nowej wersji pliku GEDCOM. Wybranie <b>Nie</b> spowoduje usunięcie istniejących odnośników do multimediów z bazy danych, zaś opcja <b>Tak</b> pozwala je zachować.<br /><br />Ta opcja jest przydatna kiedy eksportujesz plik GEDCOM do własnej aplikacji, która nie potrafi obsługiwać wskaźników do zagnieżdżonych multimediów, a następnie chcesz z powrotem zaimportować zmieniony GEDCOM do PhpGedView. W tej sytuacji wskaźniki do multimediów w wyeksportowanym pliku GEDCOM zostaną usunięte i będzie trzeba ponownie powiązać wszystkie multimedia do odpowiednich wpisów o osobach, rodzinach i źródłach po ponownym zaimportowaniu do PhpGedView.<br /><br />Wybranie <b>Tak</b> powoduje zachowanie przez PhpGedView istniejących powiązań z multimediami, dzięki czemu nie trzeba ich znowu tworzyć po ponownym zaimportowaniu zmienionego pliku GEDCOM, ale twoja aplikacja musi zawsze generować te same identyfikatory osoby, rodziny i źródła.<br /><br /><i>Family Tree Maker</i> jest jedną z aplikacji, które <u>nie</u> obsługują poprawnie wskaźników do multimediów w plikach GEDCOM. <i>Legacy</i>, jak wiele innych, <u>potrafi</u> obsługiwać je poprawnie.<br /><br />";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Użyj przeglądarki multimediów";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Kiedy ten parametr ustawiony jest na <b>Tak</b>, po kliknięciu na obrazek na twojej stronie użytkownicy zostaną przekierowanie na stronę Widok mediów, wprowadzony w wersji v4.1. Strona Widok mediów wyświetla szczegóły obrazka i pozwala na ich edycję.<br /><br />Ustawienie tego parametru na <b>Nie</b> spowoduje zachowanie analogiczne do starszych wersji PhpGedView, przed wersją v4.1, gdzie kliknięcie na obrazek otwiera nowe okno z obrazkiem w pełnej rozdzielczości.<br /><br />";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Pokaż tagline programu";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />Na stronach tworzonych dla wyszukiwarek, pokaż jako ostatni wiersz wyszukiwarkę, która została wykryta przez stronę. Włączenie tej opcji może spowodować, że Google AdSense zastosuje narzędzia optymalizacji wyszukiwarki.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Ta opcja zachowa powiązania rodzinne w ukrytych wpisach. Oznacza to, że zobaczysz puste \"prywatne\" miejsca na wykresie rodowym i innych wykresach zawierających prywatne dane.<br /><br />To ustawienie jest analogiczne do zachowania wersji PhpGedView przed v4.0.<br /><br />To ustawienie jest domyślnie wyłączone. Zamiast włączenia tej opcji zaleca się ustawienie osoby-korzenia w konfiguracji GEDCOM na osobę, która nie jest ukryta.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Pokaż prywatne powiązania";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />W poprzednich wersjach PhpGedView zmiany w toku były przechowywane w pliku GEDCOM i zmienione wpisy były następnie \"zatwierdzane\" w bazie danych. Od wersji v4.1 zmiany w toku nie są już przechowywane w pliku GEDCOM, tylko w plikach zmian.<br /><br />Włączenie tego ustawienia spowoduje aktualizację pliku GEDCOM podczas zapisu zmian do bazy danych. Dzięki temu plik GEDCOM będzie zsynchronizowany z bazą danych. Ze względu na kompatybilność z wcześniejszymi wersjami to ustawienie jest domyślnie włączone.<br /><br />Możesz je wyłączyć, jeśli chcesz oszczędzać pamięć podczas zatwierdzania zmian.<br />";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synchronizuj zmiany z plikiem GEDCOM";
$pgv_lang["COMMIT_COMMAND_help"] 			= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />Jeśli chcesz korzystać z systemu kontroli wersji, takiego jak CVS, do archiwizowania zmian w twoim pliku GEDCOM i ustawień konfiguracji lub prywatności, wprowadź tu polecenie. Pozostaw pole puste jeśli nie chcesz używać systemu kontroli wersji. Poprawne opcje to <b>cvs</b> i <b>svn</b>.<br />";
$pgv_lang["COMMIT_COMMAND"] 			= "Polecenie zatwierdzenia kontroli wersji";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Wyszukiwanie na wielu stronach pozwala użytkownikom przeszukiwać na raz wiele stron PhpGedView, zdefiniowanych w zarządzaniu stronami lub dołączonych zewnętrznie. To ustawienie wskazuje, czy dostęp do wyszukiwania mają wszyscy, czy tylko autoryzowani użytkownicy.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Pokaż wyszukiwanie na wielu stronach";
$pgv_lang["DBPERSIST"]					= "Użyj stałych połączeń z bazą danych";
$pgv_lang["DBPERSIST_help"]				= "~#pgv_lang[DBPERSIST]#~<br /><br />Czy PhpGedView powinien używać do komunikacji z bazą danych stałych połączeń.<br /><br />Ustawienie opcji na <b>Tak</b> spowoduje wykorzystywanie istniejących połączeń przez PhpGedView, co przyspieszy dostęp do bazy danych. Jednak może to powodować błędy, jeśli maksymalna liczba połączeń w konfiguracji twojego hosta jest zbyt mała. Jeśli nie jesteś pewien(pewna) co do obsługi stałych połączeń przez twojego hosta, powinieneś(powinnaś) ustawić tą opcję na <b>Nie</b>.<br />";
$pgv_lang["INDI_FACTS_ADD"] 			= "Fakty osobowe";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />To jest lista faktów GEDCOM, które twoi użytkownicy mogą dodawać do osób. Możesz zmieniać tą listę, dowolnie usuwając lub dodając nazwy faktów (nawet własne). Nazwy faktów, które występują na tej liście, nie mogą występować jednocześnie na liście <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unikalne fakty osobowe";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />To jest lista faktów GEDCOM, które twoi użytkownicy mogą dodać tylko <u>raz</u> do osoby. Na przykład, jeśli na liście znajduje się urodzenie (BIRT), użytkownicy nie będą mogli dodać więcej niż jednego wpisu o urodzeniu (BIRT) do danej osoby. Nazwy faktów występujące na tej liście nie mogą jednocześnie występować na liście <i>#pgv_lang[INDI_FACTS_ADD]#</i>.<br />";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Podręczne fakty osobowe";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />To jest krótka lista faktów osobowych GEDCOM, które są wyświetlane obok pełnej listy i mogą być szybko dodane za jednym kliknięciem myszki.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "Fakty rodzinne";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />To jest lista faktów, które twoi użytkownicy mogą dodawać do rodzin. Możesz zmieniać tą listę, dowolnie usuwając lub dodając nazwy faktów (nawet własne). Nazwy faktów, które występują na tej liście, nie mogą jednocześnie występować na liście <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unikalne fakty rodzinne";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />To jest lista faktów GEDCOM, które twoi użytkownicy mogą dodać tylko <u>raz</u> do rodziny. Na przykład, jeśli na liście znajduje się małżeństwo (MARR), użytkownicy nie będą mogli dodać więcej niż jednego wpisu o małżeństwie (MARR) do danej rodziny. Nazwy faktów występujące na tej liście nie mogą jednocześnie występować na liście <i>#pgv_lang[FAM_FACTS_ADD]#</i>.<br />";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Podręczne fakty rodzinne";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />To jest krótka lista faktów rodzinnych GEDCOM, które są wyświetlane obok pełnej listy i mogą być szybko dodane za jednym kliknięciem myszki.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Fakty źródłowe";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />To jest lista faktów, które twoi użytkownicy mogą dodawać do źródeł. Możesz zmieniać tą listę, dowolnie usuwając lub dodając nazwy faktów (nawet własne). Nazwy faktów, które występują na tej liście, nie mogą jednocześnie występować na liście <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unikalne fakty źródłowe";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />To jest lista faktów GEDCOM, które twoi użytkownicy mogą dodać tylko <u>raz</u> do źródła. Na przykład, jeśli na liście znajduje się tytuł (TITL), użytkownicy nie będą mogli dodać więcej niż jednego wpisu o tytule (TITL) do danego źródła. Nazwy faktów występujące na tej liście nie mogą jednocześnie występować na liście <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.<br />";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Podręczne fakty źródłowe";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />To jest krótka lista faktów źródłowych GEDCOM, które są wyświetlane obok pełnej listy i mogą być szybko dodane za jednym kliknięciem myszki.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "Fakty repozytorium";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />To jest lista faktów, które twoi użytkownicy mogą dodawać do repozytoriów. Możesz zmieniać tą listę, dowolnie usuwając lub dodając nazwy faktów (nawet własne). Nazwy faktów, które występują na tej liście, nie mogą jednocześnie występować na liście <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unikalne fakty repozytorium";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />To jest lista faktów GEDCOM, które twoi użytkownicy mogą dodać tylko <u>raz</u> do repozytorium. Na przykład, jeśli na liście znajduje się nazwa (NAME), użytkownicy nie będą mogli dodać więcej niż jednego wpisu o nazwie (NAME) do danego repozytorium. Nazwy faktów występujące na tej liście nie mogą jednocześnie występować na liście <i>#pgv_lang[REPO_FACTS_ADD]#</i>.<br />";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Podręczne fakty repozytorium";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />To jest krótka lista faktów repozytorium GEDCOM, które są wyświetlane obok pełnej listy i mogą być szybko dodane za jednym kliknięciem myszki.<br />";
$pgv_lang["LANG_SELECTION"] 			= "Dostępne języki";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Możesz zmieniać listę języków dostępnych na twojej stronie PhpGedView dowolnie dodając lub usuwając zaznaczenie. Powoduje to uaktualnienie opcji dostępnych dla twoich użytkowników.<br /><br />Możesz uzyskać ten sam rezultat za pomocą odnośnika <b>#pgv_lang[enable_disable_lang]#</b> w menu #pgv_lang[admin]#, gdzie możesz także zmieniać ikonę flagi języka, format daty, czy kolejność imienia i nazwiska.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Przedrostek identyfikatora multimediów";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Podczas dodawania nowego wpisu multimedialnego w PhpGedView automatycznie tworzy się dla niego nowy identyfikator multimediów. Identyfikator multimediów będzie miał wskazany przedrostek.<br />";
$pgv_lang["FAM_ID_PREFIX"]		= "Przedrostek identyfikator rodziny";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Podczas dodawania nowego wpisu o rodzinie w PhpGedView automatycznie tworzy się dla niego nowy identyfikator rodziny. Identyfikator rodziny będzie miał wskazany przedrostek.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fakty rodzinne zawsze widoczne podczas szybkiej aktualizacji";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />To jest rozdzielona przecinkami lista znaczników faktów GEDCOM, które będą zawsze widoczne na zakładkach rodziny formularza szybkiej aktualizacji, niezależnie od tego, czy istnieją już we wpisie o osobie. Na przykład, jeśli małżeństwo (MARR) występuje na liście, pola daty ślubu i miejsca ślubu będą zawsze widoczne na formularzu.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Fakty rodzinne widoczne podczas szybkiej aktualizacji";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />To jest rozdzielana przecinkami lista znaczników faktów GEDCOM, które będą widoczne na zakładkach rodziny formularza szybkiej aktualizacji. Tylko fakty z tej listy będą widoczne na formularzu lub udostępnione jako opcje w miejscu, gdzie dodajesz nowe fakty na formularzu.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fakty zawsze widoczne podczas szybkiej aktualizacji";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />To jest rozdzielana przecinkami lista znaczników faktów GEDCOM, które będą zawsze widoczne na formularzu szybkiej aktualizacji, niezależnie od tego, czy istnieją już we wpisie o osobie. Na przykład, jeśli urodzenie (BIRT) występuje na liście, pola daty urodzenia i miejsca urodzenia będą zawsze widoczne na formularzu.<br />";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fakty widoczne przy szybkiej aktualizacji";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />To jest rozdzielana przecinkami lista znaczników faktów GEDCOM, które będą widoczne na formularzu szybkiej aktualizacji. Tylko fakty z tej listy będą widoczne na formularzu lub udostępnione jako opcje w miejscu, gdzie dodajesz nowe fakty na formularzu.<br />";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Kiedy dodajesz nowego członka rodziny, PhpGedView może automatycznie uzupełnić nazwiska według lokalnego zwyczaju.<br /><br /><ul><li>W tradycji <b>ojcowskiej</b> wszyscy członkowie rodziny mają nazwisko ojca.</li><li>W tradycji <b>hiszpańskiej</b> i <b>portugalskiej</b> dzieci przyjmują nazwiska obojga rodziców.</li><li>W tradycji <b>islandzkiej</b> dzieci przyjmują jako nazwisko imię ojca z przyrostkiem odpowiednim do płci dziecka.</li></ul><br />";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />To jest rozdzielana przecinkami lista znaczników faktów GEDCOM, które nie będą widoczne na formularzu dodawania i edycji imion/nazwisk. Jeśli korzystasz z nie-łacińskiego alfabetu, jak na przykład hebrajski, grecki, arabski, czy cyrylica, możesz dodać takie znaczniki jak _HEB, ROMN, FONE, itd. aby móc przechowywać imiona i nazwiska w kilku różnych alfabetach.<br />";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />To jest rozdzielana przecinkami lista znaczników faktów GEDCOM, które będą widoczne podczas dodawania i edycji miejsc. If you use non-Latin alphabets such as Hebrew, Greek, Cyrillic or Arabic, you may want to add tags such as _HEB, ROMN, FONE, etc. to allow you to store place names in several different alphabets.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatycznie wygenerowane miniaturki";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Czy system powinien automatycznie wygenerować miniaturki dla obrazów, które ich nie mają. Twoja instalacja PHP może nie obsługiwać tej funkcji.<br />";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Ta strona wyświetla szczegółowe informacje na temat serwera, na którym zainstalowany jest PhpGedView. Można tu zobaczyć wiele szczegółów konfiguracyjnych na temat oprogramowania serwera, które są istotne dla PHP oraz PhpGedView.<br />";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Ta strona zbiera w jednym miejscu wszystkie główne tematy pomocy konfiguracyjnej. Możesz przeglądać te informacje, a także wydrukować je i zachować na później.<br />";
$pgv_lang["more_config_hjaelp"]			= "<br /><b>Dodatkowa pomoc</b><br />Dodatkowa pomoc jest dostępna po kliknięciu na znak zapytania <b>?</b> obok niektórych elementów na stronie.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Szerokość generowanych miniaturek";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />To jest szerokość (w pikselach), którą system zastosuje podczas automatycznego generowania miniaturek. Domyślna wartość to 100.<br />";
?>
