--TEST--
MongoClient::setReadPreference() should set read preference mode
--SKIPIF--
<?php require_once dirname(__FILE__) ."/skipif.inc"; ?>
--FILE--
<?php require_once dirname(__FILE__) . "/../utils.inc"; ?>
<?php

$modes = array(
    Mongo::RP_PRIMARY,
    Mongo::RP_PRIMARY_PREFERRED,
    Mongo::RP_SECONDARY,
    Mongo::RP_SECONDARY_PREFERRED,
    Mongo::RP_NEAREST
);

foreach (array_values($modes) as $mode) {
    $m = new_mongo(null, true, true, array('readPreference' => $mode));
    echo $mode, "\n\n";
    foreach (array_values($modes) as $newMode) {
        $m->setReadPreference($newMode);
        $rp = $m->getReadPreference();
        echo $rp["type"], "\n";
    }
    echo "---\n";
}
?>
--EXPECT--
primary

primary
primaryPreferred
secondary
secondaryPreferred
nearest
---
primaryPreferred

primary
primaryPreferred
secondary
secondaryPreferred
nearest
---
secondary

primary
primaryPreferred
secondary
secondaryPreferred
nearest
---
secondaryPreferred

primary
primaryPreferred
secondary
secondaryPreferred
nearest
---
nearest

primary
primaryPreferred
secondary
secondaryPreferred
nearest
---
