<?php
/**
 * This file provides defaults for backends people use to change their
 * passwords.
 *
 * IMPORTANT: DO NOT EDIT THIS FILE!
 * Local overrides MUST be placed in backends.local.php or backends.d/.
 * If the 'vhosts' setting has been enabled in Horde's configuration, you can
 * use backends-servername.php.
 *
 * There are a number of properties that you can set for each backend:
 *
 * name: This is the plaintext, english name that you want displayed to people
 *       if you are using the drop down server list.  Also displayed on the
 *       main page (input form).
 *
 * policy: The password policies for this backend. You are responsible for the
 *         sanity checks of these options. Options are:
 *
 *         minLength:   Minimum length of the password
 *         maxLength:   Maximum length of the password
 *         maxSpace:    Maximum number of white space characters
 *
 *         The following are the types of characters required in a password.
 *         Either specific characters, character classes, or both can be
 *         required.  Specific types are:
 *
 *         minUpper:    Minimum number of uppercase characters
 *         minLower:    Minimum number of lowercase characters
 *         minNumeric:  Minimum number of numeric characters (0-9)
 *         minAlphaNum: Minimum number of alphanumeric characters
 *         minAlpha:    Minimum number of alphabetic characters
 *         minSymbol:   Minimum number of alphabetic characters
 *
 *         Alternatively (or in addition to), the minimum number of character
 *         classes can be configured by setting the following.  The valid range
 *         is 0 through 4 character classes may be required for a password. The
 *         classes are: 'upper', 'lower', 'number', and 'symbol'.  For example:
 *         A password of 'p@ssw0rd' satisfies three classes ('number', 'lower',
 *         and 'symbol'), while 'passw0rd' only satisfies two classes ('lower'
 *         and 'symbols').
 *
 *         minClasses: Minimum number (0 through 4) of character classes.
 *
 * driver: The Passwd driver used to change the password. Valid values are
 *         currently:
 *
 *              horde:      Change the password via the configured horde
 *                          authentication driver
 *              ldap:       Change the password on a ldap server
 *              smbldap:    Change the password on a ldap server for both
 *                          ldap and samba auth
 *              sql:        Change the password for sql authentication
 *                          (exim, pam_mysql, horde)
 *              poppassd:   Change the password via a poppassd server
 *              smbpasswd:  Change the password via the smbpasswd command
 *              expect:     Change the password via an expect script
 *              vmailmgr:   Change the password via a local vmailmgr daemon
 *              vpopmail:   Change the password for sql based vpopmail
 *              servuftp:   Change the password via a servuftp server
 *              pine:       Change the password in a Pine-encoded file
 *              composite:  Allows you to chain multiple drivers together
 *
 * no_reset: Do not reset the authenticated user's credentials on success.
 *
 * params: A params array containing any additional information that the Passwd
 *         driver needs.
 *
 *         The following is a list of supported encryption/hashing methods
 *         supported by Passwd.
 *
 *         1) plain
 *         2) aprmd5
 *         3) crypt or crypt-des
 *         4) crypt-blowfish
 *         5) crypt-md5
 *         6) crypt-sha256
 *         7) crypt-sha512
 *         8) md5-base64
 *         9) md5-hex
 *        10) msad
 *        11) sha or sha1
 *        12) sha256 or ssha256
 *        13) smd5
 *        14) ssha
 *
 *         md5 passwords have caused some problems in the past because there
 *         are different definitions of what is a "md5 password".  Systems
 *         implement them in a different manner.  If you are using OpenLDAP as
 *         your backend or have migrated your passwords from your OS based
 *         passwd file, you will need to use the md5-base64 hashing method.  If
 *         you are using a SQL database or used the PHP md5() method to create
 *         your passwords, you will need to use the md5-hex hashing method.
 *
 * preferred: This is only useful if you want to use the same backend.php file
 *            for different machines: if the Hostname of the Passwd Machine is
 *            identical to one of those in the preferred list, then the
 *            corresponding option in the select box will include SELECTED,
 *            i.e. it is selected per default. Otherwise the first entry in the
 *            list is selected.
 *
 * show_encryption: If you are using the ldap, sql or vpopmail backends you
 *                  have the choice whether or not to store the encryption type
 *                  with the password. If you are using for example an SQL
 *                  based PAM you will most likely not want to store the
 *                  encryption type as it would cause PAM to never match the
 *                  passwords.
 */

$backends['hordeauth'] = array (
    'disabled' => true,
    'name' => 'Horde Authentication',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Horde',
);

$backends['hordesql'] = array (
    'disabled' => false,
    'name' => 'Horde SQL Authentication',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Sql',
    'params' => array_merge(
        $GLOBALS['conf']['sql'],
        array('table' => 'horde_users',
              'user_col' => 'user_uid',
              'pass_col' => 'user_pass',
              'show_encryption' => false,
              'encryption' => $GLOBALS['conf']['auth']['params']['encryption'])
    ),
);

$backends['poppassd'] = array(
    'disabled' => true,
    'name' => 'Poppassd Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Poppassd',
    'params' => array(
        'host' => 'localhost',
        'port' => 106
    ),
);

$backends['servuftp'] = array(
    'disabled' => true,
    'name' => 'Serv-U FTP Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Servuftp',
    'params' => array(
        'host' => 'localhost',
        'port' => 106,
        'timeout' => 30
    ),
);

$backends['expect'] = array(
    'disabled' => true,
    'name' => 'Expect Script',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Expect',
    'params' => array(
        'program' => '/usr/bin/expect',
        'script' => PASSWD_BASE . '/scripts/passwd-expect',
        'params' => '-telnet -host localhost -output /tmp/passwd.log'
    ),
);

$backends['sudo_expect'] = array(
    'disabled' => true,
    'name' => 'Expect with Sudo Script',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Procopen',
    'params' => array(
        'program' => '/usr/bin/expect '
            . PASSWD_BASE . '/scripts/passwd_expect -sudo'
    ),
);

$backends['smbpasswd'] = array(
    'disabled' => true,
    'name' => 'Samba Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Smbpasswd',
    'params' => array(
        'program' => '/usr/bin/smbpasswd',
        'host' => 'localhost'
    ),
);

// NOTE: to set the ldap userdn, see horde/config/hooks.php
$backends['ldap'] = array(
    'disabled' => true,
    'name' => 'LDAP Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Ldap',
    'params' => array(
        'host' => 'localhost',
        'port' => 389,
        'basedn' => 'o=example.com',
        // LDAP object key attribute.
        'uid' => 'uid',
        // The attribute storing the password.
        'attribute' => 'userPassword',
        // These attributes will enable shadow password policies.
        // 'shadowlastchange' => 'shadowLastChange',
        // 'shadowmin' => 'shadowMin',
        // This will be appended to the username when looking for the userdn.
        'realm' => '',
        // Use this filter when searching for the user's DN.
        'filter' => '',
        // Hash method to use when storing the password
        'encryption' => 'crypt',
        // Whether to enable TLS for this LDAP connection
        // Note: make sure that the host matches cn in the server certificate.
        'tls' => false
    ),
);

// NOTE: to set the ldap userdn, see horde/config/hooks.php
$backends['ldapadmin'] = array(
    'disabled' => true,
    'name' => 'LDAP Server with Admin Bindings',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Ldap',
    'params' => array(
        'host' => 'localhost',
        'port' => 389,
        'basedn' => 'o=example.com',
        'admindn' => 'cn=admin,o=example.com',
        'adminpw' => 'somepassword',
        // LDAP object key attribute.
        'uid' => 'uid',
        // The attribute storing the password.
        'attribute' => 'userPassword',
        // These attributes will enable shadow password policies.
        // 'shadowlastchange' => 'shadowLastChange',
        // 'shadowmin' => 'shadowMin',
        // This will be appended to the username when looking for the userdn.
        'realm' => '',
        // Use this filter when searching for the user's DN.
        'filter' => '',
        // Hash method to use when storing the password
        'encryption' => 'crypt',
        // If set, should be 0 or 1. See the LDAP documentation about the
        // corresponding parameter REFERRALS.
        // Windows 2003 Server require to set this parameter to 0
        // 'referrals' => 0,
        // Whether to enable TLS for this LDAP connection
        // Note: make sure that the host matches cn in the server certificate.
        'tls' => false
    ),
);

// NOTE: to set the ldap userdn, see horde/config/hooks.php
// NOTE: to make work with samba 2.x schema you must change lm_attribute and
// nt_attribute
$backends['smbldap'] = array(
    'disabled' => true,
    'name' => 'Samba/LDAP Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Smbldap',
    'params' => array(
        'host' => 'localhost',
        'port' => 389,
        'basedn' => 'o=example.com',
        // LDAP object key attribute.
        'uid' => 'uid',
        // The attribute storing the password.
        'attribute' => 'userPassword',
        // This will be appended to the username when looking for the userdn.
        'realm' => '',
        // Use this filter when searching for the user's DN.
        'filter' => '',
        // Hash method to use when storing the password
        'encryption' => 'crypt',
        // Whether to enable TLS for this LDAP connection
        // Note: make sure that the host matches cn in the server certificate.
        'tls' => false,
        // If any of the following attributes are commented out, they
        // won't be set on the LDAP server.
        'lm_attribute' => 'sambaLMPassword',
        'nt_attribute' => 'sambaNTPassword',
        'pw_set_attribute' => 'sambaPwdLastSet',
        'pw_expire_attribute' => 'sambaPwdMustChange',
         // The number of days until samba passwords expire. If this
         // is commented out, passwords will never expire.
        'pw_expire_time' => 180,
    ),
);

$backends['sql'] = array (
    'disabled' => true,
    'name' => 'SQL Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Sql',
    'params' => array(
        'phptype' => 'mysql',
        'hostspec' => 'localhost',
        'username' => 'dbuser',
        'password' => 'dbpasswd',
        'encryption' => 'md5-hex',
        'database' => 'db',
        'table' => 'users',
        'user_col' => 'user_uid',
        'pass_col' => 'user_pass',
        'show_encryption' => false
        // The following two settings allow you to specify custom queries for
        // lookup and modify functions if special functions need to be
        // performed.  In places where a username or a password needs to be
        // used, refer to this placeholder reference:
        //    %d -> gets substituted with the domain
        //    %u -> gets substituted with the user
        //    %U -> gets substituted with the user without a domain part
        //    %p -> gets substituted with the plaintext password
        //    %e -> gets substituted with the encrypted password
        //
        // 'query_lookup' => 'SELECT user_pass FROM horde_users WHERE user_uid = %u',
        // 'query_modify' => 'UPDATE horde_users SET user_pass = %e WHERE user_uid = %u',
    ),
);

$backends['mailmgr'] = array(
    'disabled' => true,
    'name' => 'VMailMgr Server',
    'preferred' => '',
    'policy' => array(),
    'driver' => 'Vmailmgr',
    'params' => array(
        'vmailinc' => '/your/path/to/the/vmail.inc'
    ),
);

$backends['vpopmail'] = array (
    'disabled' => true,
    'name' => 'Vpopmail Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Vpopmail',
    'params' => array(
        'phptype' => 'mysql',
        'hostspec' => 'localhost',
        'username' => '',
        'password' => '',
        'encryption' => 'crypt',
        'database' => 'vpopmail',
        'table' => 'vpopmail',
        'name' => 'pw_name',
        'domain' => 'pw_domain',
        'passwd' => 'pw_passwd',
        'clear_passwd' => 'pw_clear_passwd',
        'use_clear_passwd' => true,
        'show_encryption' => true
    ),
);

$backends['pine'] = array(
    'disabled' => true,
    'name' => 'Pine Password File',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Pine',
    'no_reset' => true,
    'params' => array(
        // FTP server information.
        'host' => 'localhost',
        'port' => '21',
        'path' => '',
        'file' => '.pinepw',
        // Connect using the just-passed-in password?
        'use_new_passwd' => false,
        // Host string to look for in the encrypted file.
        'imaphost' => 'localhost'
    ),
);

$backends['kolab'] = array(
    'disabled' => true,
    'name' => 'Local Kolab Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Kolab',
    'params' => array(),
);

$backends['myscript'] = array(
    'disabled' => true,
    'name' => 'Custom Script',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Procopen',
    'params' => array(
        'program' => '/path/to/my/script + myargs'
    ),
);

// This is an example configuration for the http driver.  This allows
// connecting to an arbitrary URL that contains a password change form.
// The params 'username','oldPasswd','passwd1', and 'passwd2' params should be
// set to the name of the respective form input elements on the html form.  If
// there are additional form fields that the form requires, define them in the
// 'fields' array in the form 'formFieldName' => 'formFieldValue'.  The driver
// attempts to determine the success or failure based on searching the returned
// html page for the values listed in the 'eval_results' array.
$backends['http'] = array(
    'disabled' => true,
    'name' => 'HTTP Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Http',
    'params' => array(
        'url' => 'http://www.example.com/psoft/servlet/psoft.hsphere.CP',
        'username' => 'mbox',
        'oldPasswd' => 'old_password',
        'passwd1' => 'password',
        'passwd2' => 'password2',
        'fields' => array(
            'action' => 'change_mbox_password',
            'ftemplate' => 'design/mail_passw.html'
        ),
        'eval_results' => array(
            'success' => 'Password successfully changed',
            'badPass' => 'Bad old password',
            'badUser' => 'Mailbox not found'
        ),
    ),
);

$backends['soap'] = array(
    'disabled' => true,
    'name' => 'SOAP Server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Soap',
    'params' => array(
        // If this service doesn't have a WSDL, the 'location' and 'uri'
        // parameters below must be specified instead.
        'wsdl' => 'http://www.example.com/service.wsdl',
        'method' => 'changePassword',
        // This is the order of the arguments to the method specified above.
        'arguments' => array('username', 'oldpassword', 'newpassword'),
        // These parameters are directly passed to the SoapClient object, see
        // http://ww.php.net/manual/en/soapclient.soapclient.php for a
        // complete list of possible parameters.
        'soap_params' => array(
            'location' => '',
            'uri' => '',
         ),
    ),
);

// This is an example configuration for Postfix.admin 2.3.
// Set the 'password_policy' section as you wish.
// In most installations you probably only need to change the
// hostspec and/or  password fields.
$backends['postfixadmin'] = array (
    'disabled' => true,
    'name' => 'Postfix Admin server',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'maxLength' => 20,
        'minNumeric' => 1,
    ),
    'driver' => 'Sql',
    'params' => array(
        'phptype' => 'mysql',
        'hostspec' => 'localhost',
        'username' => 'postfix',
        'password' => 'PASSWORD',
        'encryption' => 'crypt-md5',
        'database' => 'postfix',
        'table' => 'mailbox',
        'user_col' => 'username',
        'pass_col' => 'password',
        'show_encryption' => false,
        // The following two settings allow you to specify custom queries for
        // lookup and modify functions if special functions need to be
        // performed.  In places where a username or a password needs to be
        // used, refer to this placeholder reference:
        //    %d -> gets substituted with the domain
        //    %u -> gets substituted with the user
        //    %U -> gets substituted with the user without a domain part
        //    %p -> gets substituted with the plaintext password
        //    %e -> gets substituted with the encrypted password
        //
        'query_lookup' => 'SELECT password FROM mailbox WHERE username = %u and active = 1', 
        'query_modify' => 'UPDATE mailbox SET password = %e WHERE username = %u'
    ),
);

// This is an example configuration for chaining multiple drivers to allow for
// syncing of passwords across many backends using the composite driver as a
// wrapper.
//
// Each of the subdrivers may contain an optional parameter called 'required'
// that, when set to true, will cause the rest of the drivers be skipped if a
// particular one fails.
$backends['composite'] = array(
    'disabled' => true,
    'name' => 'All Services',
    'preferred' => '',
    'policy' => array(
        'minLength' => 6,
        'minNumeric' => 1,
    ),
    'driver' => 'Composite',
    'params' => array('drivers' => array(
        'sql' => array(
            'name' => 'Horde Authentication',
            'driver' => 'Sql',
            'required' => true,
            'params' => array(
                'phptype' => 'mysql',
                'hostspec' => 'localhost',
                'username' => 'horde',
                'password' => '',
                'encryption' => 'md5-hex',
                'database' => 'horde',
                'table' => 'horde_users',
                'user_col' => 'user_uid',
                'pass_col' => 'user_pass',
                'show_encryption' => false
                // 'query_lookup' => '',
                // 'query_modify' => '',
            ),
        ),
        'smbpasswd' => array(
            'name' => 'Samba Server',
            'driver' => 'Smbpasswd',
            'params' => array(
                'program' => '/usr/bin/smbpasswd',
                'host' => 'localhost',
            ),
        ),
    )),
);
