#include <iostream>

#include "effectlist.h"

#include "ppeffect.h"
#include "ppeffect_temperature.h"
#include "ppeffect_desaturate.h"

#include "../config.h"
#include "../gettext.h"
#define _(x) gettext(x)
#define N_(x) gettext_noop(x)

using namespace std;

struct entrysource
{
	const char *name;
	GdkPixbuf *(*geticon)();
	bool (*createeffect)(PPEffectHeader &header);
};

static bool add_temp(PPEffectHeader &header)
{
	cerr << "Creating new PPEffect_Temperature..." << endl;
	cerr << "Before adding:  " << header.EffectCount(PPEFFECT_PRESCALE) << " effects" << endl;
	bool result=(NULL!=new PPEffect_Temperature(header,PPEFFECT_PRESCALE));
	cerr << "After adding:  " << header.EffectCount(PPEFFECT_PRESCALE) << " effects" << endl;
	return(result);
};

static bool add_desat(PPEffectHeader &header)
{
	cerr << "Creating new PPEffect_Desaturate..." << endl;
	cerr << "Before adding:  " << header.EffectCount(PPEFFECT_PRESCALE) << " effects" << endl;
	bool result=(NULL!=new PPEffect_Desaturate(header,PPEFFECT_PRESCALE));
	cerr << "After adding:  " << header.EffectCount(PPEFFECT_PRESCALE) << " effects" << endl;
	return(result);
};

static struct entrysource effectlistsources[]=
{
	{"Desaturate",PPEffect_Desaturate::GetIcon_static,add_desat},
	{"Cool/Warm",PPEffect_Temperature::GetIcon_static,add_temp},
};

#define SOURCECOUNT (sizeof(effectlistsources)/sizeof(entrysource))


class AvailableEffectItem : public EffectListItem
{
	public:
	AvailableEffectItem(PPEffectHeader &header,struct entrysource *source) : header(header)
	{
		name=source->name;
		GetIcon_fptr=source->geticon;
		createeffect=source->createeffect;
	}
	virtual ~AvailableEffectItem()
	{
	}
	virtual bool Action()
	{
		return(createeffect(header));
	}
	virtual GdkPixbuf *GetIcon()
	{
		return(GetIcon_fptr());
	}
	virtual void Remove()
	{
	}
	private:
	GdkPixbuf *(*GetIcon_fptr)();
	bool (*createeffect)(PPEffectHeader &header);
	PPEffectHeader &header;
};


AvailableEffectSource::AvailableEffectSource(PPEffectHeader &header)
	: header(header)
{
}


AvailableEffectSource::~AvailableEffectSource()
{
}


int AvailableEffectSource::EffectCount()
{
	return(SOURCECOUNT);
}


EffectListItem *AvailableEffectSource::GetEffect(int item)
{
	if((item>=0) && (item<SOURCECOUNT))
		return(new AvailableEffectItem(header,&effectlistsources[item]));
	else
		return(NULL);	
}



class CurrentEffectItem : public EffectListItem
{
	public:
	CurrentEffectItem(PPEffect *effect,const char *name,GdkPixbuf *preview)
		: EffectListItem(), effect(effect), preview(preview)
	{
		this->name=name;
	}
	virtual ~CurrentEffectItem()
	{
	}
	virtual bool Action()
	{
		return(effect ? effect->Dialog(NULL,preview) : false);
	}
	virtual void Remove()
	{
		if(effect)
			delete effect;
		effect=NULL;
	}
	virtual GdkPixbuf *GetIcon()
	{
		return(effect ? effect->GetIcon() : NULL);
	}
	private:
	PPEffect *effect;
	GdkPixbuf *preview;
};


CurrentEffectSource::CurrentEffectSource(PPEffectHeader &header,GdkPixbuf *preview)
	: header(header), preview(preview)
{
}

CurrentEffectSource::~CurrentEffectSource()
{
}

int CurrentEffectSource::EffectCount()
{
	return(header.EffectCount(PPEFFECT_PRESCALE));
}


EffectListItem *CurrentEffectSource::GetEffect(int item)
{
	EffectListItem *result=NULL;
	PPEffect *effect=header.GetFirstEffect(PPEFFECT_PRESCALE);
	while(effect && item)
	{
		--item;
		effect=effect->Next(PPEFFECT_PRESCALE);	
	}
	if(effect)
	{
		result=new CurrentEffectItem(effect,"<unknown>",preview);
	}
	return(result);
}
