# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from core.translation import _t,new

#---PIL
def init():
    global Image, ImageOps
    import Image, ImageOps
    
def border(image, size=1, colour=0):
    """Adjust brightness from black to white
    - size: -1(black) 0 (unchanged) 1(white)
    - repeat: how many times it should be repeated"""
    if size == 0:
        return image
    if size < 0:
        #crop
        image = ImageOps.crop(image,border=-size)
    else:
        #expand
        image = ImageOps.expand(image,border=size,fill=colour)
    return image

#---Phatch
class Action(models.Action):
    label       = _t('Border')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(border)
    version     = '0.1'
    tags        = [_t('size'),_t('border')]
    update_size = True
    __doc__     = _t('Crop or add border to all sides')
    
    def interface(self,fields):
        fields[_t('Size')]   = self.PixelField('1px',choices=['1','2','5'])
        fields[_t('Colour')] = self.ColourField('#000000')
        
    def values(self,info):
        #pixel fields
        x0, y0      = info[new('Pil','Size')]
        return super(Action,self).values(info,pixel_fields={'Size':(x0+y0)/2})
        
    icon = \
'x\xda\x01\xe5\x03\x1a\xfc\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\
\x00\x00\x000\x08\x02\x00\x00\x00\xd8`n\xd0\x00\x00\x00\x03sBIT\x08\x08\x08\
\xdb\xe1O\xe0\x00\x00\x03\x9dIDATX\x85\xcd\x99\xcdn\xdbF\x10\xc7\xe7\xff\x9f\
\xa1$H\x01\x9c(u\xd2\xa0@\x80\xdej$\xe7 \x97\x9c\xfc\x16\xc9[\xf4\x01\xfa\
\x0cM\x91Co}\x92<K\x8e\x8de\xd7\xb2\xab\xda!)\x91\xdb\xc3R\xd4\xf2Kv\x0cS\
\xf2\x9c\xc8\xdd\xd5\xf2\xb7\xf3\xb5\xb3+\x1c\x1f\x1f\xcbC\x12\x03\xb0o\x86\
\x8ap\xdf\x00uyp\x1a2r\xa3\xa44M\xe7\xf3y\xd8\r\xc09\x17\x8e\t\xa5\xab=\xecj\
]0\xc9<\xcf\xfd\x98\xc9d\xa2\xaa\x1b\xa0p\\\x9e\xe7WWW\xcd\xcf\x00\xa8\xcdK\
\xb2\xf9\xa5\xb0\xa5|\xae\xcd\xd6\x9c|<\x1e\x87\xaf\x16\xd2\x91$\xf9\xeb\xdb\
\xb7\xbf|\xfe\xdc\\\x96t,wK\xfb\xf6\xae\x0f"\x87\x87\x87\x00:5\xe4e\x98\xa6\
\x07\'\xb3\xc1\xcb\x97O>\xbc\xb7\x17/\xba\xa6\xfb^\xe1x\x8c(\x92,K\xbe|9\xfd\
\xfdc\xbeX\xe4?>o\x0e\xab\xf8\x90_\r@\x9a\xfd\xf4\xc7\xc7\xd1\xabW\xf7E\x13\
\xca\xe4\xdd;\xb7\xf8\xef\xec\xd3\'\xff9o\x96\rP\x8bJI\xfb\xe1\xd9\xe8\xf5\
\xeb>h\xbc\x8c\xdf\xbc\x81\r\xd6\xeb\xaf8h\xc5d\x9e\x14\x80=\x9d\xcar\xd5\
\x1f\x90\x1e\x1c\xd0\x0c@\xd3\xc7+N\xediHr8\xca\xe3o\xfd\x01\xc1\x0cf^7\xaaz\
\x83S\x83*\xa0\xbb\x8e\xfb\x03\xca\xe3\x18\x1a\xb5\xa6\xb1\x8aS\xab*\x00!\
\x01\xba\xb8G \x97\xa4^Cr\x1b\xa7\x06\x00\xf6\r\x94\xd0"\x91\xdc\'\xd8\x8aS\
\x87/\x1e\x16\xaa \xf3$\xe9\x0fH\n\r-\xcb@k\x07Z\xebPI\x93\xb8G \xb7\\\xd2\
\x06t\x994v\xa1\xbaS\x03\x10BH\xd7+P\x9c\xc0\x0c+4w\xc9\xfa^&"\xa4J\xee\\\
\x9a\xf6\x08tu\r\x8b\x90\x15y\xa8\x12\xf6M\x93\x81\x8aU\xe6\x92>\x81\xae\xbf\
\xd1\x0c\xa9\x8f\x9f\x9bL\x06@V\x99[,0\x1c\xf6\x04\x94_\xfc\x0b-\x12c-\x1b\
\x99\xd9\x86\xc9\xab\x0e\xaa\xb0(\x9b\xfd\xa3\xcf\x0e{\x03\xba\x84Ee\x88\x85\
\x0cu\r\x91\xf4C\xb2\xd9\xa9>y\xdc\x17\xd0\xf9\x1cf\xb5\x94X\x00\xb5\x84\xbd\
*m\xe0\xce\xe6\xf2\xf3Jz\xa8\xb8]\x92\xc8uB\x1b\xb4\x96\xb9\xf5z\x08\x00\xa9\
0\x93\xdce\'\xa7\xfatz\xef@\xd9\xd7\x19\xccd\x9d\x81\xcc\xacs\xeb(:\x00Z$"\
\xee\xe4L\x1e=\x92\xeeJ\xfeN8\x99;\xbf\xf4\xf3KP\xf0l\x80\xc2\xc1\x85\x86T\
\xfd\n\xc4\xb9\xec\xebL\x9f\xdf\xa7kg\x7f\xcf\x00\x88\x99t\x94\xdbVs+O\x84\
\xf5\n$N\xf3\xd3s>>\xb8\x07gr.\xbf\xb8\x94tYN\xee\xd7_7Y\xeb\xa1\x87\x1ah.Y\
\xba\xb3s\x8cF0\x15\xb9\x1b\x96s\xab\xcc\xc51\xb2\x1c\xc1\xcc\xe5V\xdf\xe9C\
\x1e\x96f\x88"\xa9I\xbat\xe9\xf2N4\x85\x80*\xacT\xa7\x1e\xe8\x86L\xed\x07nL\
\xd6\xa7\x90\xac\x15\xd0r+\x93\xf5\t$\xeb*~\x03\xd4b2\xb5\xddh\xa8t\xa0\xce\
\x02\xad\x1c\x04\xdb\x85\x86\xda\x81B+\x16\xbb\x9d*w\xa8!\xd9R\x0f\xf9\x0e\
\x92\xbb\xd1\x90?\x91\xd5\x8b\xfc\x9a\x9f\x17E\xfe\xae\xa2\xec\x86\x83\xe2:S\
q7&k\xbddj;\x97\x91\xd8I\xd8\x97\x01\xdfY~\x14\xa9s\x87&\x13\x11U\xddvr%\t\
\x92;\x0c\xfbm\'W\xdf\xb7\x8a\xecb\xd2r[\xf8]-\xb7\x19\x16EQK\x945/\x1b~\xfb\
\xeb\xcf\xd0\xb4\xe5\x0f\xc2\x07\t\\\xb2\xd9\x1e\xae\xde9\xd7\xdc\xd2\xfd\
\x87\xfcu\xe76\x93\r\x87\xc3\xe9t\x8a\xe0*8\xfcR8]\xad\xb1|.\x03\xb8\xf5\'\
\x12\xdc\xc2\x967\xc3f\xd5\xed+|\x19\x8f\xc7GGG\xb2W\xa9\'\xc6\xbdKK\xf9\xb1\
_yp\xffu\xfc\x0fZm\xd2\xa0\xbc_\xd8.\x00\x00\x00\x00IEND\xaeB`\x82\xad\x0b\
\xdf\xf9'
