/***************************************************************************
                          txfreqdisplay.cpp  -  description
                             -------------------
    begin                : Mon Oct 11 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>
#include <qpixmap.h>

#include "txfreqdisplay.h"

TxFreqDisplay::TxFreqDisplay ( QWidget *parent=0, const char *name=0 )
             : QWidget( parent, name )
{
  setBackgroundColor( QColor( 50, 60, 60 ) );
  setFrequency( 1000.0 );
}

TxFreqDisplay::~TxFreqDisplay()
{
}

/** Handles paint events */
void TxFreqDisplay::paintEvent( QPaintEvent * e )
{
	QRect    r = e->rect();
	QPixmap  pix( r.size());
	QPainter p;
	QPainter tmp;
	QPen	 pen( QColor( 255, 0, 0 ) );

	pix.fill( this, r.topLeft() );
	
    QFont font( "Fixed", 10, 50, 0 );
    font.setFixedPitch( TRUE );
    font.setStyleHint( (QFont::StyleHint)0 );
    font.setCharSet( (QFont::CharSet)0 );

	tmp.begin( &pix );
	tmp.setPen( pen );
	tmp.setFont( font );
	tmp.drawText( 2, 10, s );
	tmp.end();

	p.begin( this );
	p.drawPixmap( r.topLeft(), pix );
	p.end();
}

/** Sets the receive frequency display */
void TxFreqDisplay::setFrequency( float f )
{
  	if ( f < 999.95 )
  	{
  		s.sprintf( "T  %.1f Hz", f );
	}
	else
	{
	 	s.sprintf( "T %.1f Hz", f );
	}
	repaint( FALSE );	
}








