/***************************************************************************
                          myqlineedit.cpp  -  description
                             -------------------
    begin                : Sun Nov 28 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qkeycode.h>
#include "myqlineedit.h"

MyQLineEdit::MyQLineEdit( QWidget *parent, const char *name )
    : QLineEdit( parent, name )
{
}

MyQLineEdit::~MyQLineEdit(){
}

void MyQLineEdit::keyPressEvent( QKeyEvent *e )
{
    char c[2];

    if ( e->key() == Key_Enter || e->key() == Key_Return ) {
        emit returnPressed();
        e->ignore();
        return;
    }
    if ( e->ascii() >= 32 &&
         e->key() != Key_Delete &&
         e->key() != Key_Backspace )
    {
        //QString t( 2 );
        //t[0] = e->ascii();
        //t[1] = '\0';
        c[0] = e->ascii();
        c[1] = '\0';
        QString t( c );
        insert( t );
        emit keyPressed( c[0] );
        return;
    }
    int unknown = 0;

    //QString s( 2 );

    switch ( e->key() )
    {
    case Key_Backspace:
    case Key_Delete:
        QLineEdit::keyPressEvent( e );
        emit backSpacePressed();
        char c1[2];
        c1[0] = 0x08;
        c1[1] = '\0';
        //s[0] = 0x08;
        //s[1] = '\0';
        //insert( t );
        emit keyPressed( c1[0] );
        break;
    case 0x45: // CTRL_E
        emit CTRL_E_Pressed( 0 );
        break;
    case 0x52: // CTRL_R
        emit CTRL_R_Pressed();
        break;
    case 0x54: // CTRL_T
        emit CTRL_T_Pressed( 1 );
        break;
    default:
        //printf("0x%02x\n", e->key());
        unknown++;
    }

    if ( unknown ) {                            // unknown key
        e->ignore();
        return;
    }
}
