//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: pgTextSearchConfiguration.h 8187 2010-02-25 21:54:35Z dpage $
// Copyright (C) 2002 - 2010, The pgAdmin Development Team
// This software is released under the PostgreSQL Licence
//
// pgTextSearchConfiguration.h PostgreSQL Text Search Configuration
//
//////////////////////////////////////////////////////////////////////////

#ifndef PG_TSCONFIGURATION_H
#define PG_TSCONFIGURATION_H


#include "pgSchema.h"


class pgTextSearchConfigurationFactory : public pgSchemaObjFactory
{
public:
    pgTextSearchConfigurationFactory();
    virtual dlgProperty *CreateDialog(frmMain *frame, pgObject *node, pgObject *parent);
    virtual pgObject *CreateObjects(pgCollection *obj, ctlTree *browser, const wxString &restr=wxEmptyString);
};
extern pgTextSearchConfigurationFactory textSearchConfigurationFactory;

class pgTextSearchConfiguration : public pgSchemaObject
{
public:
    pgTextSearchConfiguration(pgSchema *newSchema, const wxString& newName = wxT(""));
    ~pgTextSearchConfiguration();

    void ShowTreeDetail(ctlTree *browser, frmMain *form=0, ctlListView *properties=0, ctlSQLBox *sqlPane=0);
    virtual wxString GetQuotedIdentifier() const { return GetName(); }
    bool CanDropCascaded() { return GetSchema()->GetMetaType() != PGM_CATALOG; }

    wxString GetParser() const { return parser; }
    void iSetParser(const wxString& s) { parser=s; }
    wxString GetCopy() const { return copy; }
    void iSetCopy(const wxString& s) { copy=s; }
    OID GetParserOid() const { return parserOid; }
    void iSetParserOid(const OID o) { parserOid=o; }
    wxString GetParserOidStr() const {return NumToStr(GetParserOid()) + wxT("::oid"); }
    wxArrayString& GetTokens() { return tokens; }

    bool DropObject(wxFrame *frame, ctlTree *browser, bool cascaded);
    wxString GetSql(ctlTree *browser);
    pgObject *Refresh(ctlTree *browser, const wxTreeItemId item);

    bool HasStats() { return false; }
    bool HasDepends() { return true; }
    bool HasReferences() { return true; }

private:
    wxString parser, copy;
    OID parserOid;
    wxArrayString tokens;
};

#endif
