/* $Id$ */

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 3 && \
     PETSC_VERSION_RELEASE  == 1)

/* Vec */
static SWIGUNUSED
PetscErrorCode VecSetOption_233(Vec x,VecOption op,PetscTruth flag) {
  if (op==VEC_IGNORE_OFF_PROC_ENTRIES && flag==PETSC_FALSE) 
    op = VEC_TREAT_OFF_PROC_ENTRIES;
  else if (op==VEC_IGNORE_NEGATIVE_INDICES && flag==PETSC_FALSE)
    op = VEC_TREAT_NEGATIVE_INDICES;
  return VecSetOption(x,op);
}
#define VecSetOption(x,o,f) VecSetOption_233(x,o,f)

/* Mat */
#define MatIsHermitian(A,tol,flg) MatIsHermitian(A,flg)

#define MAT_NEW_NONZERO_LOCATIONS MAT_YES_NEW_NONZERO_LOCATIONS
#define MAT_NEW_DIAGONALS         MAT_YES_NEW_DIAGONALS
static SWIGUNUSED
PetscErrorCode MatSetOption_233(Mat A,MatOption op,PetscTruth flag) {
#define MAT_OPTION_INVALID ((MatOption)(-1))
  MatOption o = MAT_OPTION_INVALID;
  switch (op) {

  case MAT_ROW_ORIENTED:
    o = (flag ? MAT_ROW_ORIENTED : MAT_COLUMN_ORIENTED); break;

  case MAT_NEW_NONZERO_LOCATIONS:
    o = (flag ? MAT_YES_NEW_NONZERO_LOCATIONS : MAT_NO_NEW_NONZERO_LOCATIONS); break;

  case MAT_SYMMETRIC:
    o = (flag ? MAT_SYMMETRIC : MAT_NOT_SYMMETRIC); break;

  case MAT_STRUCTURALLY_SYMMETRIC:
    o = (flag ? MAT_STRUCTURALLY_SYMMETRIC : MAT_NOT_STRUCTURALLY_SYMMETRIC); break;

  case MAT_NEW_DIAGONALS:
    o = (flag ? MAT_YES_NEW_DIAGONALS : MAT_NO_NEW_DIAGONALS); break;

  case MAT_IGNORE_OFF_PROC_ENTRIES:
    o = (flag ? MAT_IGNORE_OFF_PROC_ENTRIES : MAT_OPTION_INVALID); break;

  case MAT_NEW_NONZERO_LOCATION_ERR:
    o = (flag ? MAT_NEW_NONZERO_LOCATION_ERR : MAT_OPTION_INVALID); break;

  case MAT_NEW_NONZERO_ALLOCATION_ERR:
    o = (flag ? MAT_NEW_NONZERO_ALLOCATION_ERR : MAT_OPTION_INVALID); break;

  case MAT_USE_HASH_TABLE:
    o = (flag ? MAT_USE_HASH_TABLE : MAT_OPTION_INVALID); break;

  case MAT_KEEP_ZEROED_ROWS:
    o = (flag ? MAT_KEEP_ZEROED_ROWS : MAT_OPTION_INVALID); break;

  case MAT_IGNORE_ZERO_ENTRIES:
    o = (flag ? MAT_IGNORE_ZERO_ENTRIES : MAT_OPTION_INVALID); break;

  case MAT_USE_INODES: 
    o = (flag ? MAT_USE_INODES : MAT_DO_NOT_USE_INODES); break;
    
  case MAT_HERMITIAN:
    o = (flag ? MAT_HERMITIAN: MAT_NOT_HERMITIAN); break;

  case MAT_SYMMETRY_ETERNAL:
    o = (flag ? MAT_SYMMETRY_ETERNAL : MAT_NOT_SYMMETRY_ETERNAL); break;
    
  case MAT_USE_COMPRESSEDROW:
    o = (flag ? MAT_USE_COMPRESSEDROW : MAT_DO_NOT_USE_COMPRESSEDROW); break;

  case MAT_IGNORE_LOWER_TRIANGULAR:
    o = (flag ? MAT_IGNORE_LOWER_TRIANGULAR : MAT_OPTION_INVALID); break;
  case MAT_ERROR_LOWER_TRIANGULAR:
    o = (flag ? MAT_ERROR_LOWER_TRIANGULAR : MAT_OPTION_INVALID); break;
  case MAT_GETROW_UPPERTRIANGULAR:
    o = (flag ? MAT_GETROW_UPPERTRIANGULAR : MAT_OPTION_INVALID); break;
  
  default: 
    o = op; break;
  }
  return MatSetOption(A,o);
#undef MAT_OPTION_INVALID
} 

#define MatSetOption(A,o,f) MatSetOption_233(A,o,f)

#endif
%}

/* ---------------------------------------------------------------- */

/*
 * Local Variables:
 * mode: C
 * End:
 */
