/* $Id$ */

/* ---------------------------------------------------------------- */
/* Base Python object for MPI Communicators                         */
/* ---------------------------------------------------------------- */

%header %{
EXTERN_C_BEGIN

typedef struct PyPetscCommObject {
  PyObject_HEAD
  MPI_Comm comm;
} PyPetscCommObject;

#define PyPetscComm(op) \
        ((PyPetscCommObject*)(op))
#define PyPetscComm_OBJ(op) \
        (PyPetscComm(op)->comm)
#define PyPetscComm_VAL(op) \
        (PyPetscComm(op)->comm)
#define PyPetscComm_PTR(op) \
        (&(PyPetscComm(op)->comm))

EXTERN_C_END
%}

/* ---------------------------------------------------------------- */


/* ---------------------------------------------------------------- */
/* Comm C API                                                       */
/* ---------------------------------------------------------------- */

%header %{
/* pointer to Python type object for Comm */
static PyTypeObject* PyComm_Type = NULL;

/* macros to check the type of Comm objects */
#define PyComm_Check(op) \
        PyObject_TypeCheck(op, PyComm_Type)
#define PyComm_CheckExact(op) \
        ((op)->ob_type == PyComm_Type)

/* extact the underlying MPI_comm, no type checking*/
#define PyComm_VAL(op) PyPetscComm_VAL(op)
#define PyComm_PTR(op) PyPetscComm_PTR(op)

%}

#if 0
%{
/* extact the underlying PETSc PETSc_t, does type checking */
static MPI_Comm
PyComm_AsVal(PyObject* op) {
  if(!PyComm_Check(op)) {
    PyErr_SetString(PyExc_TypeError, "expecting a 'Comm' object");
    return MPI_COMM_NULL;
  }
  return PyComm_VAL(op);
}
static MPI_Comm*
PyComm_AsPtr(PyObject* op) {
  if(!PyComm_Check(op)) {
    PyErr_SetString(PyExc_TypeError, "expecting a 'Comm' object");
    return NULL;
  }
  return PyComm_PTR(op);
}
%}
#endif


/* ---------------------------------------------------------------- */


/* ---------------------------------------------------------------- */
/* Factory functions, MPI_Comm -> Python object                   */
/* ---------------------------------------------------------------- */

%header %{
static SWIGUNUSED 
PyObject* PyComm_New(MPI_Comm obj)
{
  PyTypeObject* type;
  PyObject*     self;
  /* check object type */
  if ((type = PyComm_Type) == NULL) {
    PyErr_SetString(PyExc_RuntimeError, 
		    "type object for 'MPI_Comm' not registered");
    return NULL;
  }
  /* allocate a new object */
  self = (PyObject*) type->tp_alloc(type, 0);
  /* fill attributes of allocated object */
  if (self != NULL) PyPetscComm_OBJ(self) = obj;
  /* return new object */
  return self;
}
%}

/* ---------------------------------------------------------------- */



/* ---------------------------------------------------------------- */
/* Type registration                                                */
/* ---------------------------------------------------------------- */

%wrapper %{
static SWIGUNUSED 
PyObject* CommTypeRegister(PyObject* type) {
  if (PyComm_Type == NULL) {
    if (!PyType_Check(type)) {
      PyErr_SetString(PyExc_RuntimeError, "expecting a type object");
      return NULL;
    }
    PyComm_Type = (PyTypeObject*) type;
  } else {
    PyErr_SetString(PyExc_RuntimeError, "type already registered");
    return NULL;
  }
  Py_RETURN_NONE;
}
%}

static PyObject* CommTypeRegister(PyObject* type);

/* ---------------------------------------------------------------- */


/*
 * Local Variables:
 * mode: C
 * End:
 */
