#include "petsc.h"
#include "petscfix.h"
/* schurm.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscmat.h"
#include "petscksp.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcreateschurcomplement_ MATCREATESCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcreateschurcomplement_ matcreateschurcomplement
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matschurcomplementgetksp_ MATSCHURCOMPLEMENTGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matschurcomplementgetksp_ matschurcomplementgetksp
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matschurcomplementupdate_ MATSCHURCOMPLEMENTUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matschurcomplementupdate_ matschurcomplementupdate
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   matcreateschurcomplement_(Mat A,Mat B,Mat C,Mat D,Mat *N, int *__ierr ){
*__ierr = MatCreateSchurComplement(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),
	(Mat)PetscToPointer((C) ),
	(Mat)PetscToPointer((D) ),N);
}
void PETSC_STDCALL   matschurcomplementgetksp_(Mat A,KSP *ksp, int *__ierr ){
*__ierr = MatSchurComplementGetKSP(
	(Mat)PetscToPointer((A) ),ksp);
}
void PETSC_STDCALL   matschurcomplementupdate_(Mat N,Mat A,Mat B,Mat C,Mat D,MatStructure *str, int *__ierr ){
*__ierr = MatSchurComplementUpdate(
	(Mat)PetscToPointer((N) ),
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),
	(Mat)PetscToPointer((C) ),
	(Mat)PetscToPointer((D) ),*str);
}
#if defined(__cplusplus)
}
#endif
