(** Wrapper around Perl [Net::Google::Cache] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_Net_Google_Cache.ml,v 1.3 2003/10/16 13:41:07 rich Exp $
  *)

open Perl

let _ = eval "use Net::Google::Cache"

class net_google_cache sv =

object (self)

  method key =
    string_of_sv (call_method sv "key" [])
  method set_key v =
    call_method_void sv "key" [sv_of_string v]
  method url =
    string_of_sv (call_method sv "url" [])
  method set_url v =
    call_method_void sv "url" [sv_of_string v]
  method get =
    let sv = call_method sv "get" [] in
    if sv_is_undef sv then raise Not_found;
    string_of_sv sv

end

(* let new_ = ... *)
