(** Wrapper around Perl [HTTP::Request::Common] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_HTTP_Request_Common.ml,v 1.1 2004/11/22 17:08:36 rich Exp $
  *)

open Perl

open Pl_HTTP_Request

let _ = eval "use HTTP::Request::Common"

let get, head, put =
  let dofn fn url headers =
    let args =
      sv_of_string url ::
	List.fold_right (fun (k, v) rest ->
			   sv_of_string k :: sv_of_string v :: rest)
	headers [] in
    new http_request (call ~fn args)
  in
  let get = dofn "GET" in
  let head = dofn "HEAD" in
  let put = dofn "PUT" in
  get, head, put

let post url ?form headers =
  let hv = hv_empty () in
  (match form with
     | None -> ()
     | Some xs -> List.iter (fun (k, v) -> hv_set hv k (sv_of_string v)) xs);
  let args =
    sv_of_string url :: hashref hv ::
      List.fold_right (fun (k, v) rest ->
			 sv_of_string k :: sv_of_string v :: rest)
      headers [] in
  new http_request (call ~fn:"POST" args)
