/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : gatedef.h
 * date    : 2001-06-15
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#ifndef _GATEDEF_H_
#define _GATEDEF_H_


/*-------------------------------*/
/* Constant definitions */
/*-------------------------------*/
/*  Q number define */
#define QUE_VIDEO_ID        0
#define QUE_AUDIO_ID        1
#define QUE_DATA_ID         4

/* Q buffer define */
#define VIDEO_START         0x000000
#define VIDEO_SIZE          0x040000
#define VIDEO_SIZE_256

#define AUDIO_START         0x040000
#define AUDIO_SIZE          0x020000
#define AUDIO_SIZE_128

#define NETINFO_START       0x060000
#define NETINFO_SIZE        0x01F000
#define COMM_START          0x07F000
#define COMM_SIZE           0x001000

#define DATA_START          0x080000
#ifdef QSIZE_128K
  #define DATA_SIZE         0x020000
#else
  #define DATA_SIZE         0x010000
#endif

/* Table ID definition */
#define PAT_TABLEID     0x00
#define PMT_TABLEID     0x02
#define NITA_TABLEID    0x40
#define NITO_TABLEID    0x41
#define SDTA_TABLEID    0x42
#define SDTO_TABLEID    0x46
#define EIT_TABLEID     0x50
#define TDT_TABLEID     0x70

/* Interrupt CallBack status lparam value definition */
#define VXDINT_DMX_FRMR            0x00000001   // 0001
#define VXDINT_DMX_SYNC_DROP       0x00000002   // 0010
#define VXDINT_DMX_SYNC_LOCK       0x00000004   // 0100
#define VXDINT_DEC_NEW_AUDIO       0x00000008   // 1000
#define VXDINT_DEC_NTSCPAL         0x00000010   // 10000

#ifdef MAX_DATA_PID
#define MAX_USER_QNB      (32-(QUE_DATA_ID+MAX_DATA_PID)-1)
#define USER_START        (DATA_START+(DATA_SIZE*MAX_DATA_PID))
#endif


/*-------------------------------*/
/* Enum definitions */
/*-------------------------------*/
typedef enum{
	IO_ReadData,
	IO_WriteData,
	IO_StartDev,
	IO_StopDev
}IO_COMMAND;

typedef enum{
	LNB_POWER_ON,
	LNB_POWER_OFF,
	LNB_22K_ON,
	LNB_22K_OFF,
	LNB_18V_ON,
	LNB_13V_ON,
	LNB_LLC_LOW,
	LNB_LLC_HIGH
}LNB_FUNCTION;

typedef enum{
	PID_OPT_CLEAR,
	PID_OPT_ADD,
	PID_OPT_ACTIVE,
	PID_OPT_ADD_WITH_CW,
	PID_OPT_SET_CW
}DATA_PID_OPT;

typedef enum{
	IPADDR_OPT_CLEAR,
	IPADDR_OPT_ADD,
	IPADDR_OPT_ACTIVE,
	IPADDR_OPT_DEL
}IP_ADDR_OPT;

typedef enum{
	NTSC_mode,
	PAL_mode,
	INVALID_mode
}CORE_videoMode;


#endif // _GATEDEF_H_
