/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : avienv1.c 
 * date    : 2000-03-20
 * modify  : 2001-12-13 by elcomski
 * 
 */   
/* ----------------------------------------------- */
#include <arpa/inet.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "../../share/xptype.h"
#include "../../share/ifdef.h"

#include "avienv.h"


/*----------------------------------------- */
/* Macro definitions */
/*----------------------------------------- */
#define SEC_TRANS "Transponder"
#define SEC_OPTION "Option"
#define SEC_KTUSER "UserInfo"


/*----------------------------------------- */
/* Variable definitions */
/*----------------------------------------- */
extern str_trans_data g_trans_data;
extern str_pid_data g_pid_data;
extern char g_config_file[100];

extern str_ip_data g_sip_data;
extern str_ip_data g_dip_data;



/*----------------------------------------- */
/* Function definitions */
/*----------------------------------------- */
/*
 * Func : InitTransDef
 * Context :
 * 
*/  
void InitTransDef( void )
{
	strcpy(g_trans_data.sat_name,"NoName");
	strcpy(g_trans_data.tp_name,"NoName");

	g_trans_data.down_frequency = 12270.0;
	g_trans_data.symbol_rate = 28.0;
	g_trans_data.en_viterbi = FEC_AUTOMATIC;
	g_trans_data.en_lnb_polar = LNB_POL_VERTICAL;
	g_trans_data.en_lnb_type = LNB_NONE;
	g_trans_data.lnb_power_on_off = ON;

	g_pid_data.count = 0;
	g_pid_data.pid[0] = 0;
	g_dip_data.count = 0;
	g_dip_data.ip[0] = 0;
	g_sip_data.count = 0;
	g_sip_data.ip[0] = 0;
}


/*
 * Func : InitTransInfo
 * Context :
 * 
*/  
void InitTransInfo(char *strdir)
{
	char sbuf[256];
	char sbuf1[256];
	int i,iret;

	sprintf(sbuf,"%s%s",strdir,g_config_file); 
	iret = ef_read_env_file(sbuf);
	if(iret < 0){
		InitTransDef( );
		return;
	}
    
    
    
	ef_get_string(SEC_TRANS,"SatName",g_trans_data.sat_name,"NoName");
	ef_get_string(SEC_TRANS,"Name",g_trans_data.tp_name,"NoName");
	ef_get_double(SEC_TRANS,"Frequency",&g_trans_data.down_frequency,0.0);
	ef_get_double(SEC_TRANS,"Symbol rate",&g_trans_data.symbol_rate,0.0); 
    
	/* Polar */
	ef_get_string(SEC_TRANS,"Polar",sbuf,"HOR");
	if(strcmp(sbuf,"VER") == 0)
	       	g_trans_data.en_lnb_polar = LNB_POL_VERTICAL;
	else 
		g_trans_data.en_lnb_polar = LNB_POL_HORIZONTAL;
	    
	/* Band */
	ef_get_string(SEC_TRANS,"Band",sbuf,"KU");
	if(strcmp(sbuf,"KU") == 0)
	       	g_trans_data.en_lnb_band = BAND_KU;
	else
	       	g_trans_data.en_lnb_band = BAND_C;

	/* 22khz */
	ef_get_string(SEC_TRANS,"22Khz",sbuf,"Off");
	if(strcmp(sbuf,"Off") == 0)
	       	g_trans_data.lnb_22khz_on_off = OFF;
	else
	       	g_trans_data.lnb_22khz_on_off = ON;

	/* Lnbpower */
	ef_get_string(SEC_TRANS,"LnbPower",sbuf,"On");
	if(strcmp(sbuf,"Off") == 0)
	       	g_trans_data.lnb_power_on_off = OFF;
	else
	       	g_trans_data.lnb_power_on_off = ON;
	    
	/* Viterbi */
	ef_get_string(SEC_TRANS,"Viterbi",sbuf,"Auto");
	if(strcmp(sbuf,"1/2") == 0)
	       	g_trans_data.en_viterbi = FEC_INNER_1_2;
	else if(strcmp(sbuf,"2/3") == 0)
	       	g_trans_data.en_viterbi = FEC_INNER_2_3;
	else if(strcmp(sbuf,"3/4") == 0)
	       	g_trans_data.en_viterbi = FEC_INNER_3_4;
	else if(strcmp(sbuf,"5/6") == 0)
	       	g_trans_data.en_viterbi = FEC_INNER_5_6;
	else if(strcmp(sbuf,"7/8") == 0)
	       	g_trans_data.en_viterbi = FEC_INNER_7_8;
	else g_trans_data.en_viterbi = FEC_AUTOMATIC;
    
	/* LnbType */
	ef_get_string(SEC_TRANS,"LnbType",sbuf,"OldName");
	if(strcmp(sbuf,"OldName") == 0){
		ef_get_string(SEC_TRANS,"LNB type",sbuf,"Universal");
	}
	if(strcmp(sbuf,"None") == 0)
	       	g_trans_data.en_lnb_type = LNB_NONE;
	else if(strcmp(sbuf,"9300") == 0)
	       	g_trans_data.en_lnb_type = LNB_9300;
	else if(strcmp(sbuf,"9750") == 0)
	       	g_trans_data.en_lnb_type = LNB_9750;
	else if(strcmp(sbuf,"10000") == 0)
	       	g_trans_data.en_lnb_type = LNB_10000;
	else if(strcmp(sbuf,"10600") == 0)
	       	g_trans_data.en_lnb_type = LNB_10600;
	else if(strcmp(sbuf,"10750") == 0)
	       	g_trans_data.en_lnb_type = LNB_10750;
	else if(strcmp(sbuf,"11300") == 0)
	       	g_trans_data.en_lnb_type = LNB_11300;
	else g_trans_data.en_lnb_type = LNB_UNIVERSAL;
    
	/* DISEqc */
	ef_get_string(SEC_TRANS,"DISEqC",sbuf,"None");
	if(strcmp(sbuf,"Port1") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port1;
	else if(strcmp(sbuf,"Port2") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port2;
	else if(strcmp(sbuf,"Port3") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port3;
	else if(strcmp(sbuf,"Port4") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port4;
	else if(strcmp(sbuf,"Port5") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port5;
	else if(strcmp(sbuf,"Port6") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port6;
	else if(strcmp(sbuf,"Port7") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port7;
	else if(strcmp(sbuf,"Port8") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port8;
	else if(strcmp(sbuf,"Port9") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port9;
	else if(strcmp(sbuf,"Port10") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port10;
	else if(strcmp(sbuf,"Port11") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port11;
	else if(strcmp(sbuf,"Port12") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port12;
	else if(strcmp(sbuf,"Port13") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port13;
	else if(strcmp(sbuf,"Port14") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port14;
	else if(strcmp(sbuf,"Port15") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port15;
	else if(strcmp(sbuf,"Port16") == 0)
	       	g_trans_data.en_diseqc = DISEqC_Port16;
	else g_trans_data.en_diseqc = DISEqC_None;

    	/* AutoPID */
	ef_get_string(SEC_TRANS,"AutoPID",sbuf,"Off");
	if(strcmp(sbuf,"Off") == 0)
	       	g_trans_data.auto_pid = OFF;
	else 
		g_trans_data.auto_pid = ON;    

	/* PID & Count */
	ef_get_int(SEC_TRANS,"Count",(int*)&g_pid_data.count,0);
	for(i=0;i<g_pid_data.count;i++){
		sprintf(sbuf,"PID%d",i);
		ef_get_int(SEC_TRANS,sbuf,(int*)&g_pid_data.pid[i],1892);
	}
    
    	/* Static IP(SIP) */
    	ef_get_int(SEC_OPTION,"SIP Count",(int*)&g_sip_data.count,0);
    	for(i=0;i<g_sip_data.count;i++){
		sprintf(sbuf,"SIP%d",i);
		ef_get_string(SEC_OPTION,sbuf,sbuf1,"0.0.0.0");
	        g_sip_data.ip[i] = ntohl(inet_addr(sbuf1)); 	
    	}
}


/*
 * Func : WriteTransInfo
 * Context :
 * 
*/  
void WriteTransInfo(char *strdir)
{
	char sbuf[256];
	int i;
	struct in_addr inaddr; 
	char *pstr;
    
	ef_set_string(SEC_TRANS,"SatName",g_trans_data.sat_name);
	ef_set_string(SEC_TRANS,"Name",g_trans_data.tp_name);
	ef_set_double(SEC_TRANS,"Frequency",g_trans_data.down_frequency);
	ef_set_double(SEC_TRANS,"Symbol rate",g_trans_data.symbol_rate); 

	if(g_trans_data.en_lnb_polar == LNB_POL_VERTICAL)
		ef_set_string(SEC_TRANS,"Polar","VER");
	else
		ef_set_string(SEC_TRANS,"Polar","HOR");

	if(g_trans_data.en_lnb_band == BAND_KU)
		ef_set_string(SEC_TRANS,"Band","KU");
	else
		ef_set_string(SEC_TRANS,"Band","C");

	if(g_trans_data.lnb_22khz_on_off == OFF)
		ef_set_string(SEC_TRANS,"22Khz","Off");
	else
		ef_set_string(SEC_TRANS,"22Khz","On");

	if(g_trans_data.lnb_power_on_off == OFF)
		ef_set_string(SEC_TRANS,"LnbPower","Off");
	else
		ef_set_string(SEC_TRANS,"LnbPower","On");

	switch(g_trans_data.en_viterbi)
	{
		case FEC_INNER_1_2: strcpy(sbuf,"1/2");break;
		case FEC_INNER_2_3: strcpy(sbuf,"2/3");break;
		case FEC_INNER_3_4: strcpy(sbuf,"3/4");break;
		case FEC_INNER_5_6: strcpy(sbuf,"5/6");break;
		case FEC_INNER_7_8: strcpy(sbuf,"7/8");break;
		case FEC_AUTOMATIC: strcpy(sbuf,"Auto");break;
		default: strcpy(sbuf,"Auto");break;
	}
	ef_set_string(SEC_TRANS,"Viterbi",sbuf);
 
	switch(g_trans_data.en_lnb_type)
	{
		case LNB_NONE:strcpy(sbuf,"None");break;
		case LNB_9300:strcpy(sbuf,"9300");break;
		case LNB_9750:strcpy(sbuf,"9750");break;
		case LNB_10000:strcpy(sbuf,"10000");break;
		case LNB_10600:strcpy(sbuf,"10600");break;
		case LNB_10750:strcpy(sbuf,"10750");break;
		case LNB_11300:strcpy(sbuf,"11300");break;
		case LNB_UNIVERSAL:strcpy(sbuf,"Universal");break;
		default:
		strcpy(sbuf,"None");break;
	} 
	ef_set_string(SEC_TRANS,"LnbType",sbuf);

	switch(g_trans_data.en_diseqc)
	{
		case DISEqC_None:strcpy(sbuf,"None");break;
		case DISEqC_Port1:strcpy(sbuf,"Port1");break;
		case DISEqC_Port2:strcpy(sbuf,"Port2");break;
		case DISEqC_Port3:strcpy(sbuf,"Port3");break;
		case DISEqC_Port4:strcpy(sbuf,"Port4");break;
		case DISEqC_Port5:strcpy(sbuf,"Port5");break;
		case DISEqC_Port6:strcpy(sbuf,"Port6");break;
		case DISEqC_Port7:strcpy(sbuf,"Port7");break;
		case DISEqC_Port8:strcpy(sbuf,"Port8");break;
		case DISEqC_Port9:strcpy(sbuf,"Port9");break;
		case DISEqC_Port10:strcpy(sbuf,"Port10");break;
		case DISEqC_Port11:strcpy(sbuf,"Port11");break;
		case DISEqC_Port12:strcpy(sbuf,"Port12");break;
		case DISEqC_Port13:strcpy(sbuf,"Port13");break;
		case DISEqC_Port14:strcpy(sbuf,"Port14");break;
		case DISEqC_Port15:strcpy(sbuf,"Port15");break;
		case DISEqC_Port16:strcpy(sbuf,"Port16");break;
		default:strcpy(sbuf,"None");break;
	}
	ef_set_string(SEC_TRANS,"DISEqC",sbuf);

    
	if(g_trans_data.auto_pid == OFF)
		ef_set_string(SEC_TRANS,"AutoPID","Off");
	else
		ef_set_string(SEC_TRANS,"AutoPID","On");

	ef_set_int(SEC_TRANS,"Count",g_pid_data.count);
	for(i=0;i<g_pid_data.count;i++){
		sprintf(sbuf,"PID%d",i);
		ef_set_int(SEC_TRANS,sbuf,g_pid_data.pid[i]);
	}
    
    	ef_set_int(SEC_OPTION,"SIP Count",g_sip_data.count);
    	for(i=0;i<g_sip_data.count;i++){
		sprintf(sbuf,"SIP%d",i);
		inaddr.s_addr = g_sip_data.ip[i];
		pstr = inet_ntoa(inaddr);
		ef_set_string(SEC_OPTION,sbuf,pstr);
    	}

	sprintf(sbuf,"%s%s",strdir,g_config_file); 
	ef_save_env_file(sbuf);

}


/*
 * Func : FreeTransInfo
 * Context :
 * 
*/  
void FreeTransInfo( void )
{
	ef_free_env_file( );
}
