/*
*  Program to permit sharing of device between kernel driver and user space
*  example usage:
*  <prog> /proc/bus/usb/001/005 -2
*  to disconnect interface number (not position) 2 from device 5 on HC 1
*
*  to connect,
*  <prog> /proc/bus/usb/001/005 2
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/ioctl.h>
#include <linux/usbdevice_fs.h>

#define EXIT_ERR(err) do {\
	printf("%s\n", strerror(err));\
	printf("Usage :\n");\
	printf("  %s <devnode> [-|+]<interface number>\n\n", argv[0]);\
	printf("  Use negative interface number to disconnect, positive (default) to connect.\n");\
	return -err;\
	} while(0)

#define CONNECT 1
#define DISCONNECT 2

int main( int argc, char *argv[] )
{
  struct usbdevfs_ioctl *connect_ioctl;
  int iface_num, fd, mode;
  char *devnode, **endptr;
  char *modestr, *disconnect = "disconnect", *connect = "connect";

  if (argc != 3)
    EXIT_ERR( EINVAL );

  if (!(endptr = malloc(sizeof(*endptr))))
    EXIT_ERR( ENOMEM );

  if (!(connect_ioctl = malloc(sizeof(*connect_ioctl)))) {
    free(endptr);
    EXIT_ERR( ENOMEM );
  }

  devnode = argv[1];

  mode = CONNECT;
  if ('-' == argv[2][0])
    mode = DISCONNECT;

  errno = 0;
  iface_num = strtol( argv[2], endptr, 10 );
  if (errno)
    EXIT_ERR( errno );

  if (*endptr == argv[2])
    EXIT_ERR( EINVAL );

  free(endptr);

  modestr = mode == DISCONNECT ? disconnect : connect;

  connect_ioctl->ifno = abs( iface_num );
  connect_ioctl->ioctl_code = mode == DISCONNECT ? USBDEVFS_DISCONNECT : USBDEVFS_CONNECT;
  connect_ioctl->data = NULL;

  errno = 0;
  if (0 > (fd = open( devnode, O_RDWR )))
    EXIT_ERR( errno );

  errno = 0;
  if (ioctl( fd, USBDEVFS_IOCTL, connect_ioctl )) {
    fprintf( stderr, "Could not %s interface %d : %s\n", modestr, connect_ioctl->ifno, strerror( errno ) );
    free(connect_ioctl);
    return -errno;
  }

  printf( "%sed interface %d\n", modestr, connect_ioctl->ifno );
  if ( CONNECT == mode )
    printf( "  (Connecting always succeeds)\n" );

  free(connect_ioctl);
  return 0;
}
