/*
 * PDFedit - free program for PDF document manipulation.
 * Copyright (C) 2006, 2007, 2008  PDFedit team: Michal Hocko,
 *                                              Miroslav Jahoda,
 *                                              Jozef Misutka,
 *                                              Martin Petricek
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (in doc/LICENSE.GPL); if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA
 *
 * Project is hosted on http://sourceforge.net/projects/pdfedit
 */
/*
 * =====================================================================================
 *        Filename:  basic_algos.h
 *     Description:
 *         Created:  26/11/2006 17:42:41 PM CET
 *          Author:  jmisutka ()
 * =====================================================================================
 */

#ifndef _BASIC_ALGOS_H_
#define _BASIC_ALGOS_H_


//============================================
namespace _JM_NAMESPACE {
//============================================


//=====================================================================================
// Standard min / max functions
//=====================================================================================

/** Min of four items. */
template<typename T>
inline T min (T a, T b, T c, T d)
	{ return std::min (std::min(a,b), std::min(c,d)); }

/** Max of four items. */
template<typename T>
inline T max (T a, T b, T c, T d)
	{ return std::max (std::max(a,b), std::max(c,d)); }

//============================================
} // namespace _JM_NAMESPACE
//============================================


#endif // _BASIC_ALGOS_H_
