/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 MainWindow
 src/merge_options.hh
 *******************************************/

#ifndef PDF_CHAIN__WINDOW_MERGE_OPTIONS
#define PDF_CHAIN__WINDOW_MERGE_OPTIONS

#include "definings.hh"

/*** Class ***/
class class_window_merge_options : public Gtk::Window{
	
	public:
		
		// Konstruktor / Destruktor
		class_window_merge_options();
		virtual ~class_window_merge_options(){}; // Destruktor Inline
		
		// Routines
		virtual void set_options(Glib::ustring, Glib::ustring, Glib::ustring, Glib::ustring);
		Glib::ustring get_rotation();
		Glib::ustring get_evenodd();
		Glib::ustring get_pages();
		Glib::ustring get_password();
		void clear();
		
	protected:
		
		// Friend Classes
		friend class class_treeview_merge;
		friend class class_window_main;
		
		// Widgets
		Gtk::Table
			table_rotation,
		table_evenodd;
		Gtk::HBox
			hbox_rotation_evenodd,
		hbox_pages,
		hbox_password,
		hbox_button;
		Gtk::VBox
			vbox_options;
		Gtk::Frame 
			frame_rotation,
		frame_evenodd,
		frame_pages,
		frame_password;
		Gtk::Entry
			entry_pages,
		entry_password;
		Gtk::Button
			button_set;
		Gtk::RadioButton
			radiobutton_rotation_0,
		radiobutton_rotation_90,
		radiobutton_rotation_180,
		radiobutton_rotation_270,
		radiobutton_evenodd_all,
		radiobutton_evenodd_even,
		radiobutton_evenodd_odd;
		Gtk::Alignment
			alignment_button;
		
		
		// Radiobutton Groups
		Gtk::RadioButton::Group
			group_radiobutton_rotation,
		group_radiobutton_evenodd;
};

#endif
