/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Tools
 src/fill_form.hh
 *******************************************/

#ifndef PDF_CHAIN__TOOLS_FILL_FORM
#define PDF_CHAIN__TOOLS_FILL_FORM

#include "definings.hh"
#include "dialogs.hh"
#include "filechoosers.hh"

/*** Class ***/
class class_window_tools_fill_form : public Gtk::Window{
	
	public:
		class_window_tools_fill_form();
		virtual ~class_window_tools_fill_form(){}; // Destruktor (inline)
		
		// Routines
		void set_dialogs(class_dialogs*);
		void clear();
		
	protected:
		
		// Windows
		class_dialogs *pt_dialogs;
		
		// Widgets
		Gtk::VBox
			vbox_window;
		
		Gtk::HBox
			hbox_sourcefile,
		hbox_fdffile,
		hbox_dropxfa,
		hbox_flatten,
		hbox_selection,
		hbox_save;
		
		Gtk::Frame
			frame_sourcefile,
		frame_fdffile,
		frame_dropxfa,
		frame_flatten;
		
		Gtk::Entry
			entry_sourcefile,
		entry_fdffile;
		
		Gtk::Button
			button_sourcefile,
		button_fdffile,
		button_save;
		
		Gtk::RadioButton
			radiobutton_dropxfa,
		radiobutton_notdropxfa,
		radiobutton_flatten,
		radiobutton_notflatten;
		
		Gtk::Alignment
			alignment_dropxfa,
		alignment_flatten,
		alignment_save;
		
		// Radiobutton Groups
		Gtk::RadioButton::Group
			radiobutton_group_dropxfa,
		radiobutton_group_flatten;
		
		// Signal Handlers
		virtual void on_button_sourcefile();
		virtual void on_button_fdffile();
		virtual void on_button_save();
};

#endif
