/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 MainWindow
 src/background_stamp.cc
 *******************************************/

#include "definings.hh"
#include "mainwindow.hh"

/*** On Button Stamp -> Sourcefile ***/
void class_window_main::on_button_stamp_sourcefile(){
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_OPEN, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename != ""){
		
		entry_stamp_sourcefile.set_text(filename);
		ustring_stamp_sourcefile = get_filename(filename);
		ustring_stamp_pages      = get_ustring_from_unsigned_int(get_pagenumber(filename));
	}
	
	// Push Staus
	push_status(Pdfchain::STAMP);
	return;
}



/*** On Button Stamp -> Background ***/
void class_window_main::on_button_stamp_background(){
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_OPEN, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename != ""){
		
		entry_stamp_background.set_text(filename);
	}
	
	return;
}



/*** Save - Stamp ***/
void class_window_main::save_stamp(){
	
	// Check Errors -> No Source File
	if(entry_stamp_sourcefile.get_text() == ""){
		
		// Error Messages
		dialogs.error_cerr("calss_window_main::save_stamp()",
			Text::err_NO_SOURCE_FILE,
			Text::err_msg_EXIT_FUNCTION);
		
		dialogs.error_message(this, Text::str_BACKGROUND_STAMP, Text::err_NO_SOURCE_FILE);
		return;
	}
	
	// Check Errors -> No Background / Stamp File
	if(entry_stamp_background.get_text() == ""){
		
		// Error Messages
		dialogs.error_cerr("calss_window_main::save_stamp()",
			Text::err_NO_BACKGROUND_STAMP_FILE,
			Text::err_msg_EXIT_FUNCTION);
		
		dialogs.error_message(this, Text::str_BACKGROUND_STAMP, Text::err_NO_BACKGROUND_STAMP_FILE);
		return;
	}
	
	Glib::ustring command;
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_SAVE, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename != ""){
		
		// Create Command
		command += Command::cmd_PDFTK + Command::cmd_SPACE;
		command += quote_out(entry_stamp_sourcefile.get_text()); // Quoting Special Chars of Source File
		
		if(radiobutton_stamp_background.property_active() == true)
			command += Command::cmd_BACKGROUND + Command::cmd_SPACE;
		else if(radiobutton_stamp_stamp.property_active() == true)
			command += Command::cmd_STAMP + Command::cmd_SPACE;
		else{
			command += Command::cmd_BACKGROUND + Command::cmd_SPACE;
			
			// Error Message
			dialogs.error_cerr("class_window_main::save_stamp()",
				Text::err_UNKNOWN_SELECTION_BACKGROUND_STAMP,
				Text::str_BACKGROUND);
		}
		
		command += quote_out(entry_stamp_background.get_text()); // Quoting Special Chars of BG/Stamp File
		command += Command::cmd_OUTPUT + Command::cmd_SPACE;
		command += quote_out(filename);
		command += save_set_rights();
		
		// Execute Command
		execute(this, command);
	}
	
	return;
}
