=head1 NAME

App::Parcimonie::Role::HasEncoding - role to provide an Encode::Encoding objet for the codeset being used

=head1 SYNOPSIS

    use MooseX::Declare;
    class App::Parcimonie::Daemon with App::Parcimonie::Role::HasEncoding {
        method foo (Str $bytes) { $self->encoding-> }
    }

    See App::Parcimonie::Daemon for a real-life usage example.

=cut

package App::Parcimonie::Role::HasEncoding;
use Any::Moose 'Role';

our $VERSION = '0.6'; # VERSION

use namespace::autoclean;
with 'App::Parcimonie::Role::HasCodeset';
use Encode qw{find_encoding};
use Any::Moose '::Util::TypeConstraints';

class_type('Encode::Encoding');
class_type('Encode::XS');

has 'encoding' => (
    isa        => 'Encode::Encoding | Encode::XS',
    is         => 'ro',
    lazy_build => 1,
);

sub _build_encoding {
    my $self = shift;
    find_encoding($self->codeset);
}

no Any::Moose 'Role';
1; # End of App::Parcimonie::Role::HasEncoding
