/*=========================================================================

   Program: ParaView
   Module:    $RCSfile: pqSectionVisibilityContextMenu.h,v $

   Copyright (c) 2005-2008 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2. 

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
#ifndef __pqSectionVisibilityContextMenu_h
#define __pqSectionVisibilityContextMenu_h


// In case of QTableView, or any other spreadsheet-like view, the user
// should be provided an option to toggle the visibility of 
// columns/rows. pqSectionVisibilityContextMenu is a context menu
// that can be used for the same.


#include "QtWidgetsExport.h"
#include <QMenu>
#include <QPointer>
#include <QHeaderView>

class QTWIDGETS_EXPORT pqSectionVisibilityContextMenu : public QMenu
{
  Q_OBJECT
public:
  pqSectionVisibilityContextMenu(QWidget* parent=0);
  virtual ~pqSectionVisibilityContextMenu();

  // Set the QHeaderView whose section visibility is affected by 
  // this menu. This leads to clearing of any actions
  // already present in the menu and populating the menu
  // with the section headings from the header. 
  // This must be set before calling exec(). 
  void setHeaderView(QHeaderView* header);
  QHeaderView* headerView() { return this->HeaderView; }

protected slots:
  void toggleSectionVisibility(QAction* action);

protected:
  QPointer<QHeaderView> HeaderView;

};

#endif

