/*
**  Parser.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_Parser
#define _Pantomime_H_Parser

#import <Foundation/NSData.h>
#import <Foundation/NSObject.h>


@class Part;
@class Message;

@interface Parser: NSObject
{
}

+ (void) parseContentDescription: (NSData *) theLine
                          inPart: (Part *) thePart;

+ (void) parseContentDisposition: (NSData *) theLine
                          inPart: (Part *) thePart;

+ (void) parseContentID: (NSData *) theLine
                 inPart: (Part *) thePart;

+ (void) parseContentTransferEncoding: (NSData *) theLine
                               inPart: (Part *) thePart;

+ (void) parseContentType: (NSData *) theLine
                   inPart: (Part *) thePart;

+ (void) parseDate: (NSData *) theLine
         inMessage: (Message *) theMessage;

+ (void) parseDestination: (NSData *) theLine
                  forType: (int) theType
                inMessage: (Message *) theMessage;

+ (void) parseFrom: (NSData *) theLine
         inMessage: (Message *) theMessage;

+ (void) parseInReplyTo: (NSData *) theLine
              inMessage: (Message *) theMessage;

+ (void) parseMessageID: (NSData *) theLine
              inMessage: (Message *) theMessage;

+ (void) parseMimeVersion: (NSData *) theLine
                inMessage: (Message *) theMessage;

+ (void) parseReferences: (NSData *) theLine
               inMessage: (Message *) theMessage;

+ (void) parseReplyTo: (NSData *) theLine
            inMessage: (Message *) theMessage;

+ (void) parseResentFrom: (NSData *) theLine
               inMessage: (Message *) theMessage;

+ (void) parseStatus: (NSData *) theLine
           inMessage: (Message *) theMessage;

+ (void) parseXStatus: (NSData *) theLine
            inMessage: (Message *) theMessage;

+ (void) parseSubject: (NSData *) theLine
            inMessage: (Message *) theMessage;

+ (void) parseUnknownHeader: (NSData *) theLine
                  inMessage: (Message *) theMessage;

+ (void) parseOrganization: (NSData *) theLine
                 inMessage: (Message *) theMessage;


//
// private methods
//
+ (NSData *) _parameterValueUsingLine: (NSData *) theLine
                                range: (NSRange) theRange;

@end

#endif // _Pantomime_H_Parser
