/*
**  Container.h
**
**  Copyright (c) 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_Container
#define _Pantomime_H_Container

#import <Foundation/NSEnumerator.h>
#import <Foundation/NSObject.h>

@class Message;

@interface Container : NSObject
{
  @public
    Message *message;
    Container *parent, *child, *next;
    BOOL visible;
}

//
//
//
- (id) init;
- (void) dealloc;


//
// access / mutation methods
//
- (void) setParent: (Container *) theParent;
- (void) setChild: (Container *) theChild;
- (Container *) childAtIndex: (int) theIndex;
- (int) count;
- (void) setNext: (Container *) theNext;
- (NSEnumerator *) childrenEnumerator;

@end


//
// Container's sorting category
//
@interface Container (Comparing)

- (int) compareAccordingToNumber: (Container *) aContainer;
- (int) reverseCompareAccordingToNumber: (Container *) aContainer;

- (int) compareAccordingToDate: (Container *) aContainer;
- (int) reverseCompareAccordingToDate: (Container *) aContainer;

- (int) compareAccordingToSender: (Container *) aContainer;
- (int) reverseCompareAccordingToSender: (Container *) aContainer;

- (int) compareAccordingToSubject: (Container *) aContainer;
- (int) reverseCompareAccordingToSubject: (Container *) aContainer;

- (int) compareAccordingToSize: (Container *) aContainer;
- (int) reverseCompareAccordingToSize: (Container *) aContainer;

@end

#endif // _Pantomime_H_Container
