//=======================================================================
// log.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef PACO_LOG_H
#define PACO_LOG_H

#include "options.h"
#include "pkgset.h"
#include <iosfwd>
#include <set>

namespace Paco {

class Info;

class Log
{
	public:

	~Log();
	static void run(Options const&);

	private:

	Log(Options const&);
	Log(Log&);

	Log& operator=(Log&);

	// Private member data
	Options const&			mOpt;
	bool					mAppend;
	std::string				mPkgName;
	std::string				mTmpFile;
	std::set<std::string>	mFiles;
	
	static int const EXIT_FAILURE_EXTERNAL = 2;
	
	void getFilesFromCommand();
	void getFilesFromStream(std::istream&);
	void writeFilesToPkg();
	void writeFilesToStream(std::ostream&);
	void removeAlreadyLoggedFiles();
	void filterFiles();
	void writeFilesToLog(std::string const&);
	void getTmpFile();

	class Excluder
	{
		public:
		
		Excluder(Log const&);
		bool operator()(std::string const& path);

		private:

		std::string const&	mInclude;
		std::string const&	mExclude;
		bool				mLogMissing;
		bool				mIgnoreShared;
		PkgSet				mPkgSet;

		bool isShared(std::string const&);
	};

	friend class Excluder;
	friend class Info;

}; 	// class Log

}	// namespace Paco

#endif  // PACO_LOG_H
