//=======================================================================
// preferences.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "gconfig.h"
#include "preferences.h"
#include "mainwindow.h"
#include <gtkmm/frame.h>
#include <gtkmm/stock.h>	// Gtk::RESPONSE_OK

using namespace Gpaco;

Preferences* Preferences::spPreferences = NULL;


Preferences::Preferences()
:
	Gtk::Dialog("gpaco :: Preferences", *gpMainWindow),
	mButtonColumns(),
	mButtonHour("Show _hour in date", true)
{
	set_position(Gtk::WIN_POS_CENTER_ON_PARENT);
	set_border_width(4);
	set_has_separator();
	set_resizable(false);

	add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
	add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);
	get_action_area()->set_layout(Gtk::BUTTONBOX_EDGE);

	signal_response().connect(sigc::mem_fun(*this, &Preferences::response));
	
	Gtk::VButtonBox* pVisibleColumnsVButtonBoxLeft = Gtk::manage
		(new Gtk::VButtonBox(Gtk::BUTTONBOX_START));
	Gtk::VButtonBox* pVisibleColumnsVButtonBoxRight = Gtk::manage
		(new Gtk::VButtonBox(Gtk::BUTTONBOX_START));
	pVisibleColumnsVButtonBoxRight->set_border_width(4);
	pVisibleColumnsVButtonBoxLeft->set_border_width(4);

	Glib::ustring names[] = { "_Icon", "_Name", "_Size", "Size _missing", "Size _percent",
		"_Date", "_Files", "Files missin_g", "Files per_cent", "Summ_ary" };
	for (int i = 0; i < MainTreeView::N_COLS; ++i) {
		Gtk::CheckButton* pButton = mButtonColumns[i] =
			Gtk::manage(new Gtk::CheckButton(names[i], true));
		pButton->set_active(gpMainWindow->isColumnVisible(i));
		if (i < MainTreeView::N_COLS / 2)
			pVisibleColumnsVButtonBoxLeft->pack_start(*pButton);
		else
			pVisibleColumnsVButtonBoxRight->pack_start(*pButton);
	}

	Gtk::HBox* pHBox = Gtk::manage(new Gtk::HBox());
	pHBox->pack_start(*pVisibleColumnsVButtonBoxLeft);
	pHBox->pack_start(*pVisibleColumnsVButtonBoxRight);
	Gtk::Frame* pVisibleColumnsFrame = Gtk::manage(new Gtk::Frame(" Visible columns "));
	pVisibleColumnsFrame->add(*pHBox);

	get_vbox()->set_spacing(4);
	get_vbox()->pack_start(*pVisibleColumnsFrame);
	get_vbox()->pack_start(mButtonHour);
	
	mButtonHour.set_active(GConfig::hour());
	
	show_all();
}


Preferences::~Preferences()
{
	g_assert(spPreferences != NULL);
}


// [static]
void Preferences::instance()
{
	if (!spPreferences)
		spPreferences = new Preferences();
	spPreferences->present();
}


void Preferences::response(int id)
{
	g_assert(spPreferences != NULL);

	if (id == Gtk::RESPONSE_OK)
		ok();
	
	delete spPreferences;
	spPreferences = NULL;;
}


void Preferences::ok()
{
	for (int j = 0; j < MainTreeView::N_COLS; ++j)
		gpMainWindow->setColumnVisible(j, mButtonColumns[j]->get_active());
	GConfig::hour(mButtonHour.get_active());
	gpMainWindow->treeView().refresh();
}

