//=======================================================================
// find.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_FIND_H
#define GPACO_FIND_H

#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/treeview.h>

namespace Gtk
{
	class FileChooserDialog;
	class ListStore;
}

namespace Gpaco
{

class Pkg;

class Find : public Gtk::Dialog
{
	class PkgsTreeView : public Gtk::TreeView
	{
		friend class Find;

		class ModelColumns : public Gtk::TreeModel::ColumnRecord
		{
			friend class Find;
			friend class Find::PkgsTreeView;
	
			ModelColumns()
			{
				add(mPkg);
				add(mName);
			}

			Gtk::TreeModelColumn<Pkg*>			mPkg;
			Gtk::TreeModelColumn<Glib::ustring>	mName;

		};	// class Find::ModelColumns

		PkgsTreeView();

		ModelColumns                    mColumns;
		Glib::RefPtr<Gtk::ListStore>	mpModel;

		virtual bool on_button_press_event(GdkEventButton*);
		virtual bool on_key_press_event(GdkEventKey*);

		void presentPkgWindow();
	};

	public:

	static void instance();

	private:

	Find();
	~Find();

	Gtk::Entry				mEntry;
	PkgsTreeView			mTreeView;
	Gtk::FileChooserDialog* mpChooserDialog;

	static Find* spFind;

	void browse();
	void find();
	void browseResponse(int id);
	void response(int id);

};

} // namespace Gpaco


#endif  // GPACO_FIND_H

