//=======================================================================
// about.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "about.h"
#include "mainwindow.h"
#include <vector>
#include <glibmm/ustring.h>

using namespace Gpaco;

About* About::spAbout = NULL;


About::About()
:
	Gtk::AboutDialog()
{
	set_transient_for(*gpMainWindow);
	set_position(Gtk::WIN_POS_CENTER_ON_PARENT);

	std::vector<Glib::ustring> authors;
	authors.push_back("David Rosal (" PACKAGE_BUGREPORT ")");

	set_name("gpaco");
	set_version(PACKAGE_VERSION);
	set_comments("GTKMM graphic interface of paco,\nthe source code pacKAGE oRGANIZER");
	set_authors(authors);
	set_copyright("Copyright (C) 2004-2009 David Rosal");
	set_website("http://paco.sourceforge.net");
	set_license("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA");
	set_wrap_license(true);

	signal_response().connect(sigc::mem_fun(*this, &About::kill));
}


About::~About()
{
	g_assert(spAbout != NULL);
}


void About::kill(int)
{
	g_assert(spAbout != NULL);
	delete spAbout;
	spAbout = NULL;
}


// [static]
void About::instance()
{
	if (!spAbout)
		spAbout = new About();
	spAbout->present();
}

