//
// C++ Interface: aptactionplugin
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __NPLUGIN_APTACTIONPLUGIN_H_2005_08_31
#define __NPLUGIN_APTACTIONPLUGIN_H_2005_08_31

#include <qobject.h>
#include <actionplugin.h>

namespace NPlugin {

/** @brief Plugin offerings actions realted to apt.
  *
  * The actions offered are:
  * <ul>
  * 	<li>update database</li>
  * 	<li>reload package database</li>
  * 	<li>install package</li>
  * 	<li>remove package</li>
  * </ul>
  *
  * @author Benjamin Mesing
  */
class AptActionPlugin : public NPlugin::ActionPlugin
{
Q_OBJECT
	const QString _title;
	const QString _briefDescription;
	const QString _description;
	/** @brief Action used to update the apt database. */
	Action* _pAptUpdateAction;
	/** @brief Action used to reload the apt database. */
	Action* _pReloadDbAction;
	Action* _pAptGetLineAction;
	Action* _pAptGetInstallAction;
	Action* _pAptGetRemoveAction;
	Action* _pSeparatorAction;
	IProvider* _pProvider;
protected slots:
	void onAptGetLineAction();
	void onAptGetInstallAction();
	void onAptGetRemoveAction();
protected:
	/** @brief Installs or removes the current package. */
	void aptGetInstallOrRemove(bool install);
public:
	static const QString PLUGIN_NAME;
	AptActionPlugin();
	~AptActionPlugin();
	/** @name Plugin Interface
	  * 
	  * Implementation of the PluginInterface
	  */
	//@{
	virtual void init(IProvider* pProvider);
	/// @todo not yet implemented
	virtual void setEnabled(bool)	{};
	/// @todo not yet implemented
	virtual void setVisible(bool)	{};
	virtual QString name() const { return PLUGIN_NAME; }
	virtual QString title() const { return _title; };
	virtual QString briefDescription() const { return _briefDescription; };
	virtual QString description() const { return _description; };
	//@}
	/** @brief Returns the QAction object for the #_pAptUpdateAction. */
	QAction* qAptUpdateAction() const { return _pAptUpdateAction->action(); }
	/** @brief Returns the QAction object for the #_pReloadDbAction. */
	QAction* qRealoadDbAction() const { return _pReloadDbAction->action(); }

	/** @name ActionPlugin Interface
	  * 
	  * Implementation of the ActionPlugin Interface.
	  */
	//@{
	virtual vector<Action*> actions() const;
	//@}
};

}

#endif	// __NPLUGIN_APTACTIONPLUGIN_H_2005_08_31
