# - Try to find PackageKitQt2
# Once done this will define
#
#  PACKAGEKIT_QT2_FOUND - system has PackageKitQt2
#  PACKAGEKIT_QT2_INCLUDE_DIR - the PackageKitQt2 include directory
#  PACKAGEKIT_QT2_LIB - Link these to use PackageKitQt2
#  PACKAGEKIT_QT2_DEFINITIONS - Compiler switches required for using PackageKitQt2

# Copyright (c) 2008, Adrien Bustany, <madcat@mymadcat.com>
#
# Redistribution and use is allowed according to the terms of the GPLv2+ license.

IF (PACKAGEKIT_QT2_INCLUDE_DIR AND PACKAGEKIT_QT2_LIB)
    SET(PACKAGEKIT_QT2_FIND_QUIETLY TRUE)
ENDIF (PACKAGEKIT_QT2_INCLUDE_DIR AND PACKAGEKIT_QT2_LIB)

FIND_PATH( PACKAGEKIT_QT2_INCLUDE_DIR PackageKit/packagekit-qt2 )

FIND_LIBRARY( PACKAGEKIT_QT2_LIB NAMES packagekit-qt2 )

IF (PACKAGEKIT_QT2_INCLUDE_DIR AND PACKAGEKIT_QT2_LIB)
   SET(PACKAGEKIT_QT2_FOUND TRUE)
ELSE (PACKAGEKIT_QT2_INCLUDE_DIR AND PACKAGEKIT_QT2_LIB)
   SET(PACKAGEKIT_QT2_FOUND FALSE)
ENDIF (PACKAGEKIT_QT2_INCLUDE_DIR AND PACKAGEKIT_QT2_LIB)

SET(PACKAGEKIT_QT2_INCLUDE_DIR ${PACKAGEKIT_QT2_INCLUDE_DIR}/PackageKit/packagekit-qt2)

IF (PACKAGEKIT_QT2_FOUND)
  IF (NOT PACKAGEKIT_QT2_FIND_QUIETLY)
    MESSAGE(STATUS "Found PackageKitQt2: ${PACKAGEKIT_QT2_LIB}")
  ENDIF (NOT PACKAGEKIT_QT2_FIND_QUIETLY)
ELSE (PACKAGEKIT_QT2_FOUND)
  IF (PACKAGEKIT_QT2_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could NOT find PackageKitQt2")
  ENDIF (PACKAGEKIT_QT2_FIND_REQUIRED)
ENDIF (PACKAGEKIT_QT2_FOUND)

MARK_AS_ADVANCED(PACKAGEKIT_QT2_INCLUDE_DIR PACKAGEKIT_QT2_LIB)

