
/*
 * Copyright (C) 2007 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu_password.c 2402 2007-07-02 15:22:05Z mschwerin $
 *
 */
#include "config.h"

#include <crypt.h>

#include "i18n.h"
#include "heap.h"
#include "logger.h"
#include "menu_base.h"
#include "menu_password.h"
#include "otk.h"
#include "oxine.h"
#include "utils.h"

extern oxine_t *oxine;

static char *mrl_cache = NULL;
static char *pwd_cache = NULL;
static bool remember = false;

static otk_widget_t *password_editbox = NULL;


static void
password_set_now_cb (void *p, char *pwd)
{
    pwd_cache = pwd;

    show_menu_backto ();
}


static void
get_password_ok_cb (void *p)
{
    assert (password_editbox);
    password_set_now_cb (p, otk_editbox_get_text (password_editbox));
}


static void
get_password_cancel_cb (void *p)
{
    ho_free (pwd_cache);
    ho_free (mrl_cache);

    show_menu_backto ();
}


static void
get_password_remember_cb (void *p)
{
    remember = !remember;
}


bool
check_password_for_mrl (const char *mrl, const char *pwd)
{
    if (!mrl || !pwd) {
        return false;
    }

    if (mrl_cache && (strcmp (mrl_cache, mrl) == 0)) {
        if ((strcmp (pwd_cache, pwd) == 0)
            || (strcmp (crypt (pwd_cache, pwd), pwd) == 0)) {
            if (!remember) {
                ho_free (pwd_cache);
                pwd_cache = NULL;
                ho_free (mrl_cache);
                mrl_cache = NULL;
            }
            return true;
        }
    }

    ho_free (pwd_cache);
    ho_free (mrl_cache);
    mrl_cache = ho_strdup (mrl);

    create_new_window (false, true);
    otk_border_new (oxine->otk, 100, 180, 600, 240);

    otk_label_new (oxine->otk, 120, 230, 560,
                   OTK_ALIGN_LEFT | OTK_ALIGN_BOTTOM,
                   _("Please enter the password:"));

    password_editbox = otk_editbox_new (oxine->otk, 120, 250, 560, 40, 100,
                                        NULL, NULL, password_set_now_cb,
                                        oxine);
    otk_editbox_is_password (password_editbox, true);
    otk_widget_set_focused (password_editbox, true);

    otk_checkbox_new (oxine->otk, 120, 310, 30, remember,
                      get_password_remember_cb, oxine);
    otk_label_new (oxine->otk, 170, 325, 500,
                   OTK_ALIGN_LEFT | OTK_ALIGN_VCENTER,
                   _("Remember password?"));

    otk_widget_t *b;
    b = otk_text_button_new (oxine->otk, 230, 360, 160, 40, _("OK"),
                             get_password_ok_cb, oxine);
    otk_widget_set_alignment (b, OTK_ALIGN_CENTER);
    b = otk_text_button_new (oxine->otk, 410, 360, 160, 40, _("Cancel"),
                             get_password_cancel_cb, oxine);
    otk_widget_set_alignment (b, OTK_ALIGN_CENTER);

    show_user_interface (NULL);
    show_menu_background (NULL);

    return false;
}


void
free_menu_password (void)
{
    ho_free (pwd_cache);
    ho_free (mrl_cache);
}
