
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: odk.h 1100 2006-09-09 15:41:29Z mschwerin $
 *
 */

#ifndef HAVE_ODK_OSD_H
#define HAVE_ODK_OSD_H
#ifdef __cplusplus
extern "C" {
#endif

/* 
 * ***************************************************************************
 * Description:     width and height of the OSD.
 * ***************************************************************************
 */
#define OSD_WIDTH 800
#define OSD_HEIGHT 600

/*
 * ***************************************************************************
 * Description:     alignment values for text
 * ***************************************************************************
 */
#define ODK_ALIGN_LEFT              (0x001)
#define ODK_ALIGN_CENTER            (0x002)
#define ODK_ALIGN_RIGHT             (0x004)
#define ODK_ALIGN_TOP               (0x008)
#define ODK_ALIGN_VCENTER           (0x010)
#define ODK_ALIGN_BOTTOM            (0x020)

/*
 * ***************************************************************************
 * Description:     available bitmaps
 * ***************************************************************************
 */
#define BITMAP_SIMPLE_ARROW_UP      (1)
#define BITMAP_SIMPLE_ARROW_DOWN    (2)
#define BITMAP_POWEROFF             (3)
#define BITMAP_HOME                 (4)
#define BITMAP_FOLDER               (5)
#define BITMAP_PLAYLIST             (6)
#define BITMAP_VOLUME               (7)
#define BITMAP_PLUS                 (8)
#define BITMAP_MINUS                (9)
#define BITMAP_MUTE                 (10)
#define BITMAP_ARROW_UP             (11)
#define BITMAP_ARROW_DOWN           (12)
#define BITMAP_ARROW_LEFT           (13)
#define BITMAP_ARROW_RIGHT          (14)
#define BITMAP_CHECK                (15)

typedef struct odk_osd_image_s odk_osd_image_t;

void odk_osd_show (odk_t * odk);
void odk_osd_hide (odk_t * odk);
void odk_osd_clear (odk_t * odk);

uint8_t *odk_get_bitmap (int type);

void odk_draw_point (odk_t * odk, int x, int y, int color);
void odk_draw_line (odk_t * odk, int x1, int y1, int x2, int y2, int color);
void odk_draw_rect (odk_t * odk, int x1, int y1, int x2, int y2, int color,
                    bool filled);
void odk_draw_text (odk_t * odk, int x, int y, const char *text,
                    int alignment, int color_base);
void odk_draw_bitmap (odk_t * odk, uint8_t * bitmap, int x1, int y1,
                      int width, int height, uint8_t * palette_map);


void odk_get_text_size (odk_t * odk, const char *text,
                        int *width, int *height);
void odk_osd_set_font (odk_t * odk, const char *font, int font_size);
int odk_osd_alloc_text_palette (odk_t * odk, uint32_t fg_color,
                                uint8_t fg_trans, uint32_t bg_color,
                                uint8_t bg_trans, uint32_t bo_color,
                                uint8_t bo_trans);
int odk_osd_get_color (odk_t * odk, uint32_t color, uint8_t trans);
int odk_is_osd_visible (odk_t * odk);

/* Draws the image into the standard OSD. */
odk_osd_image_t *odk_osd_draw_image (odk_t * odk, const char *mrl,
                                     int x, int y, int width, int height,
                                     int alignment,
                                     bool border_draw, uint32_t border_color);

/* Draws the image into a separate OSD and shows that. */
odk_osd_image_t *odk_osd_show_image (odk_t * odk, const char *mrl,
                                     int x, int y, int width, int height,
                                     int alignment,
                                     bool border_draw, uint32_t border_color);
void odk_osd_hide_image (odk_osd_image_t * image);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_ODK_OSD_H */
