///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/**
 * \file Window3DContainer.h
 * \brief Contains the definition of the Core::Window3DContainer class.
 */

#ifndef __OVITO_WINDOW3D_CONTAINER_H
#define __OVITO_WINDOW3D_CONTAINER_H

#include <core/Core.h>
#include <base/utilities/Color.h>

namespace Core {

class Window3D;		// defined in Window3D.h

/**
 * \brief Container widget for 3d window viewports.
 *
 * The Window3DContainer class is a Qt widget that contains one or more
 * instances of the Window3D class. Each Window3D instance is an independent
 * OpenGL drawing area, a so-called viewport.
 *
 * \author Alexander Stukowski
 * \sa Window3D
 */
class CORE_DLLEXPORT Window3DContainer : public QWidget
{
	Q_OBJECT

public:

	/// \brief Constructor that creates a new empty 3d window container.
	/// \param parent The parent widget.
	Window3DContainer(QWidget* parent = NULL);

	/// \brief Returns the list of 3d windows in this container.
	/// \return The returned list contains all instances of the Window3D class stored in this container.
	QList<Window3D*> windows() const;

	/// \brief Returns whether the container or one of its windows is currently being rendered.
	/// \return \c true when the window is currently being rendered; \c false otherwise.
	bool isRendering() const;
};

};

#endif // __OVITO_WINDOW3D_CONTAINER_H
