//
// $Id: SubstringFunction.cpp 4135 2007-06-22 14:10:55Z bakerj $
//
//****************************************************************************************//
// Copyright (c) 2002-2007, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "SubstringFunction.h"

//****************************************************************************************//
//								Component Class											  //	
//****************************************************************************************//
SubstringFunction::SubstringFunction(int start, int length) : AbsFunctionComponent() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a compelete Component object
	//
	// -----------------------------------------------------------------------

	this->SetStart(start);
	this->SetLength(length);
}

SubstringFunction::~SubstringFunction() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	//
	// -----------------------------------------------------------------------
}

// ***************************************************************************************	//
//								 Public members												//
// ***************************************************************************************	//
int SubstringFunction::GetStart() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the start field's value
	//
	// -----------------------------------------------------------------------

	return this->start;
}

void SubstringFunction::SetStart(int start) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the start field's value
	//
	// -----------------------------------------------------------------------

	this->start = start;
}

int SubstringFunction::GetLength() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the length field's value
	//
	// -----------------------------------------------------------------------

	return this->length;
}

void SubstringFunction::SetLength(int length) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the length field's value
	//
	// -----------------------------------------------------------------------

	this->length = length;
}

ComponentValue* SubstringFunction::ComputeValue() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	get the values of the associated component
	//	loop through them all and get the substring.
	//	return all stored substrings
	//  Allows only one component.
	// -----------------------------------------------------------------------

	StringVector* values = NULL;
	
	AbsComponent* component = this->GetComponents()->at(0);

	ComponentValue* componentValue = component->ComputeValue();

	// create and populate a result ComponentValue
	ComponentValue* result = new ComponentValue();
	result->SetFlag(componentValue->GetFlag());
	result->AppendMessages(componentValue->GetMessages());

	if(componentValue->GetFlag() == OvalEnum::FLAG_COMPLETE) {
		values = new StringVector();;

		StringVector::iterator iterator;
		for(iterator = componentValue->GetValues()->begin(); iterator != componentValue->GetValues()->end(); iterator++) {
			string currentValue = (*iterator);
			string newValue = currentValue.substr(this->GetStart()-1, this->GetLength());
			values->push_back(newValue);
		}
		result->SetValues(values);
	}

	delete componentValue;

	result->SetFlag(componentValue->GetFlag());

	return result;	
}

void SubstringFunction::Parse(DOMElement* componentElm) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	parse the component element
	// -----------------------------------------------------------------------

	// get teh start and length attrs
	string start = XmlCommon::GetAttributeByName(componentElm, "substring_start");
	this->SetStart(atoi(start.c_str()));
	string length = XmlCommon::GetAttributeByName(componentElm, "substring_length");
	this->SetLength(atoi(length.c_str()));

	// Loop through all child elements
	// there should only ever be one 
	DOMNodeList *componentElms = componentElm->getChildNodes();
	unsigned int index = 0;
	while(index < componentElms->getLength()) {
		DOMNode *tmpNode = componentElms->item(index);
		if (tmpNode->getNodeType() == DOMNode::ELEMENT_NODE) {
			DOMElement *childElm = (DOMElement*)tmpNode;

			// Call the ComponentFactory
			AbsComponent* absComponent = ComponentFactory::GetComponent(childElm);
			// store the returned component
			this->AppendComponent(absComponent);			
		}
		index ++;
	}
}

VariableValueVector* SubstringFunction::GetVariableValues() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	return the variable values used to compute this function's value
	// -----------------------------------------------------------------------
	
	VariableValueVector* values = new VariableValueVector();
	AbsComponentVector* components = this->GetComponents();
	AbsComponentVector::iterator iterator;
	for(iterator = components->begin(); iterator != components->end(); iterator++) {
		AbsComponent* component = (AbsComponent*)(*iterator);
		VariableValueVector* tmp = component->GetVariableValues();
		VariableValueVector::iterator varIterator;
		for(varIterator = tmp->begin(); varIterator != tmp->end(); varIterator++) {
			values->push_back((*varIterator));
		}
		// TODO - do i need this delte call?
		//delete tmp;
		//tmp = NULL;
	}

	return values;
}
