//
// $Id: REGEX.h 3876 2007-03-29 18:16:55Z bakerj $
//
//****************************************************************************************//
// Copyright (c) 2002-2007, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef REGEX_H
#define REGEX_H

#include "Exception.h"

//	required regex include
#include <pcre.h> 

#include <sstream>
#include <string>

using namespace std;

/**	The MAXMATCHES constant should be used by any search method to ensure that
	endless/excessive matching searching doesn't occure. With out some sort of 
	maximum it is possible to match so many items that the system would run out 
	of memory.
*/
#define MAXMATCHES 5000

/**
	This class provides pattern matching support to the application.
	inaddition to pattern mathcin support several related methods are also provided.
	This class uses the pcre library found at www.pcre.org for pattern matching. 
*/
class REGEX {
public:
	REGEX();
	~REGEX();

	string	EscapeRegexChars(string);
	int		FindFirstRegexChar(const string stringIn);
	int		FindLastRegexChar(const string stringIn);
	void	GetConstantPortion(string patternIn, string delimIn, string *patternOut, string *constOut);
	
	/**	Return true if the searchString matches the specifed pattern
		Regular expression support is provided by the REGEX library package,
		which is open source software, written by Philip Hazel, and copyright
		by the University of Cambridge, England. 

		Download site:	ftp://ftp.csx.cam.ac.uk/pub/software/programming/REGEX/
	*/
	bool	IsMatch(const char *patternIn, const char *searchStringIn);
	string	RemoveExtraSlashes(string);
	void	Reset();

private:
	bool IsConstant(string);

	int matchCount;
};

/** 
	This class represents an Exception that occured while processing a regex.
*/
class REGEXException : public Exception {
public:
	REGEXException(string errMsgIn = "", int severity = ERROR_FATAL);
	~REGEXException();
};

#endif
