#!/usr/bin/python
#
#    powernap.py - handles powernap's config and initializes Monitors.
#
#    Copyright (C) 2011 Canonical Ltd.
#
#    Authors: Andres Rodriguez <andreserl@canonical.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, version 3 of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from base64 import b64encode
from cStringIO import StringIO
from gzip import GzipFile
import commands, os

_LATE_COMMAND_TEMPLATE = """
orchestra_dir="/var/lib/orchestra/"
mkdir -p $orchestra_dir
cat > "$orchestra_dir"/ssl-cert-orchestra-ca.pem <<"EOF"
%s
EOF
"""

_KSMETA_LATE_COMMAND_TEMPLATE = (
    "in-target sh -c '"
        "f=$1; "
        "shift; "
        "echo $0 | base64 --decode | gunzip > $f "
        "&& chmod u+x $f "
        "&& $f $*"
    "' %s /root/keys-late-command")
#    "in-target sh -c 'echo $0 | base64 --decode | gunzip | sh -' %s")

def base64_gzip(content):
    gzipped = StringIO()
    gzip_file = GzipFile(fileobj=gzipped, mode="wb", compresslevel=9)
    gzip_file.write(content)
    gzip_file.close()
    return b64encode(gzipped.getvalue())

def open_file(file):
    try:
        fp = open(file)
        output = fp.read()
        fp.close()
    except:
        return False
    return output

def get_late_command():
    content = open_file("/var/lib/orchestra/ssl-cert-orchestra-ca.pem")
    # If file does not exist, or no content, then return "true" string
    # so that preseed does not fail (LP: #891915)
    if not content:
       return "true"
    late_command = _LATE_COMMAND_TEMPLATE % content
    encoded_content = base64_gzip(late_command)
    return _KSMETA_LATE_COMMAND_TEMPLATE % encoded_content
