module Puppet::Parser::Functions

newfunction(:servercloudtype, :type => :rvalue) do
        if (FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/ec2rc") && FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/eucarc"))
            raise Puppet::ParseError, "File conflict, can't determine cloud type"
        elsif (FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/ec2rc") && FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/novarc"))
            raise Puppet::ParseError, "File conflict, can't determine cloud type"
        elsif (FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/eucarc") && FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/novarc"))
            raise Puppet::ParseError, "File conflict, can't determine cloud type"
        elsif FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/eucarc")
            servercloudtype = 'UEC'
        elsif FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/ec2rc")
            servercloudtype = 'EC2'
        elsif FileTest.exists?("/etc/puppet/modules/puppet-cloudconfig/files/novarc")
            servercloudtype = 'NOVA'
        else
            raise Puppet::ParseError, "No files, can't determine cloudtype"
        end
       return servercloudtype
    end
end
