class mysqlebs_slave  ($clustername = '', $cloudzone = '') {

    # Need to create random id
	$serverid = fqdn_rand(9999)

    include mysqlebs_base
    class { puppet-cloudconfig: mycloudzone => $cloudzone, snapshot => true, clustername => $clustername }

	exec{"create_cluster_data_dir":
		command => "mkdir -p /etc/mysqlebs/cluster_data/${clustername}/",
		unless => "test -d /etc/mysqlebs/cluster_data/${clustername}/",
	} 
	File <<| tag == "mysqlebs_${clustername}" |>> { require => Exec["create_cluster_data_dir"] }

    # Capture master replication point
    exec {"capture-replicationpoint":
        command => "true ; SNAPSHOTID=`cat /tmp/snapshotid` ; mysql -Bs -ureplicator -preplica-c4n0n1c4l -h\$(cat /etc/mysqlebs/cluster_data/${clustername}/master_ipaddress) mysql -e \"select binlog_file,binlog_position from replication where snapshot='\$SNAPSHOTID'\" > /tmp/.mysql-master-replicationpoint",
        unless => "test -f /tmp/.mysql-master-replicationpoint", 
        require => Exec["mount-mysql-volume-slave"],
    }

    # Start syncing with master
    exec {"start-sync":
        command => "rm -f /var/lib/mysql/master.info; chown mysql:mysql /var/lib/mysql; service mysql restart; MASTER_HOST=`cat /etc/mysqlebs/cluster_data/${clustername}/master_ipaddress`; MASTER_LOG_POS=`cat /tmp/.mysql-master-replicationpoint | awk '{print \$2}'`; MASTER_LOG_FILE=`cat /tmp/.mysql-master-replicationpoint | awk '{print \$1}'`; mysql -uroot -e \"CHANGE MASTER TO MASTER_HOST='\$MASTER_HOST', MASTER_USER='replicator', MASTER_PASSWORD='replica-c4n0n1c4l', MASTER_LOG_FILE='\$MASTER_LOG_FILE', MASTER_LOG_POS=\$MASTER_LOG_POS; START SLAVE;\"; touch /tmp/.mysql-master-replicationstarted",
        unless => "test -f /tmp/.mysql-master-replicationstarted", 
        require => Exec["capture-replicationpoint"],
    }


}

