class mysqlebs_master ($clustername = '', $cloudzone = '', $volname = '') {
# Need: snapshot taker
# Need: cron
#
    # Server ID needs to go before the includes
    $serverid='1'

    include mysqlebs_base
    class { puppet-cloudconfig: mycloudzone => $cloudzone, snapshot => false, volsize => "10", volname => $volname, clustername => $clustername }

    if ( $volname == "" ) {
        # Create volume, replicate data
        exec{"replicate-initialmysql":
            command => "service mysql stop ; rsync -avp /var/lib/mysql.old/* /var/lib/mysql ; rm -rf /var/lib/mysql.old ; chown -R mysql:mysql /var/lib/mysql ; service mysql start",
            onlyif => "test -d /var/lib/mysql.old",
            require => Exec["mount-mysql-volume-master"],
        }
    } else {
        exec{"replicate-initialmysql":
            command => "service mysql stop ; chown -R mysql:mysql /var/lib/mysql ; service mysql start",
            unless => "find /var/lib/mysql -type f -user mysql | wc -l",
            require => Exec["mount-mysql-volume-master"],
        }
    }

    exec{"create_mysql_replication_user":
        command => "mysql -uroot mysql -e \"GRANT SELECT, PROCESS, FILE, SUPER, REPLICATION CLIENT, REPLICATION SLAVE, RELOAD ON *.* TO replicator@\'%\' identified by \'replica-c4n0n1c4l\'; flush privileges;\"",
        onlyif => "mysql -uroot mysql -e \"select * from user where User=\'replicator\'\" 2> /dev/null | wc -l",
        require => Exec["replicate-initialmysql"],
    }

    exec{"initial_snapshot":
        command => "/usr/local/bin/ebs-snapshot.sh -t $(cat /tmp/.cloudtype) -c $(cat /tmp/.cloudsource) -l root: ; touch /tmp/.initial-snapshot-done",
        unless => "test -f /tmp/.initial-snapshot-done",
        require => Exec["create_mysql_replication_user"],
    }

    # Define snapshot cron
    # Find unless dependency
    file { "snapshot_script":
        path    => "/usr/local/bin/ebs-snapshot.sh",
        owner   => root,
        group   => root,
        mode    => 700,
        source  => "puppet:///canonical-mysqlEBS/ebs-snapshot.sh",
    }
	$mycloudtype = inline_template("<%= scope.lookupvar('puppet-cloudconfig::clustercloudtype') %>") 
	$mycloudsource = inline_template("<%= scope.lookupvar('puppet-cloudconfig::sourcecloud') %>") 
    file { "snapshot_cron":
        path    => "/etc/cron.d/snapshot_cron",
        owner   => root,
        group   => root,
        mode    => 444,
		content => template("/etc/puppet/modules/orchestra-mysqlEBS/templates/snapshot_cron.erb"),
        require => Exec["create_mysql_replication_user"],
    }

    # Exported resources execs
    exec{"create_cluster_data_dir":
        command => "mkdir -p /etc/mysqlebs/cluster_data/${clustername}",
        unless => "test -d /etc/mysqlebs/cluster_data/${clustername}",
    }
    # Exported resources
    @@file { "/etc/mysqlebs/cluster_data/${clustername}/master_ipaddress":
        content => "${ipaddress}", 
        tag => "mysqlebs_${clustername}",
        ensure => present,
        require => Exec["create_cluster_data_dir"],
    }

}

