class mongodb_master ( 
  $deploymentname = $uniqueid, 
  $dbhost = $ipaddress_eth0, 
  $dbport = '27017', 
  $dbdatadir = '/var/lib/mongodb/data') 
{
  include mongodb

  exec{"mkdir -p /etc/mongodb/deployments/${deploymentname}":
    unless => "test -d /etc/mongodb/deployments/${deploymentname}",
  }

  @@file{ "/etc/mongodb/deployments/${deploymentname}/dbhost.deployment_data": 
    content => "${dbhost}:${dbport}", 
    tag => "mongodb_${deploymentname}", 
    ensure => present 
  } 

  @@file{ "/etc/mongodb/deployments/${deploymentname}/dbdatadir.deployment_data": 
    content => "${dbdatadir}", 
    tag => "mongodb_${deploymentname}", 
    ensure => present 
  } 

  package{"mongodb-stable": 
    alias => "mongodb",
    ensure => installed,
    require => [ Apt::Source["mongodb"], Exec["apt_update"] ],
  }

  file {"mongodb_config":
    name    => "/etc/mongodb.conf",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Package["mongodb"],
  }

  file {"mongodb_upstart":
    name    => "/etc/init/mongodb.conf",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Package["mongodb"],
  }

  service {"mongodb":
    ensure => running,
    enable => true,
    subscribe => [ File["mongodb_config"], File["mongodb_upstart"] ],
    hasstatus => true,
    require => Package["mongodb"],
  }

  exec{ "update_mongo_upstart": 
    command => "/bin/sed -i /etc/init/mongodb.conf -e 's/-- --config/-- --replSet ${deploymentname} --config/'", 
    unless => "grep replSet /etc/init/mongodb.conf", 
    require => Package["mongodb"],
    notify => Service["mongodb"],
  }

  exec{"initiate_replica_set":
    command => "/usr/bin/mongo --eval 'rs.initiate()'",
    require => Exec["update_mongo_upstart"],
  }

} 
