///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2012 DreamWorks Animation LLC
//
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
//
// Redistributions of source code must retain the above copyright
// and license notice and the following restrictions and disclaimer.
//
// *     Neither the name of DreamWorks Animation nor the names of
// its contributors may be used to endorse or promote products derived
// from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// IN NO EVENT SHALL THE COPYRIGHT HOLDERS' AND CONTRIBUTORS' AGGREGATE
// LIABILITY FOR ALL CLAIMS REGARDLESS OF THEIR BASIS EXCEED US$250.00.
//
///////////////////////////////////////////////////////////////////////////

#ifndef OPENVDB_TOOLS_LINEARINTERP_HAS_BEEN_INCLUDED
#define OPENVDB_TOOLS_LINEARINTERP_HAS_BEEN_INCLUDED

#include <openvdb/Types.h>
#include "GridSampling.h"
#include "GridTransformer.h" // for BoxSampler


namespace openvdb {
OPENVDB_USE_VERSION_NAMESPACE
namespace OPENVDB_VERSION_NAME {
namespace tools {

/// @brief Performs linear interpolation on a grid voxel to sample space.
template<typename TreeType>
class LinearInterp: public GridSampling<TreeType>
{
public:
    typedef GridSampling<TreeType>                        BaseType;
    typedef boost::shared_ptr<LinearInterp<TreeType> >    Ptr;
    typedef typename TreeType::ValueType ValueType;
    /// use GridSampler<TreeType, openvdb::tools::BoxSampler> 
    OPENVDB_DEPRECATED explicit LinearInterp(const TreeType& tree): BaseType(tree) {}
    virtual ~LinearInterp() {}

    /// Sample space at a point defined by (x, y, z) in a grid by linear
    /// interpolation of values in adjacent voxels.
    /// @param x x-coordinate of point in voxel-coordinates of grid
    /// @param y y-coordinate of point in voxel-coordinates of grid
    /// @param z z-coordinate of point in voxel-coordinates of grid
    virtual ValueType sampleVoxel(Real x, Real y, Real z) const
    {  
        ValueType result = zeroVal<ValueType>();
        BoxSampler::sample(BaseType::mTree, Vec3R(x, y, z), result);
        return result;
    }

private:
    // Disallow copying of instances of this class.
    LinearInterp(const LinearInterp& other);
    LinearInterp& operator=(const LinearInterp& other);
};

   
} // namespace tools
} // namespace OPENVDB_VERSION_NAME
} // namespace openvdb

#endif // OPENVDB_TOOLS_LINEARINTERP_HAS_BEEN_INCLUDED

// Copyright (c) 2012 DreamWorks Animation LLC
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
